/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.execution;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecutionRequestSource
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.execution,record ExecutionRequestSource{/**The type of the execution request source, e.g. INGESTION_SOURCE*/type:string/**The urn of the ingestion source associated with the ingestion request. Present if type is INGESTION_SOURCE*/@Relationship={\"entityTypes\":[\"dataHubIngestionSource\"],\"name\":\"ingestionSource\"}@Searchable={\"fieldName\":\"ingestionSource\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}ingestionSource:optional{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}", SchemaFormatType.PDL);
    private String _typeField = null;
    private Urn _ingestionSourceField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_IngestionSource = SCHEMA.getField("ingestionSource");

    public ExecutionRequestSource() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public ExecutionRequestSource(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public String getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._typeField;
    }

    public ExecutionRequestSource setType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.execution.ExecutionRequestSource");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value);
                this._typeField = value;
            }
        }
        return this;
    }

    public ExecutionRequestSource setType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.execution.ExecutionRequestSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value);
        this._typeField = value;
        return this;
    }

    public boolean hasIngestionSource() {
        if (this._ingestionSourceField != null) {
            return true;
        }
        return this._map.containsKey("ingestionSource");
    }

    public void removeIngestionSource() {
        this._map.remove("ingestionSource");
    }

    @Nullable
    public Urn getIngestionSource(GetMode mode) {
        return this.getIngestionSource();
    }

    @Nullable
    public Urn getIngestionSource() {
        if (this._ingestionSourceField != null) {
            return this._ingestionSourceField;
        }
        Object __rawValue = this._map.get("ingestionSource");
        this._ingestionSourceField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._ingestionSourceField;
    }

    public ExecutionRequestSource setIngestionSource(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIngestionSource(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIngestionSource();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "ingestionSource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._ingestionSourceField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "ingestionSource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._ingestionSourceField = value;
            }
        }
        return this;
    }

    public ExecutionRequestSource setIngestionSource(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field ingestionSource of com.linkedin.execution.ExecutionRequestSource to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "ingestionSource", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._ingestionSourceField = value;
        return this;
    }

    @Override
    public ExecutionRequestSource clone() throws CloneNotSupportedException {
        ExecutionRequestSource __clone = (ExecutionRequestSource)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public ExecutionRequestSource copy() throws CloneNotSupportedException {
        ExecutionRequestSource __copy = (ExecutionRequestSource)super.copy();
        __copy._typeField = null;
        __copy._ingestionSourceField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final ExecutionRequestSource __objectRef;

        private ChangeListener(ExecutionRequestSource reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "ingestionSource": {
                    this.__objectRef._ingestionSourceField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec ingestionSource() {
            return new PathSpec(this.getPathComponents(), "ingestionSource");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withIngestionSource() {
            this.getDataMap().put("ingestionSource", 1);
            return this;
        }
    }
}

