/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.entity;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.entity.Aspect;
import com.linkedin.entity.AspectType;
import com.linkedin.mxe.SystemMetadata;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnvelopedAspect
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.entity/**An aspect, along with the metadata about it.\nCurrently, an aspect can be either of type 'timestamp' or 'versioned'.\n*/record EnvelopedAspect{/**The name of the aspect\n*/name:string/**The type of the aspect, either timeseries or versioned\n*/type:/**The type of a DataHub aspect*/enum AspectType{/**Designates an aspect that has a monotonically increasing version number*/VERSIONED/**Designates an aspect that represents a point-in-time data point*/TIMESERIES}/**The version of the aspect, only populated if type is 'VERSIONED'\n*/version:optional long/**The timestamp of the aspect, only populated if type is 'TIMESTAMP'\n*/timestamp:optional long/**The raw value of the aspect\n*/value:/**Placeholder PDL record to store the aspect in the response. By using this place-holder, metadata-service can return\nany type of aspect without having to define a single union class*/record Aspect{}/**The audit stamp detailing who the aspect was created by and when\n*/created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**The system metadata for this aspect\n*/systemMetadata:optional{namespace com.linkedin.mxe/**Metadata associated with each metadata change that is processed by the system*/@Aspect.name=\"systemMetadata\"record SystemMetadata{/**The timestamp the metadata was observed at*/lastObserved:optional long=0/**The original run id that produced the metadata. Populated in case of batch-ingestion.*/runId:optional string=\"no-run-id-provided\"/**The last run id that produced the metadata. Populated in case of batch-ingestion.*/lastRunId:optional string=\"no-run-id-provided\"/**The ingestion pipeline id that produced the metadata. Populated in case of batch ingestion.*/pipelineName:optional string/**The model registry name that was used to process this event*/registryName:optional string/**The model registry version that was used to process this event*/registryVersion:optional string/**Additional properties*/properties:optional map[string,string]/**Aspect version\n   Initial implementation will use the aspect version's number, however stored as\n   a string in the case where a different aspect versioning scheme is later adopted.*/version:optional string/**When the aspect was initially created and who created it, detected by version 0 -> 1 change*/aspectCreated:optional com.linkedin.common.AuditStamp/**When the aspect was last modified and the actor that performed the modification*/aspectModified:optional com.linkedin.common.AuditStamp}}}", SchemaFormatType.PDL);
    private String _nameField = null;
    private AspectType _typeField = null;
    private Long _versionField = null;
    private Long _timestampField = null;
    private Aspect _valueField = null;
    private AuditStamp _createdField = null;
    private SystemMetadata _systemMetadataField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");
    private static final RecordDataSchema.Field FIELD_Timestamp = SCHEMA.getField("timestamp");
    private static final RecordDataSchema.Field FIELD_Value = SCHEMA.getField("value");
    private static final RecordDataSchema.Field FIELD_Created = SCHEMA.getField("created");
    private static final RecordDataSchema.Field FIELD_SystemMetadata = SCHEMA.getField("systemMetadata");

    public EnvelopedAspect() {
        super(new DataMap(10, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public EnvelopedAspect(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public EnvelopedAspect setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.entity.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public AspectType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AspectType.class, AspectType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AspectType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, AspectType.class, AspectType.$UNKNOWN);
        return this._typeField;
    }

    public EnvelopedAspect setType(@Nullable AspectType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.entity.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setType(@Nonnull AspectType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Long getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public Long getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._versionField;
    }

    public EnvelopedAspect setVersion(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setVersion(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public EnvelopedAspect setVersion(long value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceLongInput(value));
        this._versionField = value;
        return this;
    }

    public boolean hasTimestamp() {
        if (this._timestampField != null) {
            return true;
        }
        return this._map.containsKey("timestamp");
    }

    public void removeTimestamp() {
        this._map.remove("timestamp");
    }

    @Nullable
    public Long getTimestamp(GetMode mode) {
        return this.getTimestamp();
    }

    @Nullable
    public Long getTimestamp() {
        if (this._timestampField != null) {
            return this._timestampField;
        }
        Object __rawValue = this._map.get("timestamp");
        this._timestampField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampField;
    }

    public EnvelopedAspect setTimestamp(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestamp", DataTemplateUtil.coerceLongInput(value));
                this._timestampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestamp", DataTemplateUtil.coerceLongInput(value));
                this._timestampField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setTimestamp(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestamp of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestamp", DataTemplateUtil.coerceLongInput(value));
        this._timestampField = value;
        return this;
    }

    public EnvelopedAspect setTimestamp(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestamp", DataTemplateUtil.coerceLongInput(value));
        this._timestampField = value;
        return this;
    }

    public boolean hasValue() {
        if (this._valueField != null) {
            return true;
        }
        return this._map.containsKey("value");
    }

    public void removeValue() {
        this._map.remove("value");
    }

    @Nullable
    public Aspect getValue(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValue();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueField != null) {
                    return this._valueField;
                }
                Object __rawValue = this._map.get("value");
                this._valueField = __rawValue == null ? null : new Aspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._valueField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Aspect getValue() {
        if (this._valueField != null) {
            return this._valueField;
        }
        Object __rawValue = this._map.get("value");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("value");
        }
        this._valueField = __rawValue == null ? null : new Aspect(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._valueField;
    }

    public EnvelopedAspect setValue(@Nullable Aspect value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValue(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field value of com.linkedin.entity.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValue();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "value", value.data());
                this._valueField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setValue(@Nonnull Aspect value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field value of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "value", value.data());
        this._valueField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public EnvelopedAspect setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.entity.EnvelopedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasSystemMetadata() {
        if (this._systemMetadataField != null) {
            return true;
        }
        return this._map.containsKey("systemMetadata");
    }

    public void removeSystemMetadata() {
        this._map.remove("systemMetadata");
    }

    @Nullable
    public SystemMetadata getSystemMetadata(GetMode mode) {
        return this.getSystemMetadata();
    }

    @Nullable
    public SystemMetadata getSystemMetadata() {
        if (this._systemMetadataField != null) {
            return this._systemMetadataField;
        }
        Object __rawValue = this._map.get("systemMetadata");
        this._systemMetadataField = __rawValue == null ? null : new SystemMetadata(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._systemMetadataField;
    }

    public EnvelopedAspect setSystemMetadata(@Nullable SystemMetadata value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSystemMetadata(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSystemMetadata();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
                this._systemMetadataField = value;
            }
        }
        return this;
    }

    public EnvelopedAspect setSystemMetadata(@Nonnull SystemMetadata value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field systemMetadata of com.linkedin.entity.EnvelopedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "systemMetadata", value.data());
        this._systemMetadataField = value;
        return this;
    }

    @Override
    public EnvelopedAspect clone() throws CloneNotSupportedException {
        EnvelopedAspect __clone = (EnvelopedAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EnvelopedAspect copy() throws CloneNotSupportedException {
        EnvelopedAspect __copy = (EnvelopedAspect)super.copy();
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._typeField = null;
        __copy._systemMetadataField = null;
        __copy._versionField = null;
        __copy._valueField = null;
        __copy._timestampField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EnvelopedAspect __objectRef;

        private ChangeListener(EnvelopedAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "systemMetadata": {
                    this.__objectRef._systemMetadataField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "value": {
                    this.__objectRef._valueField = null;
                    break;
                }
                case "timestamp": {
                    this.__objectRef._timestampField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public PathSpec timestamp() {
            return new PathSpec(this.getPathComponents(), "timestamp");
        }

        public Aspect.Fields value() {
            return new Aspect.Fields(this.getPathComponents(), "value");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public SystemMetadata.Fields systemMetadata() {
            return new SystemMetadata.Fields(this.getPathComponents(), "systemMetadata");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private Aspect.ProjectionMask _valueMask;
        private AuditStamp.ProjectionMask _createdMask;
        private SystemMetadata.ProjectionMask _systemMetadataMask;

        ProjectionMask() {
            super(10);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withTimestamp() {
            this.getDataMap().put("timestamp", 1);
            return this;
        }

        public ProjectionMask withValue(Function<Aspect.ProjectionMask, Aspect.ProjectionMask> nestedMask) {
            this._valueMask = nestedMask.apply(this._valueMask == null ? Aspect.createMask() : this._valueMask);
            this.getDataMap().put("value", this._valueMask.getDataMap());
            return this;
        }

        public ProjectionMask withValue() {
            this._valueMask = null;
            this.getDataMap().put("value", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withSystemMetadata(Function<SystemMetadata.ProjectionMask, SystemMetadata.ProjectionMask> nestedMask) {
            this._systemMetadataMask = nestedMask.apply(this._systemMetadataMask == null ? SystemMetadata.createMask() : this._systemMetadataMask);
            this.getDataMap().put("systemMetadata", this._systemMetadataMask.getDataMap());
            return this;
        }

        public ProjectionMask withSystemMetadata() {
            this._systemMetadataMask = null;
            this.getDataMap().put("systemMetadata", 1);
            return this;
        }
    }
}

