/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.FloatArray;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Histogram
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset,record Histogram{boundaries:array[string]heights:array[float]}", SchemaFormatType.PDL);
    private StringArray _boundariesField = null;
    private FloatArray _heightsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Boundaries = SCHEMA.getField("boundaries");
    private static final RecordDataSchema.Field FIELD_Heights = SCHEMA.getField("heights");

    public Histogram() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public Histogram(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasBoundaries() {
        if (this._boundariesField != null) {
            return true;
        }
        return this._map.containsKey("boundaries");
    }

    public void removeBoundaries() {
        this._map.remove("boundaries");
    }

    @Nullable
    public StringArray getBoundaries(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getBoundaries();
            }
            case DEFAULT: 
            case NULL: {
                if (this._boundariesField != null) {
                    return this._boundariesField;
                }
                Object __rawValue = this._map.get("boundaries");
                this._boundariesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._boundariesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringArray getBoundaries() {
        if (this._boundariesField != null) {
            return this._boundariesField;
        }
        Object __rawValue = this._map.get("boundaries");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("boundaries");
        }
        this._boundariesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._boundariesField;
    }

    public Histogram setBoundaries(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setBoundaries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field boundaries of com.linkedin.dataset.Histogram");
                }
                CheckedUtil.putWithoutChecking(this._map, "boundaries", value.data());
                this._boundariesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeBoundaries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "boundaries", value.data());
                this._boundariesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "boundaries", value.data());
                this._boundariesField = value;
            }
        }
        return this;
    }

    public Histogram setBoundaries(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field boundaries of com.linkedin.dataset.Histogram to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "boundaries", value.data());
        this._boundariesField = value;
        return this;
    }

    public boolean hasHeights() {
        if (this._heightsField != null) {
            return true;
        }
        return this._map.containsKey("heights");
    }

    public void removeHeights() {
        this._map.remove("heights");
    }

    @Nullable
    public FloatArray getHeights(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getHeights();
            }
            case DEFAULT: 
            case NULL: {
                if (this._heightsField != null) {
                    return this._heightsField;
                }
                Object __rawValue = this._map.get("heights");
                this._heightsField = __rawValue == null ? null : new FloatArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._heightsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FloatArray getHeights() {
        if (this._heightsField != null) {
            return this._heightsField;
        }
        Object __rawValue = this._map.get("heights");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("heights");
        }
        this._heightsField = __rawValue == null ? null : new FloatArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._heightsField;
    }

    public Histogram setHeights(@Nullable FloatArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHeights(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field heights of com.linkedin.dataset.Histogram");
                }
                CheckedUtil.putWithoutChecking(this._map, "heights", value.data());
                this._heightsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHeights();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "heights", value.data());
                this._heightsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "heights", value.data());
                this._heightsField = value;
            }
        }
        return this;
    }

    public Histogram setHeights(@Nonnull FloatArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field heights of com.linkedin.dataset.Histogram to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "heights", value.data());
        this._heightsField = value;
        return this;
    }

    @Override
    public Histogram clone() throws CloneNotSupportedException {
        Histogram __clone = (Histogram)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Histogram copy() throws CloneNotSupportedException {
        Histogram __copy = (Histogram)super.copy();
        __copy._heightsField = null;
        __copy._boundariesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Histogram __objectRef;

        private ChangeListener(Histogram reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "heights": {
                    this.__objectRef._heightsField = null;
                    break;
                }
                case "boundaries": {
                    this.__objectRef._boundariesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec boundaries() {
            return new PathSpec(this.getPathComponents(), "boundaries");
        }

        public PathSpec boundaries(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "boundaries");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec heights() {
            return new PathSpec(this.getPathComponents(), "heights");
        }

        public PathSpec heights(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "heights");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withBoundaries() {
            this.getDataMap().put("boundaries", 1);
            return this;
        }

        public ProjectionMask withBoundaries(Integer start, Integer count) {
            this.getDataMap().put("boundaries", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("boundaries").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("boundaries").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHeights() {
            this.getDataMap().put("heights", 1);
            return this;
        }

        public ProjectionMask withHeights(Integer start, Integer count) {
            this.getDataMap().put("heights", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("heights").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("heights").put("$count", count);
            }
            return this;
        }
    }
}

