/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DownstreamArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DownstreamLineage
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Downstream lineage of a dataset*/record DownstreamLineage{/**List of downstream dataset lineage information*/downstreams:array[/**Downstream lineage information about a dataset including the source reporting the lineage*/record Downstream{/**Audit stamp containing who reported the lineage and when*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**The downstream dataset the lineage points to*/dataset:{namespace com.linkedin.common/**Standardized dataset identifier.*/@java.class=\"com.linkedin.common.urn.DatasetUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized dataset identifier.\",\"entityType\":\"dataset\",\"fields\":[{\"doc\":\"Standardized platform urn where dataset is defined.\",\"name\":\"platform\",\"type\":\"com.linkedin.common.urn.DataPlatformUrn\"},{\"doc\":\"Dataset native name e.g. <db>.<table>, /dir/subdir/<name>, or <name>\",\"maxLength\":210,\"name\":\"datasetName\",\"type\":\"string\"},{\"doc\":\"Fabric type where dataset belongs to or where it was generated.\",\"name\":\"origin\",\"type\":\"com.linkedin.common.FabricType\"}],\"maxLength\":284,\"name\":\"Dataset\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref DatasetUrn=string}/**The type of the lineage*/type:/**The various types of supported dataset lineage*/enum DatasetLineageType{/**Direct copy without modification*/COPY/**Transformed data with modification (format or content change)*/TRANSFORMED/**Represents a view defined on the sources e.g. Hive view defined on underlying hive tables or a Hive table pointing to a HDFS dataset or DALI view defined on multiple sources*/VIEW}}]}", SchemaFormatType.PDL);
    private DownstreamArray _downstreamsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Downstreams = SCHEMA.getField("downstreams");

    public DownstreamLineage() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DownstreamLineage(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDownstreams() {
        if (this._downstreamsField != null) {
            return true;
        }
        return this._map.containsKey("downstreams");
    }

    public void removeDownstreams() {
        this._map.remove("downstreams");
    }

    @Nullable
    public DownstreamArray getDownstreams(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDownstreams();
            }
            case DEFAULT: 
            case NULL: {
                if (this._downstreamsField != null) {
                    return this._downstreamsField;
                }
                Object __rawValue = this._map.get("downstreams");
                this._downstreamsField = __rawValue == null ? null : new DownstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._downstreamsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public DownstreamArray getDownstreams() {
        if (this._downstreamsField != null) {
            return this._downstreamsField;
        }
        Object __rawValue = this._map.get("downstreams");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("downstreams");
        }
        this._downstreamsField = __rawValue == null ? null : new DownstreamArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._downstreamsField;
    }

    public DownstreamLineage setDownstreams(@Nullable DownstreamArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDownstreams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field downstreams of com.linkedin.dataset.DownstreamLineage");
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
                this._downstreamsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDownstreams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
                this._downstreamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
                this._downstreamsField = value;
            }
        }
        return this;
    }

    public DownstreamLineage setDownstreams(@Nonnull DownstreamArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field downstreams of com.linkedin.dataset.DownstreamLineage to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "downstreams", value.data());
        this._downstreamsField = value;
        return this;
    }

    @Override
    public DownstreamLineage clone() throws CloneNotSupportedException {
        DownstreamLineage __clone = (DownstreamLineage)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DownstreamLineage copy() throws CloneNotSupportedException {
        DownstreamLineage __copy = (DownstreamLineage)super.copy();
        __copy._downstreamsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DownstreamLineage __objectRef;

        private ChangeListener(DownstreamLineage reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "downstreams": {
                    this.__objectRef._downstreamsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DownstreamArray.Fields downstreams() {
            return new DownstreamArray.Fields(this.getPathComponents(), "downstreams");
        }

        public PathSpec downstreams(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "downstreams");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DownstreamArray.ProjectionMask _downstreamsMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withDownstreams(Function<DownstreamArray.ProjectionMask, DownstreamArray.ProjectionMask> nestedMask) {
            this._downstreamsMask = nestedMask.apply(this._downstreamsMask == null ? DownstreamArray.createMask() : this._downstreamsMask);
            this.getDataMap().put("downstreams", this._downstreamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withDownstreams() {
            this._downstreamsMask = null;
            this.getDataMap().put("downstreams", 1);
            return this;
        }

        public ProjectionMask withDownstreams(Function<DownstreamArray.ProjectionMask, DownstreamArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._downstreamsMask = nestedMask.apply(this._downstreamsMask == null ? DownstreamArray.createMask() : this._downstreamsMask);
            this.getDataMap().put("downstreams", this._downstreamsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("downstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreams").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDownstreams(Integer start, Integer count) {
            this._downstreamsMask = null;
            this.getDataMap().put("downstreams", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("downstreams").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("downstreams").put("$count", count);
            }
            return this;
        }
    }
}

