/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import com.linkedin.dataset.DatasetFieldUsageCountsArray;
import com.linkedin.dataset.DatasetUserUsageCountsArray;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DatasetUsageStatistics
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataset/**Stats corresponding to dataset's usage.*/@Aspect={\"name\":\"datasetUsageStatistics\",\"type\":\"timeseries\"}record DatasetUsageStatistics includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**Unique user count*/@Searchable={\"fieldType\":\"COUNT\",\"hasValuesFieldName\":\"hasUniqueUserCount\"}@TimeseriesField={}uniqueUserCount:optional int/**Total SQL query count*/@Searchable={\"fieldType\":\"COUNT\",\"hasValuesFieldName\":\"hasTotalSqlQueriesCount\"}@TimeseriesField={}totalSqlQueries:optional int/**Frequent SQL queries; mostly makes sense for datasets in SQL databases*/@TimeseriesField={}topSqlQueries:optional array[string]/**Users within this bucket, with frequency counts*/@TimeseriesFieldCollection.key=\"user\"userCounts:optional array[/**Records a single user's usage counts for a given resource*/record DatasetUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**Number of times the dataset has been used by the user.*/@TimeseriesField={}count:int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}]/**Field-level usage stats*/@TimeseriesFieldCollection.key=\"fieldPath\"fieldCounts:optional array[/**Records field-level usage counts for a given dataset*/record DatasetFieldUsageCounts{/**The name of the field.*/fieldPath:string/**Number of times the field has been used.*/@TimeseriesField={}count:int}]}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Integer _uniqueUserCountField = null;
    private Integer _totalSqlQueriesField = null;
    private StringArray _topSqlQueriesField = null;
    private DatasetUserUsageCountsArray _userCountsField = null;
    private DatasetFieldUsageCountsArray _fieldCountsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_UniqueUserCount;
    private static final RecordDataSchema.Field FIELD_TotalSqlQueries;
    private static final RecordDataSchema.Field FIELD_TopSqlQueries;
    private static final RecordDataSchema.Field FIELD_UserCounts;
    private static final RecordDataSchema.Field FIELD_FieldCounts;

    public DatasetUsageStatistics() {
        super(new DataMap(12, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public DatasetUsageStatistics(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public DatasetUsageStatistics setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.dataset.DatasetUsageStatistics");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public DatasetUsageStatistics setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public DatasetUsageStatistics setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public DatasetUsageStatistics setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public DatasetUsageStatistics setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return true;
        }
        return this._map.containsKey("uniqueUserCount");
    }

    public void removeUniqueUserCount() {
        this._map.remove("uniqueUserCount");
    }

    @Nullable
    public Integer getUniqueUserCount(GetMode mode) {
        return this.getUniqueUserCount();
    }

    @Nullable
    public Integer getUniqueUserCount() {
        if (this._uniqueUserCountField != null) {
            return this._uniqueUserCountField;
        }
        Object __rawValue = this._map.get("uniqueUserCount");
        this._uniqueUserCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._uniqueUserCountField;
    }

    public DatasetUsageStatistics setUniqueUserCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUniqueUserCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUniqueUserCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
                this._uniqueUserCountField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setUniqueUserCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field uniqueUserCount of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public DatasetUsageStatistics setUniqueUserCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "uniqueUserCount", DataTemplateUtil.coerceIntInput(value));
        this._uniqueUserCountField = value;
        return this;
    }

    public boolean hasTotalSqlQueries() {
        if (this._totalSqlQueriesField != null) {
            return true;
        }
        return this._map.containsKey("totalSqlQueries");
    }

    public void removeTotalSqlQueries() {
        this._map.remove("totalSqlQueries");
    }

    @Nullable
    public Integer getTotalSqlQueries(GetMode mode) {
        return this.getTotalSqlQueries();
    }

    @Nullable
    public Integer getTotalSqlQueries() {
        if (this._totalSqlQueriesField != null) {
            return this._totalSqlQueriesField;
        }
        Object __rawValue = this._map.get("totalSqlQueries");
        this._totalSqlQueriesField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._totalSqlQueriesField;
    }

    public DatasetUsageStatistics setTotalSqlQueries(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTotalSqlQueries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTotalSqlQueries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
                this._totalSqlQueriesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
                this._totalSqlQueriesField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setTotalSqlQueries(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field totalSqlQueries of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
        this._totalSqlQueriesField = value;
        return this;
    }

    public DatasetUsageStatistics setTotalSqlQueries(int value) {
        CheckedUtil.putWithoutChecking(this._map, "totalSqlQueries", DataTemplateUtil.coerceIntInput(value));
        this._totalSqlQueriesField = value;
        return this;
    }

    public boolean hasTopSqlQueries() {
        if (this._topSqlQueriesField != null) {
            return true;
        }
        return this._map.containsKey("topSqlQueries");
    }

    public void removeTopSqlQueries() {
        this._map.remove("topSqlQueries");
    }

    @Nullable
    public StringArray getTopSqlQueries(GetMode mode) {
        return this.getTopSqlQueries();
    }

    @Nullable
    public StringArray getTopSqlQueries() {
        if (this._topSqlQueriesField != null) {
            return this._topSqlQueriesField;
        }
        Object __rawValue = this._map.get("topSqlQueries");
        this._topSqlQueriesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._topSqlQueriesField;
    }

    public DatasetUsageStatistics setTopSqlQueries(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTopSqlQueries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTopSqlQueries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "topSqlQueries", value.data());
                this._topSqlQueriesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "topSqlQueries", value.data());
                this._topSqlQueriesField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setTopSqlQueries(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field topSqlQueries of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "topSqlQueries", value.data());
        this._topSqlQueriesField = value;
        return this;
    }

    public boolean hasUserCounts() {
        if (this._userCountsField != null) {
            return true;
        }
        return this._map.containsKey("userCounts");
    }

    public void removeUserCounts() {
        this._map.remove("userCounts");
    }

    @Nullable
    public DatasetUserUsageCountsArray getUserCounts(GetMode mode) {
        return this.getUserCounts();
    }

    @Nullable
    public DatasetUserUsageCountsArray getUserCounts() {
        if (this._userCountsField != null) {
            return this._userCountsField;
        }
        Object __rawValue = this._map.get("userCounts");
        this._userCountsField = __rawValue == null ? null : new DatasetUserUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._userCountsField;
    }

    public DatasetUsageStatistics setUserCounts(@Nullable DatasetUserUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserCounts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserCounts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
                this._userCountsField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setUserCounts(@Nonnull DatasetUserUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userCounts of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userCounts", value.data());
        this._userCountsField = value;
        return this;
    }

    public boolean hasFieldCounts() {
        if (this._fieldCountsField != null) {
            return true;
        }
        return this._map.containsKey("fieldCounts");
    }

    public void removeFieldCounts() {
        this._map.remove("fieldCounts");
    }

    @Nullable
    public DatasetFieldUsageCountsArray getFieldCounts(GetMode mode) {
        return this.getFieldCounts();
    }

    @Nullable
    public DatasetFieldUsageCountsArray getFieldCounts() {
        if (this._fieldCountsField != null) {
            return this._fieldCountsField;
        }
        Object __rawValue = this._map.get("fieldCounts");
        this._fieldCountsField = __rawValue == null ? null : new DatasetFieldUsageCountsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._fieldCountsField;
    }

    public DatasetUsageStatistics setFieldCounts(@Nullable DatasetFieldUsageCountsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldCounts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldCounts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldCounts", value.data());
                this._fieldCountsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldCounts", value.data());
                this._fieldCountsField = value;
            }
        }
        return this;
    }

    public DatasetUsageStatistics setFieldCounts(@Nonnull DatasetFieldUsageCountsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldCounts of com.linkedin.dataset.DatasetUsageStatistics to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldCounts", value.data());
        this._fieldCountsField = value;
        return this;
    }

    @Override
    public DatasetUsageStatistics clone() throws CloneNotSupportedException {
        DatasetUsageStatistics __clone = (DatasetUsageStatistics)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DatasetUsageStatistics copy() throws CloneNotSupportedException {
        DatasetUsageStatistics __copy = (DatasetUsageStatistics)super.copy();
        __copy._timestampMillisField = null;
        __copy._totalSqlQueriesField = null;
        __copy._topSqlQueriesField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._fieldCountsField = null;
        __copy._userCountsField = null;
        __copy._partitionSpecField = null;
        __copy._uniqueUserCountField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_UniqueUserCount = SCHEMA.getField("uniqueUserCount");
        FIELD_TotalSqlQueries = SCHEMA.getField("totalSqlQueries");
        FIELD_TopSqlQueries = SCHEMA.getField("topSqlQueries");
        FIELD_UserCounts = SCHEMA.getField("userCounts");
        FIELD_FieldCounts = SCHEMA.getField("fieldCounts");
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DatasetUsageStatistics __objectRef;

        private ChangeListener(DatasetUsageStatistics reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "totalSqlQueries": {
                    this.__objectRef._totalSqlQueriesField = null;
                    break;
                }
                case "topSqlQueries": {
                    this.__objectRef._topSqlQueriesField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "fieldCounts": {
                    this.__objectRef._fieldCountsField = null;
                    break;
                }
                case "userCounts": {
                    this.__objectRef._userCountsField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "uniqueUserCount": {
                    this.__objectRef._uniqueUserCountField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec uniqueUserCount() {
            return new PathSpec(this.getPathComponents(), "uniqueUserCount");
        }

        public PathSpec totalSqlQueries() {
            return new PathSpec(this.getPathComponents(), "totalSqlQueries");
        }

        public PathSpec topSqlQueries() {
            return new PathSpec(this.getPathComponents(), "topSqlQueries");
        }

        public PathSpec topSqlQueries(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "topSqlQueries");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public DatasetUserUsageCountsArray.Fields userCounts() {
            return new DatasetUserUsageCountsArray.Fields(this.getPathComponents(), "userCounts");
        }

        public PathSpec userCounts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "userCounts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public DatasetFieldUsageCountsArray.Fields fieldCounts() {
            return new DatasetFieldUsageCountsArray.Fields(this.getPathComponents(), "fieldCounts");
        }

        public PathSpec fieldCounts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "fieldCounts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;
        private DatasetUserUsageCountsArray.ProjectionMask _userCountsMask;
        private DatasetFieldUsageCountsArray.ProjectionMask _fieldCountsMask;

        ProjectionMask() {
            super(12);
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withUniqueUserCount() {
            this.getDataMap().put("uniqueUserCount", 1);
            return this;
        }

        public ProjectionMask withTotalSqlQueries() {
            this.getDataMap().put("totalSqlQueries", 1);
            return this;
        }

        public ProjectionMask withTopSqlQueries() {
            this.getDataMap().put("topSqlQueries", 1);
            return this;
        }

        public ProjectionMask withTopSqlQueries(Integer start, Integer count) {
            this.getDataMap().put("topSqlQueries", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("topSqlQueries").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("topSqlQueries").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUserCounts(Function<DatasetUserUsageCountsArray.ProjectionMask, DatasetUserUsageCountsArray.ProjectionMask> nestedMask) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DatasetUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            return this;
        }

        public ProjectionMask withUserCounts() {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", 1);
            return this;
        }

        public ProjectionMask withUserCounts(Function<DatasetUserUsageCountsArray.ProjectionMask, DatasetUserUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._userCountsMask = nestedMask.apply(this._userCountsMask == null ? DatasetUserUsageCountsArray.createMask() : this._userCountsMask);
            this.getDataMap().put("userCounts", this._userCountsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUserCounts(Integer start, Integer count) {
            this._userCountsMask = null;
            this.getDataMap().put("userCounts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("userCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("userCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFieldCounts(Function<DatasetFieldUsageCountsArray.ProjectionMask, DatasetFieldUsageCountsArray.ProjectionMask> nestedMask) {
            this._fieldCountsMask = nestedMask.apply(this._fieldCountsMask == null ? DatasetFieldUsageCountsArray.createMask() : this._fieldCountsMask);
            this.getDataMap().put("fieldCounts", this._fieldCountsMask.getDataMap());
            return this;
        }

        public ProjectionMask withFieldCounts() {
            this._fieldCountsMask = null;
            this.getDataMap().put("fieldCounts", 1);
            return this;
        }

        public ProjectionMask withFieldCounts(Function<DatasetFieldUsageCountsArray.ProjectionMask, DatasetFieldUsageCountsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._fieldCountsMask = nestedMask.apply(this._fieldCountsMask == null ? DatasetFieldUsageCountsArray.createMask() : this._fieldCountsMask);
            this.getDataMap().put("fieldCounts", this._fieldCountsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("fieldCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fieldCounts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withFieldCounts(Integer start, Integer count) {
            this._fieldCountsMask = null;
            this.getDataMap().put("fieldCounts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("fieldCounts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("fieldCounts").put("$count", count);
            }
            return this;
        }
    }
}

