/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dataprocess;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.dataprocess.DataProcessType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataProcessInstanceProperties
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dataprocess/**The inputs and outputs of this data process*/@Aspect.name=\"dataProcessInstanceProperties\"record DataProcessInstanceProperties includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Process name*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}name:string/**Process type*/@Searchable={\"addToFilters\":true,\"fieldName\":\"processType\",\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Process Type\"}type:optional enum DataProcessType{BATCH_SCHEDULED,BATCH_AD_HOC,STREAMING}/**Audit stamp containing who reported the lineage and when*/@Searchable.`/time`={\"fieldName\":\"created\",\"fieldType\":\"COUNT\",\"queryByDefault\":false}created:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _nameField = null;
    private DataProcessType _typeField = null;
    private AuditStamp _createdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Name;
    private static final RecordDataSchema.Field FIELD_Type;
    private static final RecordDataSchema.Field FIELD_Created;

    public DataProcessInstanceProperties() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public DataProcessInstanceProperties(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public DataProcessInstanceProperties setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.dataprocess.DataProcessInstanceProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceProperties setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.dataprocess.DataProcessInstanceProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public DataProcessInstanceProperties setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceProperties setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.dataprocess.DataProcessInstanceProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public DataProcessInstanceProperties setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.dataprocess.DataProcessInstanceProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceProperties setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.dataprocess.DataProcessInstanceProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public DataProcessType getType(GetMode mode) {
        return this.getType();
    }

    @Nullable
    public DataProcessType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, DataProcessType.class, DataProcessType.$UNKNOWN);
        return this._typeField;
    }

    public DataProcessInstanceProperties setType(@Nullable DataProcessType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceProperties setType(@Nonnull DataProcessType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.dataprocess.DataProcessInstanceProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCreated();
            }
            case DEFAULT: 
            case NULL: {
                if (this._createdField != null) {
                    return this._createdField;
                }
                Object __rawValue = this._map.get("created");
                this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._createdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("created");
        }
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public DataProcessInstanceProperties setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field created of com.linkedin.dataprocess.DataProcessInstanceProperties");
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public DataProcessInstanceProperties setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.dataprocess.DataProcessInstanceProperties to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    @Override
    public DataProcessInstanceProperties clone() throws CloneNotSupportedException {
        DataProcessInstanceProperties __clone = (DataProcessInstanceProperties)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataProcessInstanceProperties copy() throws CloneNotSupportedException {
        DataProcessInstanceProperties __copy = (DataProcessInstanceProperties)super.copy();
        __copy._externalUrlField = null;
        __copy._customPropertiesField = null;
        __copy._createdField = null;
        __copy._nameField = null;
        __copy._typeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Name = SCHEMA.getField("name");
        FIELD_Type = SCHEMA.getField("type");
        FIELD_Created = SCHEMA.getField("created");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataProcessInstanceProperties __objectRef;

        private ChangeListener(DataProcessInstanceProperties reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _createdMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }
    }
}

