/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public final class BytesArray
extends DirectArrayTemplate<ByteString> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"array\", \"items\" : \"bytes\" }");

    public BytesArray() {
        this(new DataList());
    }

    public BytesArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public BytesArray(Collection<ByteString> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public BytesArray(DataList list) {
        super(list, SCHEMA, ByteString.class, ByteString.class);
    }

    public BytesArray(ByteString first, ByteString ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    @Override
    public BytesArray clone() throws CloneNotSupportedException {
        return (BytesArray)super.clone();
    }

    @Override
    public BytesArray copy() throws CloneNotSupportedException {
        return (BytesArray)super.copy();
    }

    @Override
    protected Object coerceInput(ByteString object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return object;
    }

    @Override
    protected ByteString coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceBytesOutput(object);
    }
}

