/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.template;

import com.linkedin.data.DataList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.DirectArrayTemplate;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.util.ArgumentUtil;
import java.util.Arrays;
import java.util.Collection;

public final class BooleanArray
extends DirectArrayTemplate<Boolean> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("{ \"type\" : \"array\", \"items\" : \"boolean\" }");

    public BooleanArray() {
        this(new DataList());
    }

    public BooleanArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public BooleanArray(Collection<Boolean> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public BooleanArray(DataList list) {
        super(list, SCHEMA, Boolean.class, Boolean.class);
    }

    public BooleanArray(Boolean first, Boolean ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    @Override
    public BooleanArray clone() throws CloneNotSupportedException {
        return (BooleanArray)super.clone();
    }

    @Override
    public BooleanArray copy() throws CloneNotSupportedException {
        return (BooleanArray)super.copy();
    }

    @Override
    protected Object coerceInput(Boolean object) throws ClassCastException {
        ArgumentUtil.notNull(object, "object");
        return object;
    }

    @Override
    protected Boolean coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return DataTemplateUtil.coerceBooleanOutput(object);
    }
}

