/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.grammar;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.Null;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.grammar.PdlLexer;
import com.linkedin.data.grammar.PdlParser;
import com.linkedin.data.schema.AbstractSchemaParser;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.EnumDataSchema;
import com.linkedin.data.schema.FixedDataSchema;
import com.linkedin.data.schema.JsonBuilder;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaToJsonEncoder;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PdlSchemaParser
extends AbstractSchemaParser {
    public static final String FILETYPE = "pdl";
    public static final String FILE_EXTENSION = ".pdl";
    private static final String NEWLINE = System.lineSeparator();
    private Map<String, Name> _currentImports;
    private final boolean _isLocationNeeded;
    private final Map<Object, ParseLocation> _parseLocations;
    private final StringBuilder _errorMessageBuilder = new StringBuilder();

    public PdlSchemaParser(DataSchemaResolver resolver) {
        this(resolver, false);
    }

    public PdlSchemaParser(DataSchemaResolver resolver, boolean returnContextLocations) {
        super(resolver);
        this._isLocationNeeded = returnContextLocations;
        this._parseLocations = returnContextLocations ? new IdentityHashMap<Object, ParseLocation>() : Collections.emptyMap();
    }

    @Override
    public void parse(String source) {
        this.parse(new StringReader(source));
    }

    @Override
    public void parse(InputStream inputStream) {
        this.parse(new InputStreamReader(inputStream));
    }

    @Override
    public void parse(Reader reader) {
        try {
            PdlLexer lexer;
            ErrorRecorder errorRecorder = new ErrorRecorder();
            try {
                lexer = new PdlLexer((CharStream)new ANTLRInputStream(reader));
            }
            catch (IOException e) {
                ParseError error = new ParseError(new ParseErrorLocation(0, 0), e.getMessage());
                this.startErrorMessage(error).append(error.message).append(NEWLINE);
                return;
            }
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorRecorder);
            PdlParser parser = new PdlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorRecorder);
            PdlParser.DocumentContext antlrDocument = parser.document();
            this.parse(antlrDocument);
            if (errorRecorder.errors.size() > 0) {
                for (ParseError error : errorRecorder.errors) {
                    this.startErrorMessage(error).append(error.message).append(NEWLINE);
                }
            }
        }
        catch (ParseException e) {
            this.startErrorMessage(e.error).append(e.getMessage()).append(NEWLINE);
        }
        catch (Throwable t2) {
            ParseError parseError = new ParseError(new ParseErrorLocation(0, 0), null);
            this.startErrorMessage(parseError).append("Unexpected parser error: ").append(ExceptionUtils.getStackTrace(t2)).append(NEWLINE);
        }
    }

    public Map<Object, ParseLocation> getParseLocations() {
        return this._parseLocations;
    }

    private StringBuilder startErrorMessage(ParseError error) {
        return this.errorMessageBuilder().append(error.location).append(": ");
    }

    private StringBuilder startErrorMessage(ParserRuleContext context) {
        return this.errorMessageBuilder().append(new ParseErrorLocation(context)).append(": ");
    }

    private DataSchema parse(PdlParser.DocumentContext document) throws ParseException {
        DataSchema schema;
        PdlParser.NamespaceDeclarationContext namespaceDeclaration = document.namespaceDeclaration();
        if (namespaceDeclaration != null) {
            this.setCurrentNamespace(namespaceDeclaration.typeName().value);
            this.recordLocation(namespaceDeclaration.typeName().value, namespaceDeclaration);
        } else {
            this.setCurrentNamespace("");
        }
        PdlParser.PackageDeclarationContext packageDeclaration = document.packageDeclaration();
        if (packageDeclaration != null) {
            this.setCurrentPackage(packageDeclaration.typeName().value);
        } else {
            this.setCurrentPackage(null);
        }
        this.setCurrentImports(document.importDeclarations(), this.getCurrentNamespace());
        PdlParser.TypeDeclarationContext typeDeclaration = document.typeDeclaration();
        if (typeDeclaration.namedTypeDeclaration() != null) {
            NamedDataSchema namedSchema = this.parseNamedType(typeDeclaration.namedTypeDeclaration());
            if (!namedSchema.getNamespace().equals(this.getCurrentNamespace())) {
                throw new ParseException(typeDeclaration, "Top level type declaration may not be qualified with a namespace different than the file namespace: " + typeDeclaration.getText());
            }
            schema = namedSchema;
        } else if (typeDeclaration.anonymousTypeDeclaration() != null) {
            schema = this.parseAnonymousType(typeDeclaration.anonymousTypeDeclaration());
        } else {
            throw new ParseException(typeDeclaration, "Unrecognized type declaration: " + typeDeclaration.getText());
        }
        this.addTopLevelSchema(schema);
        return schema;
    }

    private DataSchema parseType(PdlParser.TypeDeclarationContext type) throws ParseException {
        if (type.scopedNamedTypeDeclaration() != null) {
            return this.parseScopedNamedType(type.scopedNamedTypeDeclaration());
        }
        if (type.namedTypeDeclaration() != null) {
            return this.parseNamedType(type.namedTypeDeclaration());
        }
        if (type.anonymousTypeDeclaration() != null) {
            return this.parseAnonymousType(type.anonymousTypeDeclaration());
        }
        throw new ParseException(type, "Unrecognized type declaration parse node: " + type.getText());
    }

    private DataSchema parseScopedNamedType(PdlParser.ScopedNamedTypeDeclarationContext type) throws ParseException {
        PdlParser.PackageDeclarationContext scopePackage;
        String surroundingNamespace = this.getCurrentNamespace();
        String surroundingPackage = this.getCurrentPackage();
        PdlParser.NamespaceDeclarationContext scopeNamespace = type.namespaceDeclaration();
        if (scopeNamespace != null) {
            this.setCurrentNamespace(scopeNamespace.typeName().value);
            this.recordLocation(scopeNamespace.typeName().value, scopeNamespace);
        }
        if ((scopePackage = type.packageDeclaration()) != null) {
            this.setCurrentPackage(scopePackage.typeName().value);
        }
        NamedDataSchema parsedType = this.parseNamedType(type.namedTypeDeclaration());
        this.setCurrentNamespace(surroundingNamespace);
        this.setCurrentPackage(surroundingPackage);
        return parsedType;
    }

    private DataSchema parseAnonymousType(PdlParser.AnonymousTypeDeclarationContext anon) throws ParseException {
        ComplexDataSchema complexDataSchema;
        if (anon.unionDeclaration() != null) {
            complexDataSchema = this.parseUnion(anon.unionDeclaration(), false);
        } else if (anon.mapDeclaration() != null) {
            complexDataSchema = this.parseMap(anon.mapDeclaration());
        } else if (anon.arrayDeclaration() != null) {
            complexDataSchema = this.parseArray(anon.arrayDeclaration());
        } else {
            throw new ParseException(anon, "Unrecognized type parse node: " + anon.getText());
        }
        this.setProperties(anon, complexDataSchema);
        this.recordLocation(complexDataSchema, anon);
        return complexDataSchema;
    }

    private NamedDataSchema parseNamedType(PdlParser.NamedTypeDeclarationContext namedType) throws ParseException {
        NamedDataSchema schema;
        if (namedType.recordDeclaration() != null) {
            schema = this.parseRecord(namedType, namedType.recordDeclaration());
        } else if (namedType.typerefDeclaration() != null) {
            schema = this.parseTyperef(namedType, namedType.typerefDeclaration());
        } else if (namedType.fixedDeclaration() != null) {
            schema = this.parseFixed(namedType, namedType.fixedDeclaration());
        } else if (namedType.enumDeclaration() != null) {
            schema = this.parseEnum(namedType, namedType.enumDeclaration());
        } else {
            throw new ParseException(namedType, "Unrecognized named type parse node: " + namedType.getText());
        }
        if (this._currentImports.containsKey(schema.getName())) {
            Name importName = this._currentImports.get(schema.getName());
            if (importName.getFullName().equals(schema.getFullName())) {
                this.startErrorMessage(namedType).append("Import '").append(schema.getFullName()).append("' references a type declared in the same document. Please remove it.").append(NEWLINE);
            } else {
                this.startErrorMessage(namedType).append("Declaration of type '").append(schema.getFullName()).append("' conflicts with import '").append(importName.getFullName()).append("'. Please remove the import and instead use its fully qualified name to avoid ambiguity.").append(NEWLINE);
            }
        }
        schema.setPackage(this.getCurrentPackage());
        this.recordLocation(schema, namedType);
        return schema;
    }

    private void recordLocation(Object schemaElement, ParserRuleContext context) {
        if (this._isLocationNeeded) {
            int endPosition = context.getStop().getCharPositionInLine() + (context.getStop().getStopIndex() - context.getStop().getStartIndex());
            this._parseLocations.put(schemaElement, new ParseLocation(context.getStart().getLine(), context.getStart().getCharPositionInLine() + 1, context.getStop().getLine(), endPosition + 1));
        }
    }

    private FixedDataSchema parseFixed(PdlParser.NamedTypeDeclarationContext context, PdlParser.FixedDeclarationContext fixed) throws ParseException {
        Name name = this.toName(fixed.name);
        FixedDataSchema schema = new FixedDataSchema(name);
        this.setDocAndProperties(context, schema);
        this.bindNameToSchema(name, schema.getAliases(), schema);
        schema.setSize(fixed.size, this.errorMessageBuilder());
        return schema;
    }

    private EnumDataSchema parseEnum(PdlParser.NamedTypeDeclarationContext context, PdlParser.EnumDeclarationContext enumDecl) throws ParseException {
        Name name = this.toName(enumDecl.name);
        EnumDataSchema schema = new EnumDataSchema(name);
        Map<String, Object> props = this.setDocAndProperties(context, schema);
        this.bindNameToSchema(name, schema.getAliases(), schema);
        List<PdlParser.EnumSymbolDeclarationContext> symbolDecls = enumDecl.enumDecl.symbolDecls;
        ArrayList<String> symbols = new ArrayList<String>(symbolDecls.size());
        HashMap<String, Object> symbolDocs = new HashMap<String, Object>();
        DataMap deprecatedSymbols = new DataMap();
        DataMap symbolProperties = new DataMap();
        for (PdlParser.EnumSymbolDeclarationContext symbolDecl : symbolDecls) {
            symbols.add(symbolDecl.symbol.value);
            this.recordLocation(symbolDecl.symbol.value, symbolDecl);
            if (symbolDecl.doc != null) {
                symbolDocs.put(symbolDecl.symbol.value, symbolDecl.doc.value);
            }
            for (PdlParser.PropDeclarationContext prop : symbolDecl.props) {
                String symbol = symbolDecl.symbol.value;
                Object value = this.parsePropValue(prop);
                if (this.equalsSingleSegmentProperty(prop, "deprecated")) {
                    deprecatedSymbols.put(symbol, value);
                    continue;
                }
                ArrayList<String> path = new ArrayList<String>(prop.path.size() + 1);
                path.add(symbol);
                path.addAll(prop.path);
                this.addPropertiesAtPath(prop, symbolProperties, path, value);
            }
        }
        schema.setSymbols(symbols, this.errorMessageBuilder());
        if (!symbolDocs.isEmpty()) {
            schema.setSymbolDocs(symbolDocs, this.errorMessageBuilder());
        }
        if (!deprecatedSymbols.isEmpty()) {
            props.put("deprecatedSymbols", deprecatedSymbols);
        }
        if (!symbolProperties.isEmpty()) {
            props.put("symbolProperties", symbolProperties);
        }
        schema.setProperties(props);
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TyperefDataSchema parseTyperef(PdlParser.NamedTypeDeclarationContext context, PdlParser.TyperefDeclarationContext typeref) throws ParseException {
        Name name = this.toName(typeref.name);
        TyperefDataSchema schema = new TyperefDataSchema(name);
        this.getResolver().addPendingSchema(schema.getFullName());
        try {
            this.setDocAndProperties(context, schema);
            this.bindNameToSchema(name, schema.getAliases(), schema);
            DataSchema refSchema = this.toDataSchema(typeref.ref);
            this.checkTyperefCycle(schema, refSchema);
            schema.setReferencedType(refSchema);
            schema.setRefDeclaredInline(this.isDeclaredInline(typeref.ref));
        }
        finally {
            this.getResolver().removePendingSchema(schema.getFullName());
        }
        return schema;
    }

    private ArrayDataSchema parseArray(PdlParser.ArrayDeclarationContext array) throws ParseException {
        ArrayDataSchema schema = new ArrayDataSchema(this.toDataSchema(array.typeParams.items));
        schema.setItemsDeclaredInline(this.isDeclaredInline(array.typeParams.items));
        return schema;
    }

    private MapDataSchema parseMap(PdlParser.MapDeclarationContext map) throws ParseException {
        PdlParser.TypeAssignmentContext keyType = map.typeParams.key;
        PdlParser.TypeAssignmentContext valueType = map.typeParams.value;
        MapDataSchema schema = new MapDataSchema(this.toDataSchema(valueType));
        HashMap<String, Object> propsToAdd = new HashMap<String, Object>();
        if (keyType.typeReference() != null) {
            String typeName = keyType.typeReference().value;
            if (!typeName.equals("string")) {
                this.startErrorMessage(map).append("Unsupported map key type: ").append(typeName).append(". 'string' is the only currently supported map key type.\n");
            }
        } else if (keyType.typeDeclaration() != null) {
            DataSchema keySchema = this.parseType(keyType.typeDeclaration());
            String json = SchemaToJsonEncoder.schemaToJson(keySchema, JsonBuilder.Pretty.COMPACT);
            this.startErrorMessage(map).append("Unsupported map key type declaration: ").append(json).append(". 'string' is the only currently supported map key type.\n");
        }
        schema.setProperties(propsToAdd);
        schema.setValuesDeclaredInline(this.isDeclaredInline(valueType));
        return schema;
    }

    private UnionDataSchema parseUnion(PdlParser.UnionDeclarationContext union, boolean withinTypref) throws ParseException {
        UnionDataSchema schema = new UnionDataSchema();
        List<PdlParser.UnionMemberDeclarationContext> members = union.typeParams.members;
        ArrayList<UnionDataSchema.Member> unionMembers = new ArrayList<UnionDataSchema.Member>(members.size());
        for (PdlParser.UnionMemberDeclarationContext memberDecl : members) {
            PdlParser.TypeAssignmentContext memberType = memberDecl.member;
            DataSchema dataSchema = this.toDataSchema(memberType);
            if (dataSchema == null) continue;
            UnionDataSchema.Member unionMember = new UnionDataSchema.Member(dataSchema);
            this.recordLocation(unionMember, memberDecl);
            unionMember.setDeclaredInline(this.isDeclaredInline(memberDecl.member));
            PdlParser.UnionMemberAliasContext alias = memberDecl.unionMemberAlias();
            if (alias != null) {
                boolean isAliasValid = unionMember.setAlias(alias.name.value, this.startCalleeMessageBuilder());
                if (!isAliasValid) {
                    this.appendCalleeMessage(unionMember);
                }
                if (alias.doc != null) {
                    unionMember.setDoc(alias.doc.value);
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (PdlParser.PropDeclarationContext prop : alias.props) {
                    this.addPropertiesAtPath(properties, prop);
                }
                unionMember.setProperties(properties);
            }
            unionMembers.add(unionMember);
        }
        schema.setMembers(unionMembers, this.errorMessageBuilder());
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordDataSchema parseRecord(PdlParser.NamedTypeDeclarationContext context, PdlParser.RecordDeclarationContext record) throws ParseException {
        Name name = this.toName(record.name);
        RecordDataSchema schema = new RecordDataSchema(name, RecordDataSchema.RecordType.RECORD);
        this.getResolver().addPendingSchema(schema.getFullName());
        try {
            boolean hasAfterIncludes;
            this.setDocAndProperties(context, schema);
            this.bindNameToSchema(name, schema.getAliases(), schema);
            FieldsAndIncludes fieldsAndIncludes = this.parseIncludes(schema, record.beforeIncludes);
            boolean hasBeforeIncludes = fieldsAndIncludes.includes.size() > 0;
            fieldsAndIncludes.fields.addAll(this.parseFields(schema, record.recordDecl));
            FieldsAndIncludes afterIncludes = this.parseIncludes(schema, record.afterIncludes);
            boolean bl = hasAfterIncludes = afterIncludes.includes.size() > 0;
            if (hasBeforeIncludes && hasAfterIncludes) {
                this.startErrorMessage(record).append("Record may have includes before or after fields, but not both: ").append((Object)record).append(NEWLINE);
            }
            fieldsAndIncludes.addAll(afterIncludes);
            schema.setFields(fieldsAndIncludes.fields, this.errorMessageBuilder());
            schema.setInclude(fieldsAndIncludes.includes);
            schema.setIncludesDeclaredInline(fieldsAndIncludes.includesDeclaredInline);
            schema.setFieldsBeforeIncludes(hasAfterIncludes);
            this.validateDefaults(schema);
        }
        finally {
            this.getResolver().removePendingSchema(schema.getFullName());
        }
        return schema;
    }

    protected Map<String, Object> setDocAndProperties(PdlParser.NamedTypeDeclarationContext source, NamedDataSchema target) throws ParseException {
        HashMap<String, Object> properties = new HashMap<String, Object>(target.getProperties());
        if (source.doc != null) {
            target.setDoc(source.doc.value);
        }
        for (PdlParser.PropDeclarationContext prop : source.props) {
            if (this.equalsSingleSegmentProperty(prop, "aliases")) {
                List<Name> aliases = this.parseAliases(prop).stream().map(this::toName).collect(Collectors.toList());
                target.setAliases(aliases);
                continue;
            }
            this.addPropertiesAtPath(properties, prop);
        }
        target.setProperties(properties);
        return properties;
    }

    private void setProperties(PdlParser.AnonymousTypeDeclarationContext source, ComplexDataSchema target) throws ParseException {
        HashMap<String, Object> properties = new HashMap<String, Object>(target.getProperties());
        for (PdlParser.PropDeclarationContext prop : source.props) {
            this.addPropertiesAtPath(properties, prop);
        }
        target.setProperties(properties);
    }

    private void addPropertiesAtPath(Map<String, Object> existingProperties, PdlParser.PropDeclarationContext prop) throws ParseException {
        this.addPropertiesAtPath(prop, existingProperties, prop.path, this.parsePropValue(prop));
    }

    private void addPropertiesAtPath(ParserRuleContext context, Map<String, Object> existingProperties, Iterable<String> path, Object value) throws ParseException {
        DataMap current = existingProperties;
        Iterator<String> iter = path.iterator();
        while (iter.hasNext()) {
            String pathPart = iter.next();
            if (iter.hasNext()) {
                if (current.containsKey(pathPart)) {
                    Object val = current.get(pathPart);
                    if (!(val instanceof DataMap)) {
                        throw new ParseException(new ParseError(new ParseErrorLocation(context), "Conflicting property: " + path.toString()));
                    }
                    current = (DataMap)val;
                    continue;
                }
                DataMap next = new DataMap();
                current.put((String)pathPart, (Object)next);
                current = next;
                continue;
            }
            if (current.containsKey(pathPart)) {
                throw new ParseException(new ParseError(new ParseErrorLocation(context), "Property already defined: " + path.toString()));
            }
            current.put((String)pathPart, (Object)value);
        }
    }

    private FieldsAndIncludes parseIncludes(RecordDataSchema recordDataSchema, PdlParser.FieldIncludesContext includeSet) throws ParseException {
        ArrayList<NamedDataSchema> includes = new ArrayList<NamedDataSchema>();
        HashSet<NamedDataSchema> includesDeclaredInline = new HashSet<NamedDataSchema>();
        ArrayList<RecordDataSchema.Field> fields = new ArrayList<RecordDataSchema.Field>();
        if (includeSet != null) {
            this.getResolver().updatePendingSchema(recordDataSchema.getFullName(), true);
            List<PdlParser.TypeAssignmentContext> includeTypes = includeSet.typeAssignment();
            for (PdlParser.TypeAssignmentContext includeRef : includeTypes) {
                DataSchema includedSchema = this.toDataSchema(includeRef);
                if (includedSchema != null) {
                    DataSchema dereferencedIncludedSchema = includedSchema.getDereferencedDataSchema();
                    if (includedSchema instanceof NamedDataSchema && dereferencedIncludedSchema instanceof RecordDataSchema) {
                        NamedDataSchema includedNamedSchema = (NamedDataSchema)includedSchema;
                        RecordDataSchema dereferencedIncludedRecordSchema = (RecordDataSchema)dereferencedIncludedSchema;
                        fields.addAll(dereferencedIncludedRecordSchema.getFields());
                        includes.add(includedNamedSchema);
                        if (!this.isDeclaredInline(includeRef)) continue;
                        includesDeclaredInline.add(includedNamedSchema);
                        continue;
                    }
                    this.startErrorMessage(includeRef).append("Include is not a record type or a typeref to a record type: ").append((Object)includeRef).append(NEWLINE);
                    continue;
                }
                this.startErrorMessage(includeRef).append("Unable to resolve included schema: ").append((Object)includeRef).append(NEWLINE);
            }
            this.getResolver().updatePendingSchema(recordDataSchema.getFullName(), false);
        }
        return new FieldsAndIncludes(fields, includes, includesDeclaredInline);
    }

    private List<RecordDataSchema.Field> parseFields(RecordDataSchema recordSchema, PdlParser.FieldSelectionContext fieldGroup) throws ParseException {
        ArrayList<RecordDataSchema.Field> results = new ArrayList<RecordDataSchema.Field>();
        for (PdlParser.FieldDeclarationContext field : fieldGroup.fields) {
            if (field != null) {
                PdlParser.JsonValueContext defaultValue;
                if (field.type == null) {
                    throw new IllegalStateException("type is missing for field: " + field.getText());
                }
                RecordDataSchema.Field result = new RecordDataSchema.Field(this.toDataSchema(field.type));
                this.recordLocation(result, field);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                result.setName(field.name, this.errorMessageBuilder());
                result.setOptional(field.isOptional);
                PdlParser.FieldDefaultContext fieldDefault = field.fieldDefault();
                if (fieldDefault != null && (defaultValue = fieldDefault.jsonValue()) != null) {
                    result.setDefault(this.parseJsonValue(defaultValue));
                }
                List<String> aliases = new ArrayList<String>();
                RecordDataSchema.Field.Order sortOrder = null;
                for (PdlParser.PropDeclarationContext prop : field.props) {
                    if (this.equalsSingleSegmentProperty(prop, "aliases")) {
                        aliases = this.parseAliases(prop);
                        continue;
                    }
                    if (this.equalsSingleSegmentProperty(prop, "order")) {
                        Object value = this.parsePropValue(prop);
                        if (!(value instanceof String)) {
                            this.startErrorMessage(prop).append("'order' must be string, but found ").append(prop.getText()).append(NEWLINE);
                            continue;
                        }
                        String order = (String)value;
                        try {
                            sortOrder = RecordDataSchema.Field.Order.valueOf(order.toUpperCase());
                        }
                        catch (IllegalArgumentException exc) {
                            this.startErrorMessage(order).append("\"").append(order).append("\" is an invalid sort order.\n");
                        }
                        continue;
                    }
                    this.addPropertiesAtPath(properties, prop);
                }
                if (field.doc != null) {
                    result.setDoc(field.doc.value);
                }
                if (aliases.size() > 0) {
                    result.setAliases(aliases, this.errorMessageBuilder());
                }
                if (sortOrder != null) {
                    result.setOrder(sortOrder);
                }
                result.setProperties(properties);
                result.setRecord(recordSchema);
                result.setDeclaredInline(this.isDeclaredInline(field.type));
                results.add(result);
                continue;
            }
            this.startErrorMessage(field).append("Unrecognized field element parse node: ").append(field.getText()).append(NEWLINE);
        }
        return results;
    }

    private List<String> parseAliases(PdlParser.PropDeclarationContext prop) throws ParseException {
        assert (this.equalsSingleSegmentProperty(prop, "aliases"));
        ArrayList<String> aliases = new ArrayList<String>();
        Object value = this.parsePropValue(prop);
        if (!(value instanceof DataList)) {
            this.startErrorMessage(prop).append("'aliases' must be a list, but found ").append(prop.getText()).append(NEWLINE);
        } else {
            for (Object alias : (DataList)value) {
                if (!(alias instanceof String)) {
                    this.startErrorMessage(prop).append("'aliases' list elements must be string, but found ").append(alias.getClass()).append(" at ").append(prop.getText()).append(NEWLINE);
                    continue;
                }
                aliases.add((String)alias);
            }
        }
        return aliases;
    }

    private boolean equalsSingleSegmentProperty(PdlParser.PropDeclarationContext prop, String propertyKey) {
        return prop.path.size() == 1 && prop.path.get(0).equals(propertyKey);
    }

    private boolean isDeclaredInline(PdlParser.TypeAssignmentContext assignment) {
        return assignment.typeReference() == null;
    }

    protected DataSchema toDataSchema(PdlParser.TypeReferenceContext typeReference) throws ParseException {
        DataSchema dataSchema = this.stringToDataSchema(typeReference.value);
        if (dataSchema != null) {
            return dataSchema;
        }
        this.startErrorMessage(typeReference).append("Type not found: ").append(typeReference.value).append(NEWLINE);
        return null;
    }

    private DataSchema toDataSchema(PdlParser.TypeAssignmentContext typeAssignment) throws ParseException {
        PdlParser.TypeReferenceContext typeReference = typeAssignment.typeReference();
        if (typeReference != null) {
            return this.toDataSchema(typeReference);
        }
        if (typeAssignment.typeDeclaration() != null) {
            return this.parseType(typeAssignment.typeDeclaration());
        }
        throw new ParseException(typeAssignment, "Unrecognized type assignment parse node: " + typeAssignment.getText() + NEWLINE);
    }

    private Name toName(String name) {
        if (name.contains(".")) {
            return new Name(name, this.errorMessageBuilder());
        }
        return new Name(name, this.getCurrentNamespace(), this.errorMessageBuilder());
    }

    private Object parsePropValue(PdlParser.PropDeclarationContext prop) throws ParseException {
        if (prop.propJsonValue() != null) {
            return this.parseJsonValue(prop.propJsonValue().jsonValue());
        }
        return Boolean.TRUE;
    }

    private Object parseJsonValue(PdlParser.JsonValueContext jsonValue) throws ParseException {
        if (jsonValue.array() != null) {
            DataList dataList = new DataList();
            for (PdlParser.JsonValueContext item : jsonValue.array().jsonValue()) {
                dataList.add(this.parseJsonValue(item));
            }
            return dataList;
        }
        if (jsonValue.object() != null) {
            DataMap dataMap = new DataMap();
            for (PdlParser.ObjectEntryContext entry : jsonValue.object().objectEntry()) {
                dataMap.put(entry.key.value, this.parseJsonValue(entry.value));
            }
            return dataMap;
        }
        if (jsonValue.string() != null) {
            return jsonValue.string().value;
        }
        if (jsonValue.number() != null) {
            Number numberValue = jsonValue.number().value;
            if (numberValue == null) {
                this.startErrorMessage(jsonValue).append("'").append(jsonValue.number().getText()).append("' is not a valid int, long, float or double.").append(NEWLINE);
                return 0;
            }
            return numberValue;
        }
        if (jsonValue.bool() != null) {
            return jsonValue.bool().value;
        }
        if (jsonValue.nullValue() != null) {
            return Null.getInstance();
        }
        this.startErrorMessage(jsonValue).append("Unrecognized JSON parse node: ").append(jsonValue.getText()).append(NEWLINE);
        return Null.getInstance();
    }

    @Override
    public String computeFullName(String name) {
        String fullname = DataSchemaUtil.typeStringToPrimitiveDataSchema(name) != null ? name : (Name.isFullName(name) ? name : (this._currentImports.containsKey(name) ? this._currentImports.get(name).getFullName() : (this.getCurrentNamespace().isEmpty() ? name : this.getCurrentNamespace() + "." + name)));
        return fullname;
    }

    private void setCurrentImports(PdlParser.ImportDeclarationsContext imports, String rootNamespace) {
        HashMap<String, Name> importsBySimpleName = new HashMap<String, Name>();
        for (PdlParser.ImportDeclarationContext importDecl : imports.importDeclaration()) {
            String importedSimpleName;
            String importedFullname = importDecl.type.value;
            Name importedName = new Name(importedFullname);
            if (importedName.getNamespace().equals(rootNamespace)) {
                this.startErrorMessage(importDecl).append("Import '").append(importedFullname).append("' is from within the document's root namespace and is thus unnecessary. Please remove it.").append(NEWLINE);
            }
            if (importsBySimpleName.containsKey(importedSimpleName = importedName.getName())) {
                this.startErrorMessage(importDecl).append("Import '").append(importedFullname).append("' conflicts with import '").append(((Name)importsBySimpleName.get(importedSimpleName)).getFullName()).append("'. Please remove one and instead use its fully qualified name.").append(NEWLINE);
            }
            importsBySimpleName.put(importedSimpleName, importedName);
        }
        this._currentImports = importsBySimpleName;
    }

    @Override
    public String schemasToString() {
        return SchemaToJsonEncoder.schemasToJson(this.topLevelDataSchemas(), JsonBuilder.Pretty.SPACES);
    }

    @Override
    public StringBuilder errorMessageBuilder() {
        return this._errorMessageBuilder;
    }

    private static class FieldsAndIncludes {
        public final List<RecordDataSchema.Field> fields;
        public final List<NamedDataSchema> includes;
        public final Set<NamedDataSchema> includesDeclaredInline;

        public FieldsAndIncludes(List<RecordDataSchema.Field> fields, List<NamedDataSchema> includes, Set<NamedDataSchema> includesDeclaredInline) {
            this.fields = fields;
            this.includes = includes;
            this.includesDeclaredInline = includesDeclaredInline;
        }

        public void addAll(FieldsAndIncludes includes) {
            this.fields.addAll(includes.fields);
            this.includes.addAll(includes.includes);
            this.includesDeclaredInline.addAll(includes.includesDeclaredInline);
        }
    }

    private static class ErrorRecorder
    extends BaseErrorListener {
        public final List<ParseError> errors = new LinkedList<ParseError>();

        private ErrorRecorder() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int column, String msg, RecognitionException e) {
            ParseErrorLocation location = new ParseErrorLocation(line, column);
            this.errors.add(new ParseError(location, msg));
        }
    }

    protected static class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public final ParseError error;

        public ParseException(ParserRuleContext context, String msg) {
            this(new ParseError(new ParseErrorLocation(context), msg));
        }

        public ParseException(ParseError error) {
            super(error.message);
            this.error = error;
        }
    }

    private static class ParseErrorLocation
    implements DataLocation {
        public final int line;
        public final int column;

        public ParseErrorLocation(ParserRuleContext context) {
            Token start = context.getStart();
            this.line = start.getLine();
            this.column = start.getCharPositionInLine();
        }

        public ParseErrorLocation(int line, int column) {
            this.line = line;
            this.column = column;
        }

        @Override
        public int compareTo(DataLocation location) {
            if (!(location instanceof ParseErrorLocation)) {
                return -1;
            }
            ParseErrorLocation other = (ParseErrorLocation)location;
            int lineCompare = this.line - other.line;
            if (lineCompare != 0) {
                return lineCompare;
            }
            return this.column - other.column;
        }

        public String toString() {
            return this.line + "," + this.column;
        }
    }

    public static class ParseLocation {
        int _startLine;
        int _startColumn;
        int _endLine;
        int _endColumn;

        public ParseLocation(int startLine, int startColumn, int endLine, int endColumn) {
            this._startLine = startLine;
            this._startColumn = startColumn;
            this._endLine = endLine;
            this._endColumn = endColumn;
        }

        public int getStartLine() {
            return this._startLine;
        }

        public int getStartColumn() {
            return this._startColumn;
        }

        public int getEndLine() {
            return this._endLine;
        }

        public int getEndColumn() {
            return this._endColumn;
        }
    }

    private static class ParseError {
        public final ParseErrorLocation location;
        public final String message;

        public ParseError(ParseErrorLocation location, String message) {
            this.location = location;
            this.message = message;
        }
    }
}

