/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.protobuf;

import com.linkedin.data.protobuf.ProtoReader;
import com.linkedin.data.protobuf.Utf8Utils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class InputStreamReader
extends ProtoReader {
    private final InputStream _input;
    private final byte[] _buffer;
    private int _bufferSize;
    private int _bufferSizeAfterLimit;
    private int _pos;
    private int _totalBytesRetired;
    private int _currentLimit = Integer.MAX_VALUE;
    private RefillCallback refillCallback = null;

    InputStreamReader(InputStream input, int bufferSize) {
        this._input = input;
        this._buffer = new byte[bufferSize];
        this._bufferSize = 0;
        this._pos = 0;
        this._totalBytesRetired = 0;
    }

    @Override
    public String readASCIIString() throws IOException {
        int size = this.readInt32();
        if (size > 0) {
            if (size < this._bufferSize) {
                if (size > this._bufferSize - this._pos) {
                    this.refillBuffer(size);
                }
                String value = Utf8Utils.decodeASCII(this._buffer, this._pos, size, this._textBuffer);
                this._pos += size;
                return value;
            }
            InputStreamLongDecoderState state = new InputStreamLongDecoderState(this._buffer, this._pos, this._bufferSize, this._input);
            String value = Utf8Utils.decodeLongASCII(state, size, this._textBuffer);
            this._pos = state.getPosition();
            this._bufferSize = state.getBufferSize();
            return value;
        }
        if (size == 0) {
            return "";
        }
        throw new IOException("Read negative size: " + size + ". Invalid string");
    }

    @Override
    public String readString() throws IOException {
        int size = this.readInt32();
        if (size > 0) {
            if (size < this._bufferSize) {
                if (size > this._bufferSize - this._pos) {
                    this.refillBuffer(size);
                }
                String value = Utf8Utils.decode(this._buffer, this._pos, size, this._textBuffer);
                this._pos += size;
                return value;
            }
            InputStreamLongDecoderState state = new InputStreamLongDecoderState(this._buffer, this._pos, this._bufferSize, this._input);
            String value = Utf8Utils.decodeLong(state, size, this._textBuffer);
            this._pos = state.getPosition();
            this._bufferSize = state.getBufferSize();
            return value;
        }
        if (size == 0) {
            return "";
        }
        throw new IOException("Read negative size: " + size + ". Invalid string");
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int size = this.readInt32();
        if (size <= this._bufferSize - this._pos && size > 0) {
            byte[] result = Arrays.copyOfRange(this._buffer, this._pos, this._pos + size);
            this._pos += size;
            return result;
        }
        return this.readRawBytesSlowPath(size);
    }

    @Override
    public int readInt32() throws IOException {
        block4: {
            int x;
            int tempPos;
            block6: {
                byte[] buffer;
                block8: {
                    block7: {
                        block5: {
                            tempPos = this._pos;
                            if (this._bufferSize == tempPos) break block4;
                            buffer = this._buffer;
                            if ((x = buffer[tempPos++]) >= 0) {
                                this._pos = tempPos;
                                return x;
                            }
                            if (this._bufferSize - tempPos < 9) break block4;
                            if ((x ^= buffer[tempPos++] << 7) >= 0) break block5;
                            x ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((x ^= buffer[tempPos++] << 14) < 0) break block7;
                        x ^= 0x3F80;
                        break block6;
                    }
                    if ((x ^= buffer[tempPos++] << 21) >= 0) break block8;
                    x ^= 0xFFE03F80;
                    break block6;
                }
                byte y = buffer[tempPos++];
                x ^= y << 28;
                x ^= 0xFE03F80;
                if (y < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0 && buffer[tempPos++] < 0) break block4;
            }
            this._pos = tempPos;
            return x;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    @Override
    public long readInt64() throws IOException {
        block4: {
            long x;
            int tempPos;
            block6: {
                byte[] buffer;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int y;
                                block8: {
                                    block7: {
                                        block5: {
                                            tempPos = this._pos;
                                            if (this._bufferSize == tempPos) break block4;
                                            buffer = this._buffer;
                                            if ((y = buffer[tempPos++]) >= 0) {
                                                this._pos = tempPos;
                                                return y;
                                            }
                                            if (this._bufferSize - tempPos < 9) break block4;
                                            if ((y ^= buffer[tempPos++] << 7) >= 0) break block5;
                                            x = y ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((y ^= buffer[tempPos++] << 14) < 0) break block7;
                                        x = y ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((y ^= buffer[tempPos++] << 21) >= 0) break block8;
                                    x = y ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((x = (long)y ^ (long)buffer[tempPos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[tempPos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[tempPos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[tempPos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[tempPos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[tempPos++] < 0L) break block4;
            }
            this._pos = tempPos;
            return x;
        }
        return this.readRawVarint64SlowPath();
    }

    @Override
    public int readFixedInt32() throws IOException {
        if (4 > this._bufferSize - this._pos) {
            this.refillBuffer(4);
        }
        return this._buffer[this._pos++] & 0xFF | (this._buffer[this._pos++] & 0xFF) << 8 | (this._buffer[this._pos++] & 0xFF) << 16 | (this._buffer[this._pos++] & 0xFF) << 24;
    }

    @Override
    public long readFixedInt64() throws IOException {
        if (8 > this._bufferSize - this._pos) {
            this.refillBuffer(8);
        }
        return (long)this._buffer[this._pos++] & 0xFFL | ((long)this._buffer[this._pos++] & 0xFFL) << 8 | ((long)this._buffer[this._pos++] & 0xFFL) << 16 | ((long)this._buffer[this._pos++] & 0xFFL) << 24 | ((long)this._buffer[this._pos++] & 0xFFL) << 32 | ((long)this._buffer[this._pos++] & 0xFFL) << 40 | ((long)this._buffer[this._pos++] & 0xFFL) << 48 | ((long)this._buffer[this._pos++] & 0xFFL) << 56;
    }

    long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed VarInt");
    }

    private void recomputeBufferSizeAfterLimit() {
        this._bufferSize += this._bufferSizeAfterLimit;
        int bufferEnd = this._totalBytesRetired + this._bufferSize;
        if (bufferEnd > this._currentLimit) {
            this._bufferSizeAfterLimit = bufferEnd - this._currentLimit;
            this._bufferSize -= this._bufferSizeAfterLimit;
        } else {
            this._bufferSizeAfterLimit = 0;
        }
    }

    private void refillBuffer(int n) throws IOException {
        if (!this.tryRefillBuffer(n)) {
            throw new EOFException();
        }
    }

    private boolean tryRefillBuffer(int n) throws IOException {
        int bytesRead;
        int tempPos;
        if (this._pos + n <= this._bufferSize) {
            throw new IllegalStateException("refillBuffer() called when " + n + " bytes were already available in _buffer");
        }
        if (n > Integer.MAX_VALUE - this._totalBytesRetired - this._pos) {
            return false;
        }
        if (this._totalBytesRetired + this._pos + n > this._currentLimit) {
            return false;
        }
        if (this.refillCallback != null) {
            this.refillCallback.onRefill();
        }
        if ((tempPos = this._pos) > 0) {
            if (this._bufferSize > tempPos) {
                System.arraycopy(this._buffer, tempPos, this._buffer, 0, this._bufferSize - tempPos);
            }
            this._totalBytesRetired += tempPos;
            this._bufferSize -= tempPos;
            this._pos = 0;
        }
        if ((bytesRead = this._input.read(this._buffer, this._bufferSize, Math.min(this._buffer.length - this._bufferSize, Integer.MAX_VALUE - this._totalBytesRetired - this._bufferSize))) == 0 || bytesRead < -1 || bytesRead > this._buffer.length) {
            throw new IllegalStateException(this._input.getClass() + "#read(byte[]) returned invalid result: " + bytesRead + "\nThe InputStream implementation is buggy.");
        }
        if (bytesRead > 0) {
            this._bufferSize += bytesRead;
            this.recomputeBufferSizeAfterLimit();
            return this._bufferSize >= n || this.tryRefillBuffer(n);
        }
        return false;
    }

    @Override
    public byte readRawByte() throws IOException {
        if (this._pos == this._bufferSize) {
            this.refillBuffer(1);
        }
        return this._buffer[this._pos++];
    }

    private byte[] readRawBytesSlowPath(int size) throws IOException {
        byte[] result = this.readRawBytesSlowPathOneChunk(size);
        if (result != null) {
            return result;
        }
        int originalBufferPos = this._pos;
        int bufferedBytes = this._bufferSize - this._pos;
        this._totalBytesRetired += this._bufferSize;
        this._pos = 0;
        this._bufferSize = 0;
        int sizeLeft = size - bufferedBytes;
        List<byte[]> chunks = this.readRawBytesSlowPathRemainingChunks(sizeLeft);
        byte[] bytes = new byte[size];
        System.arraycopy(this._buffer, originalBufferPos, bytes, 0, bufferedBytes);
        int tempPos = bufferedBytes;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, bytes, tempPos, chunk.length);
            tempPos += chunk.length;
        }
        return bytes;
    }

    private byte[] readRawBytesSlowPathOneChunk(int size) throws IOException {
        if (size == 0) {
            return new byte[0];
        }
        if (size < 0) {
            throw new EOFException();
        }
        int currentMessageSize = this._totalBytesRetired + this._pos + size;
        if (currentMessageSize - Integer.MAX_VALUE > 0) {
            throw new EOFException();
        }
        if (currentMessageSize > this._currentLimit) {
            throw new EOFException();
        }
        int bufferedBytes = this._bufferSize - this._pos;
        int sizeLeft = size - bufferedBytes;
        if (sizeLeft < 1024 || sizeLeft <= this._input.available()) {
            int n;
            byte[] bytes = new byte[size];
            System.arraycopy(this._buffer, this._pos, bytes, 0, bufferedBytes);
            this._totalBytesRetired += this._bufferSize;
            this._pos = 0;
            this._bufferSize = 0;
            for (int tempPos = bufferedBytes; tempPos < bytes.length; tempPos += n) {
                n = this._input.read(bytes, tempPos, size - tempPos);
                if (n == -1) {
                    throw new EOFException();
                }
                this._totalBytesRetired += n;
            }
            return bytes;
        }
        return null;
    }

    private List<byte[]> readRawBytesSlowPathRemainingChunks(int sizeLeft) throws IOException {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        while (sizeLeft > 0) {
            int n;
            byte[] chunk = new byte[Math.min(sizeLeft, 1024)];
            for (int tempPos = 0; tempPos < chunk.length; tempPos += n) {
                n = this._input.read(chunk, tempPos, chunk.length - tempPos);
                if (n == -1) {
                    throw new EOFException();
                }
                this._totalBytesRetired += n;
            }
            sizeLeft -= chunk.length;
            chunks.add(chunk);
        }
        return chunks;
    }

    private static class InputStreamLongDecoderState
    extends Utf8Utils.LongDecoderState {
        private final InputStream _inputStream;

        InputStreamLongDecoderState(byte[] buffer, int initialPosition, int bufferSize, InputStream inputStream) {
            this._buffer = buffer;
            this._position = initialPosition;
            this._bufferSize = bufferSize;
            this._inputStream = inputStream;
        }

        @Override
        public void readNextChunk() throws IOException {
            int bytesRead = this._inputStream.read(this._buffer, 0, this._buffer.length);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            this._position = 0;
            this._bufferSize = bytesRead;
        }
    }

    private static interface RefillCallback {
        public void onRefill();
    }
}

