/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.codec;

import com.linkedin.data.ByteString;
import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.codec.DataCodec;
import com.linkedin.data.codec.DataDecodingException;
import com.linkedin.data.codec.DataEncodingException;
import com.linkedin.data.codec.ProtobufCodecOptions;
import com.linkedin.data.codec.symbol.SymbolTable;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.protobuf.ProtoReader;
import com.linkedin.data.protobuf.ProtoWriter;
import com.linkedin.util.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;

public class ProtobufDataCodec
implements DataCodec {
    public static final String DEFAULT_HEADER = "application/x-protobuf2";
    public static final byte MAP_ORDINAL = 0;
    public static final byte LIST_ORDINAL = 1;
    public static final byte STRING_LITERAL_ORDINAL = 2;
    public static final byte STRING_REFERENCE_ORDINAL = 3;
    public static final byte INTEGER_ORDINAL = 4;
    public static final byte LONG_ORDINAL = 5;
    public static final byte FLOAT_ORDINAL = 6;
    public static final byte DOUBLE_ORDINAL = 7;
    public static final byte BOOLEAN_TRUE_ORDINAL = 8;
    public static final byte BOOLEAN_FALSE_ORDINAL = 9;
    public static final byte RAW_BYTES_ORDINAL = 10;
    public static final byte NULL_ORDINAL = 11;
    public static final byte ASCII_STRING_LITERAL_ORDINAL = 20;
    public static final byte FIXED_FLOAT_ORDINAL = 21;
    public static final byte FIXED_DOUBLE_ORDINAL = 22;
    @Deprecated
    protected final SymbolTable _symbolTable;
    @Deprecated
    protected final boolean _supportsASCIIOnlyStrings;
    protected final ProtobufCodecOptions _options;

    public ProtobufDataCodec() {
        this(new ProtobufCodecOptions.Builder().build());
    }

    @Deprecated
    public ProtobufDataCodec(String symbolTableName) {
        this(new ProtobufCodecOptions.Builder().build());
    }

    @Deprecated
    public ProtobufDataCodec(SymbolTable symbolTable) {
        this(new ProtobufCodecOptions.Builder().setSymbolTable(symbolTable).build());
    }

    @Deprecated
    public ProtobufDataCodec(SymbolTable symbolTable, boolean supportsASCIIOnlyStrings) {
        this(new ProtobufCodecOptions.Builder().setSymbolTable(symbolTable).setEnableASCIIOnlyStrings(supportsASCIIOnlyStrings).build());
    }

    public ProtobufDataCodec(ProtobufCodecOptions options) {
        this._options = options;
        this._symbolTable = options.getSymbolTable();
        this._supportsASCIIOnlyStrings = options.shouldEnableASCIIOnlyStrings();
    }

    @Override
    public byte[] mapToBytes(DataMap map) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(this._options.getProtoWriterBufferSize());
        this.writeMap(map, baos);
        return baos.toByteArray();
    }

    @Override
    public byte[] listToBytes(DataList list) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(this._options.getProtoWriterBufferSize());
        this.writeList(list, baos);
        return baos.toByteArray();
    }

    @Override
    public void writeMap(DataMap map, OutputStream out) throws IOException {
        try (Data.TraverseCallback callback = this.createTraverseCallback(new ProtoWriter(out, this._options.getProtoWriterBufferSize()));){
            Data.traverse(map, callback);
        }
    }

    @Override
    public void writeList(DataList list, OutputStream out) throws IOException {
        try (Data.TraverseCallback callback = this.createTraverseCallback(new ProtoWriter(out, this._options.getProtoWriterBufferSize()));){
            Data.traverse(list, callback);
        }
    }

    @Override
    public DataMap bytesToMap(byte[] input) throws IOException {
        return (DataMap)this.readValue(ProtoReader.newInstance(input), this::isMap);
    }

    @Override
    public DataList bytesToList(byte[] input) throws IOException {
        return (DataList)this.readValue(ProtoReader.newInstance(input), this::isList);
    }

    @Override
    public DataMap readMap(InputStream in) throws IOException {
        try {
            DataMap dataMap = (DataMap)this.readValue(ProtoReader.newInstance(in), this::isMap);
            return dataMap;
        }
        finally {
            DataCodec.closeQuietly(in);
        }
    }

    @Override
    public DataList readList(InputStream in) throws IOException {
        try {
            DataList dataList = (DataList)this.readValue(ProtoReader.newInstance(in), this::isList);
            return dataList;
        }
        finally {
            DataCodec.closeQuietly(in);
        }
    }

    @Override
    public DataMap readMap(ByteString in) throws IOException {
        return (DataMap)this.readValue(in.asProtoReader(), this::isMap);
    }

    @Override
    public DataList readList(ByteString in) throws IOException {
        return (DataList)this.readValue(in.asProtoReader(), this::isList);
    }

    @Deprecated
    protected Data.TraverseCallback createTraverseCallback(ProtoWriter protoWriter, SymbolTable symbolTable) {
        return new ProtobufTraverseCallback(protoWriter, new ProtobufCodecOptions.Builder().setSymbolTable(symbolTable).build());
    }

    protected Data.TraverseCallback createTraverseCallback(ProtoWriter protoWriter) {
        return new ProtobufTraverseCallback(protoWriter, this._options);
    }

    protected Object readUnknownValue(byte ordinal, ProtoReader reader) throws IOException {
        throw new DataDecodingException("Unknown ordinal: " + ordinal);
    }

    protected final DataList readList(ProtoReader reader) throws IOException {
        int size = reader.readInt32();
        DataList dataList = new DataList(size);
        for (int i = 0; i < size; ++i) {
            CheckedUtil.addWithoutChecking(dataList, this.readValue(reader, null));
        }
        return dataList;
    }

    protected final DataMap readMap(ProtoReader reader) throws IOException {
        int size = reader.readInt32();
        DataMap dataMap = new DataMap(DataMapBuilder.getOptimumHashMapCapacityFromSize(size));
        for (int i = 0; i < size; ++i) {
            CheckedUtil.putWithoutChecking(dataMap, (String)this.readValue(reader, this::isString), this.readValue(reader, null));
        }
        return dataMap;
    }

    protected final String readStringReference(ProtoReader reader) throws IOException {
        int symbolId = reader.readInt32();
        String value = this._options.getSymbolTable().getSymbolName(symbolId);
        if (value == null) {
            throw new DataDecodingException("Error decoding string reference. Symbol ID: " + symbolId);
        }
        return value;
    }

    protected final String readASCIIStringLiteral(ProtoReader reader) throws IOException {
        return reader.readASCIIString();
    }

    protected final String readStringLiteral(ProtoReader reader) throws IOException {
        return reader.readString();
    }

    protected final Object readValue(ProtoReader reader, Function<Byte, Boolean> matcher) throws IOException {
        byte ordinal = reader.readRawByte();
        if (matcher != null && !matcher.apply(ordinal).booleanValue()) {
            throw new DataDecodingException("Unable to find expected ordinal. Read: " + ordinal);
        }
        switch (ordinal) {
            case 0: {
                return this.readMap(reader);
            }
            case 1: {
                return this.readList(reader);
            }
            case 20: {
                return this.readASCIIStringLiteral(reader);
            }
            case 2: {
                return this.readStringLiteral(reader);
            }
            case 3: {
                return this.readStringReference(reader);
            }
            case 4: {
                return reader.readInt32();
            }
            case 5: {
                return reader.readInt64();
            }
            case 6: {
                return Float.valueOf(Float.intBitsToFloat(reader.readInt32()));
            }
            case 21: {
                return Float.valueOf(Float.intBitsToFloat(reader.readFixedInt32()));
            }
            case 7: {
                return Double.longBitsToDouble(reader.readInt64());
            }
            case 22: {
                return Double.longBitsToDouble(reader.readFixedInt64());
            }
            case 8: {
                return true;
            }
            case 9: {
                return false;
            }
            case 10: {
                return ByteString.unsafeWrap(reader.readByteArray());
            }
            case 11: {
                return Data.NULL;
            }
        }
        return this.readUnknownValue(ordinal, reader);
    }

    protected boolean isString(byte ordinal) {
        return ordinal == 2 || ordinal == 20 || ordinal == 3;
    }

    protected boolean isList(byte ordinal) {
        return ordinal == 1;
    }

    protected boolean isMap(byte ordinal) {
        return ordinal == 0;
    }

    public static class ProtobufTraverseCallback
    implements Data.TraverseCallback {
        protected final ProtoWriter _protoWriter;
        @Deprecated
        protected final SymbolTable _symbolTable;
        @Deprecated
        protected final boolean _supportsASCIIOnlyStrings;
        protected final ProtobufCodecOptions _options;

        @Deprecated
        public ProtobufTraverseCallback(ProtoWriter protoWriter, SymbolTable symbolTable) {
            this(protoWriter, new ProtobufCodecOptions.Builder().setSymbolTable(symbolTable).build());
        }

        @Deprecated
        public ProtobufTraverseCallback(ProtoWriter protoWriter, SymbolTable symbolTable, boolean supportsASCIIOnlyStrings) {
            this(protoWriter, new ProtobufCodecOptions.Builder().setSymbolTable(symbolTable).setEnableASCIIOnlyStrings(supportsASCIIOnlyStrings).build());
        }

        public ProtobufTraverseCallback(ProtoWriter protoWriter, ProtobufCodecOptions options) {
            this._protoWriter = protoWriter;
            this._options = options;
            this._symbolTable = options.getSymbolTable();
            this._supportsASCIIOnlyStrings = options.shouldEnableASCIIOnlyStrings();
        }

        @Override
        public void nullValue() throws IOException {
            this._protoWriter.writeByte((byte)11);
        }

        @Override
        public void booleanValue(boolean value) throws IOException {
            if (value) {
                this._protoWriter.writeByte((byte)8);
            } else {
                this._protoWriter.writeByte((byte)9);
            }
        }

        @Override
        public void integerValue(int value) throws IOException {
            this._protoWriter.writeByte((byte)4);
            this._protoWriter.writeInt32(value);
        }

        @Override
        public void longValue(long value) throws IOException {
            this._protoWriter.writeByte((byte)5);
            this._protoWriter.writeInt64(value);
        }

        @Override
        public void floatValue(float value) throws IOException {
            if (this._options.shouldEnableFixedLengthFloatDoubles()) {
                this._protoWriter.writeByte((byte)21);
                this._protoWriter.writeFixedInt32(Float.floatToRawIntBits(value));
            } else {
                this._protoWriter.writeByte((byte)6);
                this._protoWriter.writeInt32(Float.floatToRawIntBits(value));
            }
        }

        @Override
        public void doubleValue(double value) throws IOException {
            if (this._options.shouldEnableFixedLengthFloatDoubles()) {
                this._protoWriter.writeByte((byte)22);
                this._protoWriter.writeFixedInt64(Double.doubleToRawLongBits(value));
            } else {
                this._protoWriter.writeByte((byte)7);
                this._protoWriter.writeInt64(Double.doubleToRawLongBits(value));
            }
        }

        @Override
        public void stringValue(String value) throws IOException {
            int symbolId = this._options.getSymbolTable().getSymbolId(value);
            if (symbolId != -1) {
                this._protoWriter.writeByte((byte)3);
                this._protoWriter.writeUInt32(symbolId);
            } else {
                this._protoWriter.writeString(value, byteLength -> (byte)(this._options.shouldEnableASCIIOnlyStrings() && value.length() == byteLength.intValue() ? 20 : 2), this._options.shouldTolerateInvalidSurrogatePairs());
            }
        }

        @Override
        public void byteStringValue(ByteString value) throws IOException {
            this._protoWriter.writeByte((byte)10);
            value.write(this._protoWriter);
        }

        @Override
        public void illegalValue(Object value) throws IOException {
            throw new DataEncodingException("Illegal value encountered: " + value);
        }

        @Override
        public void emptyMap() throws IOException {
            this._protoWriter.writeByte((byte)0);
            this._protoWriter.writeUInt32(0);
        }

        @Override
        public void startMap(DataMap map) throws IOException {
            this._protoWriter.writeByte((byte)0);
            this._protoWriter.writeUInt32(map.size());
        }

        @Override
        public void key(String key) throws IOException {
            this.stringValue(key);
        }

        @Override
        public void emptyList() throws IOException {
            this._protoWriter.writeByte((byte)1);
            this._protoWriter.writeUInt32(0);
        }

        @Override
        public void startList(DataList list) throws IOException {
            this._protoWriter.writeByte((byte)1);
            this._protoWriter.writeUInt32(list.size());
        }

        @Override
        public void close() throws IOException {
            this._protoWriter.close();
        }
    }
}

