/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dashboard;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DashboardUserUsageCounts
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dashboard/**Records a single user's usage counts for a given resource*/record DashboardUserUsageCounts{/**The unique id of the user.*/user:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The number of times the user has viewed the dashboard*/@TimeseriesField={}viewsCount:optional int/**The number of times the user has executed (refreshed) the dashboard*/@TimeseriesField={}executionsCount:optional int/**Normalized numeric metric representing user's dashboard usage -- the number of times the user executed or viewed the dashboard. */@TimeseriesField={}usageCount:optional int/**If user_email is set, we attempt to resolve the user's urn upon ingest*/@TimeseriesField={}userEmail:optional string}", SchemaFormatType.PDL);
    private Urn _userField = null;
    private Integer _viewsCountField = null;
    private Integer _executionsCountField = null;
    private Integer _usageCountField = null;
    private String _userEmailField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_User = SCHEMA.getField("user");
    private static final RecordDataSchema.Field FIELD_ViewsCount = SCHEMA.getField("viewsCount");
    private static final RecordDataSchema.Field FIELD_ExecutionsCount = SCHEMA.getField("executionsCount");
    private static final RecordDataSchema.Field FIELD_UsageCount = SCHEMA.getField("usageCount");
    private static final RecordDataSchema.Field FIELD_UserEmail = SCHEMA.getField("userEmail");

    public DashboardUserUsageCounts() {
        super(new DataMap(7, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DashboardUserUsageCounts(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUser() {
        if (this._userField != null) {
            return true;
        }
        return this._map.containsKey("user");
    }

    public void removeUser() {
        this._map.remove("user");
    }

    @Nullable
    public Urn getUser(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getUser();
            }
            case DEFAULT: 
            case NULL: {
                if (this._userField != null) {
                    return this._userField;
                }
                Object __rawValue = this._map.get("user");
                this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._userField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getUser() {
        if (this._userField != null) {
            return this._userField;
        }
        Object __rawValue = this._map.get("user");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("user");
        }
        this._userField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._userField;
    }

    public DashboardUserUsageCounts setUser(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUser(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field user of com.linkedin.dashboard.DashboardUserUsageCounts");
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUser();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._userField = value;
            }
        }
        return this;
    }

    public DashboardUserUsageCounts setUser(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field user of com.linkedin.dashboard.DashboardUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "user", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._userField = value;
        return this;
    }

    public boolean hasViewsCount() {
        if (this._viewsCountField != null) {
            return true;
        }
        return this._map.containsKey("viewsCount");
    }

    public void removeViewsCount() {
        this._map.remove("viewsCount");
    }

    @Nullable
    public Integer getViewsCount(GetMode mode) {
        return this.getViewsCount();
    }

    @Nullable
    public Integer getViewsCount() {
        if (this._viewsCountField != null) {
            return this._viewsCountField;
        }
        Object __rawValue = this._map.get("viewsCount");
        this._viewsCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._viewsCountField;
    }

    public DashboardUserUsageCounts setViewsCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setViewsCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeViewsCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
                this._viewsCountField = value;
            }
        }
        return this;
    }

    public DashboardUserUsageCounts setViewsCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field viewsCount of com.linkedin.dashboard.DashboardUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    public DashboardUserUsageCounts setViewsCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "viewsCount", DataTemplateUtil.coerceIntInput(value));
        this._viewsCountField = value;
        return this;
    }

    public boolean hasExecutionsCount() {
        if (this._executionsCountField != null) {
            return true;
        }
        return this._map.containsKey("executionsCount");
    }

    public void removeExecutionsCount() {
        this._map.remove("executionsCount");
    }

    @Nullable
    public Integer getExecutionsCount(GetMode mode) {
        return this.getExecutionsCount();
    }

    @Nullable
    public Integer getExecutionsCount() {
        if (this._executionsCountField != null) {
            return this._executionsCountField;
        }
        Object __rawValue = this._map.get("executionsCount");
        this._executionsCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._executionsCountField;
    }

    public DashboardUserUsageCounts setExecutionsCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExecutionsCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExecutionsCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
                this._executionsCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
                this._executionsCountField = value;
            }
        }
        return this;
    }

    public DashboardUserUsageCounts setExecutionsCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field executionsCount of com.linkedin.dashboard.DashboardUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
        this._executionsCountField = value;
        return this;
    }

    public DashboardUserUsageCounts setExecutionsCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "executionsCount", DataTemplateUtil.coerceIntInput(value));
        this._executionsCountField = value;
        return this;
    }

    public boolean hasUsageCount() {
        if (this._usageCountField != null) {
            return true;
        }
        return this._map.containsKey("usageCount");
    }

    public void removeUsageCount() {
        this._map.remove("usageCount");
    }

    @Nullable
    public Integer getUsageCount(GetMode mode) {
        return this.getUsageCount();
    }

    @Nullable
    public Integer getUsageCount() {
        if (this._usageCountField != null) {
            return this._usageCountField;
        }
        Object __rawValue = this._map.get("usageCount");
        this._usageCountField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._usageCountField;
    }

    public DashboardUserUsageCounts setUsageCount(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUsageCount(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUsageCount();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "usageCount", DataTemplateUtil.coerceIntInput(value));
                this._usageCountField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "usageCount", DataTemplateUtil.coerceIntInput(value));
                this._usageCountField = value;
            }
        }
        return this;
    }

    public DashboardUserUsageCounts setUsageCount(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field usageCount of com.linkedin.dashboard.DashboardUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "usageCount", DataTemplateUtil.coerceIntInput(value));
        this._usageCountField = value;
        return this;
    }

    public DashboardUserUsageCounts setUsageCount(int value) {
        CheckedUtil.putWithoutChecking(this._map, "usageCount", DataTemplateUtil.coerceIntInput(value));
        this._usageCountField = value;
        return this;
    }

    public boolean hasUserEmail() {
        if (this._userEmailField != null) {
            return true;
        }
        return this._map.containsKey("userEmail");
    }

    public void removeUserEmail() {
        this._map.remove("userEmail");
    }

    @Nullable
    public String getUserEmail(GetMode mode) {
        return this.getUserEmail();
    }

    @Nullable
    public String getUserEmail() {
        if (this._userEmailField != null) {
            return this._userEmailField;
        }
        Object __rawValue = this._map.get("userEmail");
        this._userEmailField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userEmailField;
    }

    public DashboardUserUsageCounts setUserEmail(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserEmail(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserEmail();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
                this._userEmailField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
                this._userEmailField = value;
            }
        }
        return this;
    }

    public DashboardUserUsageCounts setUserEmail(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userEmail of com.linkedin.dashboard.DashboardUserUsageCounts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userEmail", value);
        this._userEmailField = value;
        return this;
    }

    @Override
    public DashboardUserUsageCounts clone() throws CloneNotSupportedException {
        DashboardUserUsageCounts __clone = (DashboardUserUsageCounts)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DashboardUserUsageCounts copy() throws CloneNotSupportedException {
        DashboardUserUsageCounts __copy = (DashboardUserUsageCounts)super.copy();
        __copy._viewsCountField = null;
        __copy._executionsCountField = null;
        __copy._userEmailField = null;
        __copy._userField = null;
        __copy._usageCountField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DashboardUserUsageCounts __objectRef;

        private ChangeListener(DashboardUserUsageCounts reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "viewsCount": {
                    this.__objectRef._viewsCountField = null;
                    break;
                }
                case "executionsCount": {
                    this.__objectRef._executionsCountField = null;
                    break;
                }
                case "userEmail": {
                    this.__objectRef._userEmailField = null;
                    break;
                }
                case "user": {
                    this.__objectRef._userField = null;
                    break;
                }
                case "usageCount": {
                    this.__objectRef._usageCountField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec user() {
            return new PathSpec(this.getPathComponents(), "user");
        }

        public PathSpec viewsCount() {
            return new PathSpec(this.getPathComponents(), "viewsCount");
        }

        public PathSpec executionsCount() {
            return new PathSpec(this.getPathComponents(), "executionsCount");
        }

        public PathSpec usageCount() {
            return new PathSpec(this.getPathComponents(), "usageCount");
        }

        public PathSpec userEmail() {
            return new PathSpec(this.getPathComponents(), "userEmail");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withUser() {
            this.getDataMap().put("user", 1);
            return this;
        }

        public ProjectionMask withViewsCount() {
            this.getDataMap().put("viewsCount", 1);
            return this;
        }

        public ProjectionMask withExecutionsCount() {
            this.getDataMap().put("executionsCount", 1);
            return this;
        }

        public ProjectionMask withUsageCount() {
            this.getDataMap().put("usageCount", 1);
            return this;
        }

        public ProjectionMask withUserEmail() {
            this.getDataMap().put("userEmail", 1);
            return this;
        }
    }
}

