/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.dashboard;

import com.linkedin.common.AccessLevel;
import com.linkedin.common.ChangeAuditStamps;
import com.linkedin.common.ChartUrnArray;
import com.linkedin.common.EdgeArray;
import com.linkedin.common.UrnArray;
import com.linkedin.common.url.Url;
import com.linkedin.common.url.UrlCoercer;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DashboardInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.dashboard/**Information about a dashboard*/@Aspect.name=\"dashboardInfo\"record DashboardInfo includes{namespace com.linkedin.common/**Misc. properties about an entity.*/record CustomProperties{/**Custom property bag.*/@Searchable.`/*`={\"fieldType\":\"TEXT\",\"queryByDefault\":true}customProperties:map[string,string]={}}}{namespace com.linkedin.common/**A reference to an external platform.*/record ExternalReference{/**URL where the reference exist*/@Searchable.fieldType=\"KEYWORD\"externalUrl:optional@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}{/**Title of the dashboard*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}title:string/**Detailed description about the dashboard*/@Searchable={\"fieldType\":\"TEXT\",\"hasValuesFieldName\":\"hasDescription\"}description:string/**Charts in a dashboard\nDeprecated! Use chartEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"chart\"],\"isLineage\":true,\"name\":\"Contains\"}@deprecated,charts:array[{namespace com.linkedin.common/**Standardized chart identifier*/@java.class=\"com.linkedin.common.urn.ChartUrn\"@validate.`com.linkedin.common.validator.TypedUrnValidator`={\"accessible\":true,\"constructable\":true,\"doc\":\"Standardized chart identifier\",\"entityType\":\"chart\",\"fields\":[{\"doc\":\"The name of the dashboard tool such as looker, redash etc.\",\"maxLength\":20,\"name\":\"dashboardTool\",\"type\":\"string\"},{\"doc\":\"Unique id for the chart. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, chart URL could be used here for Looker such as 'looker.linkedin.com/looks/1234'\",\"maxLength\":200,\"name\":\"chartId\",\"type\":\"string\"}],\"maxLength\":236,\"name\":\"Chart\",\"namespace\":\"li\",\"owners\":[\"urn:li:corpuser:fbar\",\"urn:li:corpuser:bfoo\"],\"owningTeam\":\"urn:li:internalTeam:datahub\"}typeref ChartUrn=string}]=[]/**Charts in a dashboard*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"chartEdges/*/created/actor\",\"createdOn\":\"chartEdges/*/created/time\",\"entityTypes\":[\"chart\"],\"isLineage\":true,\"name\":\"Contains\",\"properties\":\"chartEdges/*/properties\",\"updatedActor\":\"chartEdges/*/lastModified/actor\",\"updatedOn\":\"chartEdges/*/lastModified/time\"}chartEdges:optional array[{namespace com.linkedin.common/**A common structure to represent all edges to entities when used inside aspects as collections\nThis ensures that all edges have common structure around audit-stamps and will support PATCH, time-travel automatically.\n*/record Edge{/**Urn of the source of this relationship edge.\nIf not specified, assumed to be the entity that this aspect belongs to.*/sourceUrn:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Urn of the destination of this relationship edge.*/destinationUrn:Urn/**Audit stamp containing who created this relationship edge and when*/created:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}/**Audit stamp containing who last modified this relationship edge and when*/lastModified:optional AuditStamp/**A generic properties bag that allows us to store specific information on this graph edge.*/properties:optional map[string,string]}}]/**Datasets consumed by a dashboard\nDeprecated! Use datasetEdges instead.*/@Relationship.`/*`={\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\"}@deprecated,datasets:array[com.linkedin.common.Urn]=[]/**Datasets consumed by a dashboard*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"datasetEdges/*/created/actor\",\"createdOn\":\"datasetEdges/*/created/time\",\"entityTypes\":[\"dataset\"],\"isLineage\":true,\"name\":\"Consumes\",\"properties\":\"datasetEdges/*/properties\",\"updatedActor\":\"datasetEdges/*/lastModified/actor\",\"updatedOn\":\"datasetEdges/*/lastModified/time\"}datasetEdges:optional array[com.linkedin.common.Edge]/**Dashboards included by this dashboard.\nSome dashboard entities (e.g. PowerBI Apps) can contain other dashboards.\n\nThe Edge's sourceUrn should never be set, as it will always be the base dashboard.*/@Relationship.`/*/destinationUrn`={\"createdActor\":\"dashboards/*/created/actor\",\"createdOn\":\"dashboards/*/created/time\",\"entityTypes\":[\"dashboard\"],\"isLineage\":true,\"name\":\"DashboardContainsDashboard\",\"properties\":\"dashboards/*/properties\",\"updatedActor\":\"dashboards/*/lastModified/actor\",\"updatedOn\":\"dashboards/*/lastModified/time\"}dashboards:array[com.linkedin.common.Edge]=[]/**Captures information about who created/last modified/deleted this dashboard and when*/lastModified:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into various lifecycle stages, and who acted to move it into those lifecycle stages. The recommended best practice is to include this record in your record schema, and annotate its fields as @readOnly in your resource. See https://github.com/linkedin/rest.li/wiki/Validation-in-Rest.li#restli-validation-annotations*/record ChangeAuditStamps{/**An AuditStamp corresponding to the creation of this resource/association/sub-resource. A value of 0 for time indicates missing data.*/created:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the last modification of this resource/association/sub-resource. If no modification has happened since creation, lastModified should be the same as created. A value of 0 for time indicates missing data.*/lastModified:AuditStamp={\"time\":0,\"actor\":\"urn:li:corpuser:unknown\"}/**An AuditStamp corresponding to the deletion of this resource/association/sub-resource. Logically, deleted MUST have a later timestamp than creation. It may or may not have the same time as lastModified depending upon the resource/association/sub-resource semantics.*/deleted:optional AuditStamp}}/**URL for the dashboard. This could be used as an external link on DataHub to allow users access/view the dashboard*/@Searchable.fieldType=\"KEYWORD\"dashboardUrl:optional com.linkedin.common.Url/**Access level for the dashboard*/@Searchable={\"addToFilters\":true,\"fieldType\":\"KEYWORD\",\"filterNameOverride\":\"Access Level\"}access:optional{namespace com.linkedin.common/**The various access levels*/enum AccessLevel{/**Publicly available access level*/PUBLIC/**Private availability to certain set of users*/PRIVATE}}/**The time when this dashboard last refreshed*/lastRefreshed:optional com.linkedin.common.Time}", SchemaFormatType.PDL);
    private StringMap _customPropertiesField = null;
    private Url _externalUrlField = null;
    private String _titleField = null;
    private String _descriptionField = null;
    private ChartUrnArray _chartsField = null;
    private EdgeArray _chartEdgesField = null;
    private UrnArray _datasetsField = null;
    private EdgeArray _datasetEdgesField = null;
    private EdgeArray _dashboardsField = null;
    private ChangeAuditStamps _lastModifiedField = null;
    private Url _dashboardUrlField = null;
    private AccessLevel _accessField = null;
    private Long _lastRefreshedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_CustomProperties = SCHEMA.getField("customProperties");
    private static final StringMap DEFAULT_CustomProperties;
    private static final RecordDataSchema.Field FIELD_ExternalUrl;
    private static final RecordDataSchema.Field FIELD_Title;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_Charts;
    private static final ChartUrnArray DEFAULT_Charts;
    private static final RecordDataSchema.Field FIELD_ChartEdges;
    private static final RecordDataSchema.Field FIELD_Datasets;
    private static final UrnArray DEFAULT_Datasets;
    private static final RecordDataSchema.Field FIELD_DatasetEdges;
    private static final RecordDataSchema.Field FIELD_Dashboards;
    private static final EdgeArray DEFAULT_Dashboards;
    private static final RecordDataSchema.Field FIELD_LastModified;
    private static final RecordDataSchema.Field FIELD_DashboardUrl;
    private static final RecordDataSchema.Field FIELD_Access;
    private static final RecordDataSchema.Field FIELD_LastRefreshed;

    public DashboardInfo() {
        super(new DataMap(), SCHEMA, 10);
        this.addChangeListener(this.__changeListener);
    }

    public DashboardInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCustomProperties();
            }
            case NULL: {
                if (this._customPropertiesField != null) {
                    return this._customPropertiesField;
                }
                Object __rawValue = this._map.get("customProperties");
                this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._customPropertiesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        if (__rawValue == null) {
            return DEFAULT_CustomProperties;
        }
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public DashboardInfo setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field customProperties of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public DashboardInfo setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasExternalUrl() {
        if (this._externalUrlField != null) {
            return true;
        }
        return this._map.containsKey("externalUrl");
    }

    public void removeExternalUrl() {
        this._map.remove("externalUrl");
    }

    @Nullable
    public Url getExternalUrl(GetMode mode) {
        return this.getExternalUrl();
    }

    @Nullable
    public Url getExternalUrl() {
        if (this._externalUrlField != null) {
            return this._externalUrlField;
        }
        Object __rawValue = this._map.get("externalUrl");
        this._externalUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._externalUrlField;
    }

    public DashboardInfo setExternalUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setExternalUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeExternalUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._externalUrlField = value;
            }
        }
        return this;
    }

    public DashboardInfo setExternalUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field externalUrl of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "externalUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._externalUrlField = value;
        return this;
    }

    public boolean hasTitle() {
        if (this._titleField != null) {
            return true;
        }
        return this._map.containsKey("title");
    }

    public void removeTitle() {
        this._map.remove("title");
    }

    @Nullable
    public String getTitle(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTitle();
            }
            case DEFAULT: 
            case NULL: {
                if (this._titleField != null) {
                    return this._titleField;
                }
                Object __rawValue = this._map.get("title");
                this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._titleField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTitle() {
        if (this._titleField != null) {
            return this._titleField;
        }
        Object __rawValue = this._map.get("title");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("title");
        }
        this._titleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._titleField;
    }

    public DashboardInfo setTitle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTitle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field title of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTitle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "title", value);
                this._titleField = value;
            }
        }
        return this;
    }

    public DashboardInfo setTitle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field title of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "title", value);
        this._titleField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDescription();
            }
            case DEFAULT: 
            case NULL: {
                if (this._descriptionField != null) {
                    return this._descriptionField;
                }
                Object __rawValue = this._map.get("description");
                this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._descriptionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("description");
        }
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public DashboardInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field description of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public DashboardInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    @Deprecated
    public boolean hasCharts() {
        if (this._chartsField != null) {
            return true;
        }
        return this._map.containsKey("charts");
    }

    @Deprecated
    public void removeCharts() {
        this._map.remove("charts");
    }

    @Deprecated
    @Nullable
    public ChartUrnArray getCharts(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCharts();
            }
            case NULL: {
                if (this._chartsField != null) {
                    return this._chartsField;
                }
                Object __rawValue = this._map.get("charts");
                this._chartsField = __rawValue == null ? null : new ChartUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._chartsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public ChartUrnArray getCharts() {
        if (this._chartsField != null) {
            return this._chartsField;
        }
        Object __rawValue = this._map.get("charts");
        if (__rawValue == null) {
            return DEFAULT_Charts;
        }
        this._chartsField = __rawValue == null ? null : new ChartUrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._chartsField;
    }

    @Deprecated
    public DashboardInfo setCharts(@Nullable ChartUrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCharts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field charts of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "charts", value.data());
                this._chartsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCharts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "charts", value.data());
                this._chartsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "charts", value.data());
                this._chartsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DashboardInfo setCharts(@Nonnull ChartUrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field charts of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "charts", value.data());
        this._chartsField = value;
        return this;
    }

    public boolean hasChartEdges() {
        if (this._chartEdgesField != null) {
            return true;
        }
        return this._map.containsKey("chartEdges");
    }

    public void removeChartEdges() {
        this._map.remove("chartEdges");
    }

    @Nullable
    public EdgeArray getChartEdges(GetMode mode) {
        return this.getChartEdges();
    }

    @Nullable
    public EdgeArray getChartEdges() {
        if (this._chartEdgesField != null) {
            return this._chartEdgesField;
        }
        Object __rawValue = this._map.get("chartEdges");
        this._chartEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._chartEdgesField;
    }

    public DashboardInfo setChartEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChartEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChartEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "chartEdges", value.data());
                this._chartEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "chartEdges", value.data());
                this._chartEdgesField = value;
            }
        }
        return this;
    }

    public DashboardInfo setChartEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field chartEdges of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "chartEdges", value.data());
        this._chartEdgesField = value;
        return this;
    }

    @Deprecated
    public boolean hasDatasets() {
        if (this._datasetsField != null) {
            return true;
        }
        return this._map.containsKey("datasets");
    }

    @Deprecated
    public void removeDatasets() {
        this._map.remove("datasets");
    }

    @Deprecated
    @Nullable
    public UrnArray getDatasets(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDatasets();
            }
            case NULL: {
                if (this._datasetsField != null) {
                    return this._datasetsField;
                }
                Object __rawValue = this._map.get("datasets");
                this._datasetsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._datasetsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Deprecated
    @Nonnull
    public UrnArray getDatasets() {
        if (this._datasetsField != null) {
            return this._datasetsField;
        }
        Object __rawValue = this._map.get("datasets");
        if (__rawValue == null) {
            return DEFAULT_Datasets;
        }
        this._datasetsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._datasetsField;
    }

    @Deprecated
    public DashboardInfo setDatasets(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDatasets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field datasets of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "datasets", value.data());
                this._datasetsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDatasets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "datasets", value.data());
                this._datasetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "datasets", value.data());
                this._datasetsField = value;
            }
        }
        return this;
    }

    @Deprecated
    public DashboardInfo setDatasets(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field datasets of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "datasets", value.data());
        this._datasetsField = value;
        return this;
    }

    public boolean hasDatasetEdges() {
        if (this._datasetEdgesField != null) {
            return true;
        }
        return this._map.containsKey("datasetEdges");
    }

    public void removeDatasetEdges() {
        this._map.remove("datasetEdges");
    }

    @Nullable
    public EdgeArray getDatasetEdges(GetMode mode) {
        return this.getDatasetEdges();
    }

    @Nullable
    public EdgeArray getDatasetEdges() {
        if (this._datasetEdgesField != null) {
            return this._datasetEdgesField;
        }
        Object __rawValue = this._map.get("datasetEdges");
        this._datasetEdgesField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._datasetEdgesField;
    }

    public DashboardInfo setDatasetEdges(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDatasetEdges(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDatasetEdges();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "datasetEdges", value.data());
                this._datasetEdgesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "datasetEdges", value.data());
                this._datasetEdgesField = value;
            }
        }
        return this;
    }

    public DashboardInfo setDatasetEdges(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field datasetEdges of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "datasetEdges", value.data());
        this._datasetEdgesField = value;
        return this;
    }

    public boolean hasDashboards() {
        if (this._dashboardsField != null) {
            return true;
        }
        return this._map.containsKey("dashboards");
    }

    public void removeDashboards() {
        this._map.remove("dashboards");
    }

    @Nullable
    public EdgeArray getDashboards(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getDashboards();
            }
            case NULL: {
                if (this._dashboardsField != null) {
                    return this._dashboardsField;
                }
                Object __rawValue = this._map.get("dashboards");
                this._dashboardsField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._dashboardsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public EdgeArray getDashboards() {
        if (this._dashboardsField != null) {
            return this._dashboardsField;
        }
        Object __rawValue = this._map.get("dashboards");
        if (__rawValue == null) {
            return DEFAULT_Dashboards;
        }
        this._dashboardsField = __rawValue == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._dashboardsField;
    }

    public DashboardInfo setDashboards(@Nullable EdgeArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDashboards(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dashboards of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboards", value.data());
                this._dashboardsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDashboards();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboards", value.data());
                this._dashboardsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dashboards", value.data());
                this._dashboardsField = value;
            }
        }
        return this;
    }

    public DashboardInfo setDashboards(@Nonnull EdgeArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dashboards of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dashboards", value.data());
        this._dashboardsField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public ChangeAuditStamps getLastModified(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastModified();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastModifiedField != null) {
                    return this._lastModifiedField;
                }
                Object __rawValue = this._map.get("lastModified");
                this._lastModifiedField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._lastModifiedField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ChangeAuditStamps getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastModified");
        }
        this._lastModifiedField = __rawValue == null ? null : new ChangeAuditStamps(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public DashboardInfo setLastModified(@Nullable ChangeAuditStamps value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastModified of com.linkedin.dashboard.DashboardInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public DashboardInfo setLastModified(@Nonnull ChangeAuditStamps value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    public boolean hasDashboardUrl() {
        if (this._dashboardUrlField != null) {
            return true;
        }
        return this._map.containsKey("dashboardUrl");
    }

    public void removeDashboardUrl() {
        this._map.remove("dashboardUrl");
    }

    @Nullable
    public Url getDashboardUrl(GetMode mode) {
        return this.getDashboardUrl();
    }

    @Nullable
    public Url getDashboardUrl() {
        if (this._dashboardUrlField != null) {
            return this._dashboardUrlField;
        }
        Object __rawValue = this._map.get("dashboardUrl");
        this._dashboardUrlField = DataTemplateUtil.coerceCustomOutput(__rawValue, Url.class);
        return this._dashboardUrlField;
    }

    public DashboardInfo setDashboardUrl(@Nullable Url value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDashboardUrl(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDashboardUrl();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._dashboardUrlField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dashboardUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
                this._dashboardUrlField = value;
            }
        }
        return this;
    }

    public DashboardInfo setDashboardUrl(@Nonnull Url value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dashboardUrl of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dashboardUrl", DataTemplateUtil.coerceCustomInput(value, Url.class));
        this._dashboardUrlField = value;
        return this;
    }

    public boolean hasAccess() {
        if (this._accessField != null) {
            return true;
        }
        return this._map.containsKey("access");
    }

    public void removeAccess() {
        this._map.remove("access");
    }

    @Nullable
    public AccessLevel getAccess(GetMode mode) {
        return this.getAccess();
    }

    @Nullable
    public AccessLevel getAccess() {
        if (this._accessField != null) {
            return this._accessField;
        }
        Object __rawValue = this._map.get("access");
        this._accessField = DataTemplateUtil.coerceEnumOutput(__rawValue, AccessLevel.class, AccessLevel.$UNKNOWN);
        return this._accessField;
    }

    public DashboardInfo setAccess(@Nullable AccessLevel value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAccess(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAccess();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "access", value.name());
                this._accessField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "access", value.name());
                this._accessField = value;
            }
        }
        return this;
    }

    public DashboardInfo setAccess(@Nonnull AccessLevel value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field access of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "access", value.name());
        this._accessField = value;
        return this;
    }

    public boolean hasLastRefreshed() {
        if (this._lastRefreshedField != null) {
            return true;
        }
        return this._map.containsKey("lastRefreshed");
    }

    public void removeLastRefreshed() {
        this._map.remove("lastRefreshed");
    }

    @Nullable
    public Long getLastRefreshed(GetMode mode) {
        return this.getLastRefreshed();
    }

    @Nullable
    public Long getLastRefreshed() {
        if (this._lastRefreshedField != null) {
            return this._lastRefreshedField;
        }
        Object __rawValue = this._map.get("lastRefreshed");
        this._lastRefreshedField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastRefreshedField;
    }

    public DashboardInfo setLastRefreshed(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastRefreshed(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastRefreshed();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
                this._lastRefreshedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
                this._lastRefreshedField = value;
            }
        }
        return this;
    }

    public DashboardInfo setLastRefreshed(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastRefreshed of com.linkedin.dashboard.DashboardInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
        this._lastRefreshedField = value;
        return this;
    }

    public DashboardInfo setLastRefreshed(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastRefreshed", DataTemplateUtil.coerceLongInput(value));
        this._lastRefreshedField = value;
        return this;
    }

    @Override
    public DashboardInfo clone() throws CloneNotSupportedException {
        DashboardInfo __clone = (DashboardInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DashboardInfo copy() throws CloneNotSupportedException {
        DashboardInfo __copy = (DashboardInfo)super.copy();
        __copy._externalUrlField = null;
        __copy._chartEdgesField = null;
        __copy._lastRefreshedField = null;
        __copy._chartsField = null;
        __copy._dashboardUrlField = null;
        __copy._accessField = null;
        __copy._descriptionField = null;
        __copy._datasetsField = null;
        __copy._titleField = null;
        __copy._dashboardsField = null;
        __copy._customPropertiesField = null;
        __copy._datasetEdgesField = null;
        __copy._lastModifiedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ExternalUrl = SCHEMA.getField("externalUrl");
        FIELD_Title = SCHEMA.getField("title");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_Charts = SCHEMA.getField("charts");
        FIELD_ChartEdges = SCHEMA.getField("chartEdges");
        FIELD_Datasets = SCHEMA.getField("datasets");
        FIELD_DatasetEdges = SCHEMA.getField("datasetEdges");
        FIELD_Dashboards = SCHEMA.getField("dashboards");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        FIELD_DashboardUrl = SCHEMA.getField("dashboardUrl");
        FIELD_Access = SCHEMA.getField("access");
        FIELD_LastRefreshed = SCHEMA.getField("lastRefreshed");
        Custom.initializeCustomClass(Url.class);
        Custom.initializeCoercerClass(UrlCoercer.class);
        DEFAULT_CustomProperties = FIELD_CustomProperties.getDefault() == null ? null : new StringMap(DataTemplateUtil.castOrThrow(FIELD_CustomProperties.getDefault(), DataMap.class));
        DEFAULT_Charts = FIELD_Charts.getDefault() == null ? null : new ChartUrnArray(DataTemplateUtil.castOrThrow(FIELD_Charts.getDefault(), DataList.class));
        DEFAULT_Datasets = FIELD_Datasets.getDefault() == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(FIELD_Datasets.getDefault(), DataList.class));
        DEFAULT_Dashboards = FIELD_Dashboards.getDefault() == null ? null : new EdgeArray(DataTemplateUtil.castOrThrow(FIELD_Dashboards.getDefault(), DataList.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DashboardInfo __objectRef;

        private ChangeListener(DashboardInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "externalUrl": {
                    this.__objectRef._externalUrlField = null;
                    break;
                }
                case "chartEdges": {
                    this.__objectRef._chartEdgesField = null;
                    break;
                }
                case "lastRefreshed": {
                    this.__objectRef._lastRefreshedField = null;
                    break;
                }
                case "charts": {
                    this.__objectRef._chartsField = null;
                    break;
                }
                case "dashboardUrl": {
                    this.__objectRef._dashboardUrlField = null;
                    break;
                }
                case "access": {
                    this.__objectRef._accessField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "datasets": {
                    this.__objectRef._datasetsField = null;
                    break;
                }
                case "title": {
                    this.__objectRef._titleField = null;
                    break;
                }
                case "dashboards": {
                    this.__objectRef._dashboardsField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "datasetEdges": {
                    this.__objectRef._datasetEdgesField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec externalUrl() {
            return new PathSpec(this.getPathComponents(), "externalUrl");
        }

        public PathSpec title() {
            return new PathSpec(this.getPathComponents(), "title");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        @Deprecated
        public PathSpec charts() {
            return new PathSpec(this.getPathComponents(), "charts");
        }

        @Deprecated
        public PathSpec charts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "charts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields chartEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "chartEdges");
        }

        public PathSpec chartEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "chartEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        @Deprecated
        public PathSpec datasets() {
            return new PathSpec(this.getPathComponents(), "datasets");
        }

        @Deprecated
        public PathSpec datasets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "datasets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields datasetEdges() {
            return new EdgeArray.Fields(this.getPathComponents(), "datasetEdges");
        }

        public PathSpec datasetEdges(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "datasetEdges");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public EdgeArray.Fields dashboards() {
            return new EdgeArray.Fields(this.getPathComponents(), "dashboards");
        }

        public PathSpec dashboards(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "dashboards");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public ChangeAuditStamps.Fields lastModified() {
            return new ChangeAuditStamps.Fields(this.getPathComponents(), "lastModified");
        }

        public PathSpec dashboardUrl() {
            return new PathSpec(this.getPathComponents(), "dashboardUrl");
        }

        public PathSpec access() {
            return new PathSpec(this.getPathComponents(), "access");
        }

        public PathSpec lastRefreshed() {
            return new PathSpec(this.getPathComponents(), "lastRefreshed");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private EdgeArray.ProjectionMask _chartEdgesMask;
        private EdgeArray.ProjectionMask _datasetEdgesMask;
        private EdgeArray.ProjectionMask _dashboardsMask;
        private ChangeAuditStamps.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withExternalUrl() {
            this.getDataMap().put("externalUrl", 1);
            return this;
        }

        public ProjectionMask withTitle() {
            this.getDataMap().put("title", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withCharts() {
            this.getDataMap().put("charts", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withCharts(Integer start, Integer count) {
            this.getDataMap().put("charts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("charts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("charts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withChartEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._chartEdgesMask = nestedMask.apply(this._chartEdgesMask == null ? EdgeArray.createMask() : this._chartEdgesMask);
            this.getDataMap().put("chartEdges", this._chartEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withChartEdges() {
            this._chartEdgesMask = null;
            this.getDataMap().put("chartEdges", 1);
            return this;
        }

        public ProjectionMask withChartEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._chartEdgesMask = nestedMask.apply(this._chartEdgesMask == null ? EdgeArray.createMask() : this._chartEdgesMask);
            this.getDataMap().put("chartEdges", this._chartEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("chartEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("chartEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withChartEdges(Integer start, Integer count) {
            this._chartEdgesMask = null;
            this.getDataMap().put("chartEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("chartEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("chartEdges").put("$count", count);
            }
            return this;
        }

        @Deprecated
        public ProjectionMask withDatasets() {
            this.getDataMap().put("datasets", 1);
            return this;
        }

        @Deprecated
        public ProjectionMask withDatasets(Integer start, Integer count) {
            this.getDataMap().put("datasets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("datasets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("datasets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._datasetEdgesMask = nestedMask.apply(this._datasetEdgesMask == null ? EdgeArray.createMask() : this._datasetEdgesMask);
            this.getDataMap().put("datasetEdges", this._datasetEdgesMask.getDataMap());
            return this;
        }

        public ProjectionMask withDatasetEdges() {
            this._datasetEdgesMask = null;
            this.getDataMap().put("datasetEdges", 1);
            return this;
        }

        public ProjectionMask withDatasetEdges(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._datasetEdgesMask = nestedMask.apply(this._datasetEdgesMask == null ? EdgeArray.createMask() : this._datasetEdgesMask);
            this.getDataMap().put("datasetEdges", this._datasetEdgesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("datasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("datasetEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDatasetEdges(Integer start, Integer count) {
            this._datasetEdgesMask = null;
            this.getDataMap().put("datasetEdges", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("datasetEdges").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("datasetEdges").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDashboards(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask) {
            this._dashboardsMask = nestedMask.apply(this._dashboardsMask == null ? EdgeArray.createMask() : this._dashboardsMask);
            this.getDataMap().put("dashboards", this._dashboardsMask.getDataMap());
            return this;
        }

        public ProjectionMask withDashboards() {
            this._dashboardsMask = null;
            this.getDataMap().put("dashboards", 1);
            return this;
        }

        public ProjectionMask withDashboards(Function<EdgeArray.ProjectionMask, EdgeArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._dashboardsMask = nestedMask.apply(this._dashboardsMask == null ? EdgeArray.createMask() : this._dashboardsMask);
            this.getDataMap().put("dashboards", this._dashboardsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("dashboards").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("dashboards").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDashboards(Integer start, Integer count) {
            this._dashboardsMask = null;
            this.getDataMap().put("dashboards", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("dashboards").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("dashboards").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withLastModified(Function<ChangeAuditStamps.ProjectionMask, ChangeAuditStamps.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? ChangeAuditStamps.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }

        public ProjectionMask withDashboardUrl() {
            this.getDataMap().put("dashboardUrl", 1);
            return this;
        }

        public ProjectionMask withAccess() {
            this.getDataMap().put("access", 1);
            return this;
        }

        public ProjectionMask withLastRefreshed() {
            this.getDataMap().put("lastRefreshed", 1);
            return this;
        }
    }
}

