/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common.urn;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import java.net.URISyntaxException;

public class UrnValidator
implements Validator {
    @Override
    public void validate(ValidatorContext context) {
        if (DataSchema.Type.TYPEREF.equals((Object)context.dataElement().getSchema().getType()) && ((NamedDataSchema)context.dataElement().getSchema()).getName().endsWith("Urn")) {
            try {
                Urn.createFromString((String)context.dataElement().getValue());
            }
            catch (URISyntaxException e) {
                context.addResult(new Message(context.dataElement().path(), "\"Provided urn %s\" is invalid", context.dataElement().getValue()));
                context.setHasFix(false);
            }
        }
    }
}

