/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.OperationSourceType;
import com.linkedin.common.OperationType;
import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.timeseries.PartitionSpec;
import com.linkedin.timeseries.TimeWindowSize;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Operation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Operational info for an entity.*/@Aspect={\"name\":\"operation\",\"type\":\"timeseries\"}record Operation includes{namespace com.linkedin.timeseries,record TimeseriesAspectBase{/**The event timestamp field as epoch at UTC in milli seconds.*/timestampMillis:long/**Granularity of the event if applicable*/eventGranularity:optional/**Defines the size of a time window.*/record TimeWindowSize{/**Interval unit such as minute/hour/day etc.*/unit:enum CalendarInterval{SECOND,MINUTE,HOUR,DAY,WEEK,MONTH,QUARTER,YEAR}/**How many units. Defaults to 1.*/multiple:int=1}/**The optional partition specification.*/partitionSpec:optional/**A reference to a specific partition in a dataset.*/record PartitionSpec{/**A unique id / value for the partition for which statistics were collected,\ngenerated by applying the key definition to a given row.*/@TimeseriesField={}partition:string/**Time window of the partition, if we are able to extract it from the partition key.*/timePartition:optional record TimeWindow{/**Start time as epoch at UTC.*/startTimeMillis:long/**The length of the window.*/length:TimeWindowSize}/**Unused!*/@deprecated,type:enum PartitionType{FULL_TABLE,QUERY,PARTITION}=\"PARTITION\"}={\"partition\":\"FULL_TABLE_SNAPSHOT\",\"type\":\"FULL_TABLE\"}/**The optional messageId, if provided serves as a custom user-defined unique identifier for an aspect value.*/messageId:optional string}}{/**Actor who issued this operation.*/@TimeseriesField={}actor:optional@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**Operation type of change.*/@TimeseriesField={}operationType:/**Enum to define the operation type when an entity changes.*/enum OperationType{/**Rows were inserted*/INSERT/**Rows were updated*/UPDATE/**Rows were deleted*/DELETE/**Asset was created*/CREATE/**Asset was altered*/ALTER/**Asset was dropped*/DROP/**Custom asset operation. If this is set, ensure customOperationType is filled out.*/CUSTOM,UNKNOWN}/**A custom type of operation. Required if operationType is CUSTOM.*/@TimeseriesField={}customOperationType:optional string/**How many rows were affected by this operation.*/@TimeseriesField={}numAffectedRows:optional long/**Which other datasets were affected by this operation.*/@TimeseriesFieldCollection.key=\"datasetName\"affectedDatasets:optional array[Urn]/**Source Type*/@TimeseriesField={}sourceType:optional/**The source of an operation*/enum OperationSourceType{/**Provided by a Data Process*/DATA_PROCESS/**Rows were updated*/DATA_PLATFORM}/**Custom properties*/customProperties:optional map[string,string]/**The time at which the operation occurred. Would be better named 'operationTime'*/@Searchable={\"fieldName\":\"lastOperationTime\",\"fieldType\":\"DATETIME\"}@TimeseriesField.fieldType=\"DATETIME\"lastUpdatedTimestamp:long/**Which queries were used in this operation.*/@TimeseriesFieldCollection.key=\"query\"queries:optional array[Urn]}", SchemaFormatType.PDL);
    private Long _timestampMillisField = null;
    private TimeWindowSize _eventGranularityField = null;
    private PartitionSpec _partitionSpecField = null;
    private String _messageIdField = null;
    private Urn _actorField = null;
    private OperationType _operationTypeField = null;
    private String _customOperationTypeField = null;
    private Long _numAffectedRowsField = null;
    private UrnArray _affectedDatasetsField = null;
    private OperationSourceType _sourceTypeField = null;
    private StringMap _customPropertiesField = null;
    private Long _lastUpdatedTimestampField = null;
    private UrnArray _queriesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TimestampMillis = SCHEMA.getField("timestampMillis");
    private static final RecordDataSchema.Field FIELD_EventGranularity = SCHEMA.getField("eventGranularity");
    private static final RecordDataSchema.Field FIELD_PartitionSpec = SCHEMA.getField("partitionSpec");
    private static final PartitionSpec DEFAULT_PartitionSpec;
    private static final RecordDataSchema.Field FIELD_MessageId;
    private static final RecordDataSchema.Field FIELD_Actor;
    private static final RecordDataSchema.Field FIELD_OperationType;
    private static final RecordDataSchema.Field FIELD_CustomOperationType;
    private static final RecordDataSchema.Field FIELD_NumAffectedRows;
    private static final RecordDataSchema.Field FIELD_AffectedDatasets;
    private static final RecordDataSchema.Field FIELD_SourceType;
    private static final RecordDataSchema.Field FIELD_CustomProperties;
    private static final RecordDataSchema.Field FIELD_LastUpdatedTimestamp;
    private static final RecordDataSchema.Field FIELD_Queries;

    public Operation() {
        super(new DataMap(), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public Operation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTimestampMillis() {
        if (this._timestampMillisField != null) {
            return true;
        }
        return this._map.containsKey("timestampMillis");
    }

    public void removeTimestampMillis() {
        this._map.remove("timestampMillis");
    }

    @Nullable
    public Long getTimestampMillis(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimestampMillis();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timestampMillisField != null) {
                    return this._timestampMillisField;
                }
                Object __rawValue = this._map.get("timestampMillis");
                this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._timestampMillisField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getTimestampMillis() {
        if (this._timestampMillisField != null) {
            return this._timestampMillisField;
        }
        Object __rawValue = this._map.get("timestampMillis");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timestampMillis");
        }
        this._timestampMillisField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._timestampMillisField;
    }

    public Operation setTimestampMillis(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimestampMillis(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timestampMillis of com.linkedin.common.Operation");
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimestampMillis();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
                this._timestampMillisField = value;
            }
        }
        return this;
    }

    public Operation setTimestampMillis(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timestampMillis of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public Operation setTimestampMillis(long value) {
        CheckedUtil.putWithoutChecking(this._map, "timestampMillis", DataTemplateUtil.coerceLongInput(value));
        this._timestampMillisField = value;
        return this;
    }

    public boolean hasEventGranularity() {
        if (this._eventGranularityField != null) {
            return true;
        }
        return this._map.containsKey("eventGranularity");
    }

    public void removeEventGranularity() {
        this._map.remove("eventGranularity");
    }

    @Nullable
    public TimeWindowSize getEventGranularity(GetMode mode) {
        return this.getEventGranularity();
    }

    @Nullable
    public TimeWindowSize getEventGranularity() {
        if (this._eventGranularityField != null) {
            return this._eventGranularityField;
        }
        Object __rawValue = this._map.get("eventGranularity");
        this._eventGranularityField = __rawValue == null ? null : new TimeWindowSize(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._eventGranularityField;
    }

    public Operation setEventGranularity(@Nullable TimeWindowSize value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEventGranularity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEventGranularity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
                this._eventGranularityField = value;
            }
        }
        return this;
    }

    public Operation setEventGranularity(@Nonnull TimeWindowSize value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field eventGranularity of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "eventGranularity", value.data());
        this._eventGranularityField = value;
        return this;
    }

    public boolean hasPartitionSpec() {
        if (this._partitionSpecField != null) {
            return true;
        }
        return this._map.containsKey("partitionSpec");
    }

    public void removePartitionSpec() {
        this._map.remove("partitionSpec");
    }

    @Nullable
    public PartitionSpec getPartitionSpec(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPartitionSpec();
            }
            case NULL: {
                if (this._partitionSpecField != null) {
                    return this._partitionSpecField;
                }
                Object __rawValue = this._map.get("partitionSpec");
                this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._partitionSpecField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PartitionSpec getPartitionSpec() {
        if (this._partitionSpecField != null) {
            return this._partitionSpecField;
        }
        Object __rawValue = this._map.get("partitionSpec");
        if (__rawValue == null) {
            return DEFAULT_PartitionSpec;
        }
        this._partitionSpecField = __rawValue == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._partitionSpecField;
    }

    public Operation setPartitionSpec(@Nullable PartitionSpec value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPartitionSpec(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePartitionSpec();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
                this._partitionSpecField = value;
            }
        }
        return this;
    }

    public Operation setPartitionSpec(@Nonnull PartitionSpec value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field partitionSpec of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "partitionSpec", value.data());
        this._partitionSpecField = value;
        return this;
    }

    public boolean hasMessageId() {
        if (this._messageIdField != null) {
            return true;
        }
        return this._map.containsKey("messageId");
    }

    public void removeMessageId() {
        this._map.remove("messageId");
    }

    @Nullable
    public String getMessageId(GetMode mode) {
        return this.getMessageId();
    }

    @Nullable
    public String getMessageId() {
        if (this._messageIdField != null) {
            return this._messageIdField;
        }
        Object __rawValue = this._map.get("messageId");
        this._messageIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._messageIdField;
    }

    public Operation setMessageId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMessageId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMessageId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "messageId", value);
                this._messageIdField = value;
            }
        }
        return this;
    }

    public Operation setMessageId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field messageId of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "messageId", value);
        this._messageIdField = value;
        return this;
    }

    public boolean hasActor() {
        if (this._actorField != null) {
            return true;
        }
        return this._map.containsKey("actor");
    }

    public void removeActor() {
        this._map.remove("actor");
    }

    @Nullable
    public Urn getActor(GetMode mode) {
        return this.getActor();
    }

    @Nullable
    public Urn getActor() {
        if (this._actorField != null) {
            return this._actorField;
        }
        Object __rawValue = this._map.get("actor");
        this._actorField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._actorField;
    }

    public Operation setActor(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActor(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActor();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._actorField = value;
            }
        }
        return this;
    }

    public Operation setActor(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actor of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actor", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._actorField = value;
        return this;
    }

    public boolean hasOperationType() {
        if (this._operationTypeField != null) {
            return true;
        }
        return this._map.containsKey("operationType");
    }

    public void removeOperationType() {
        this._map.remove("operationType");
    }

    @Nullable
    public OperationType getOperationType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperationType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operationTypeField != null) {
                    return this._operationTypeField;
                }
                Object __rawValue = this._map.get("operationType");
                this._operationTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, OperationType.class, OperationType.$UNKNOWN);
                return this._operationTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public OperationType getOperationType() {
        if (this._operationTypeField != null) {
            return this._operationTypeField;
        }
        Object __rawValue = this._map.get("operationType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operationType");
        }
        this._operationTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, OperationType.class, OperationType.$UNKNOWN);
        return this._operationTypeField;
    }

    public Operation setOperationType(@Nullable OperationType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperationType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operationType of com.linkedin.common.Operation");
                }
                CheckedUtil.putWithoutChecking(this._map, "operationType", value.name());
                this._operationTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperationType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operationType", value.name());
                this._operationTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operationType", value.name());
                this._operationTypeField = value;
            }
        }
        return this;
    }

    public Operation setOperationType(@Nonnull OperationType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operationType of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operationType", value.name());
        this._operationTypeField = value;
        return this;
    }

    public boolean hasCustomOperationType() {
        if (this._customOperationTypeField != null) {
            return true;
        }
        return this._map.containsKey("customOperationType");
    }

    public void removeCustomOperationType() {
        this._map.remove("customOperationType");
    }

    @Nullable
    public String getCustomOperationType(GetMode mode) {
        return this.getCustomOperationType();
    }

    @Nullable
    public String getCustomOperationType() {
        if (this._customOperationTypeField != null) {
            return this._customOperationTypeField;
        }
        Object __rawValue = this._map.get("customOperationType");
        this._customOperationTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._customOperationTypeField;
    }

    public Operation setCustomOperationType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomOperationType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomOperationType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customOperationType", value);
                this._customOperationTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customOperationType", value);
                this._customOperationTypeField = value;
            }
        }
        return this;
    }

    public Operation setCustomOperationType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customOperationType of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customOperationType", value);
        this._customOperationTypeField = value;
        return this;
    }

    public boolean hasNumAffectedRows() {
        if (this._numAffectedRowsField != null) {
            return true;
        }
        return this._map.containsKey("numAffectedRows");
    }

    public void removeNumAffectedRows() {
        this._map.remove("numAffectedRows");
    }

    @Nullable
    public Long getNumAffectedRows(GetMode mode) {
        return this.getNumAffectedRows();
    }

    @Nullable
    public Long getNumAffectedRows() {
        if (this._numAffectedRowsField != null) {
            return this._numAffectedRowsField;
        }
        Object __rawValue = this._map.get("numAffectedRows");
        this._numAffectedRowsField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._numAffectedRowsField;
    }

    public Operation setNumAffectedRows(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setNumAffectedRows(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeNumAffectedRows();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "numAffectedRows", DataTemplateUtil.coerceLongInput(value));
                this._numAffectedRowsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "numAffectedRows", DataTemplateUtil.coerceLongInput(value));
                this._numAffectedRowsField = value;
            }
        }
        return this;
    }

    public Operation setNumAffectedRows(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field numAffectedRows of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "numAffectedRows", DataTemplateUtil.coerceLongInput(value));
        this._numAffectedRowsField = value;
        return this;
    }

    public Operation setNumAffectedRows(long value) {
        CheckedUtil.putWithoutChecking(this._map, "numAffectedRows", DataTemplateUtil.coerceLongInput(value));
        this._numAffectedRowsField = value;
        return this;
    }

    public boolean hasAffectedDatasets() {
        if (this._affectedDatasetsField != null) {
            return true;
        }
        return this._map.containsKey("affectedDatasets");
    }

    public void removeAffectedDatasets() {
        this._map.remove("affectedDatasets");
    }

    @Nullable
    public UrnArray getAffectedDatasets(GetMode mode) {
        return this.getAffectedDatasets();
    }

    @Nullable
    public UrnArray getAffectedDatasets() {
        if (this._affectedDatasetsField != null) {
            return this._affectedDatasetsField;
        }
        Object __rawValue = this._map.get("affectedDatasets");
        this._affectedDatasetsField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._affectedDatasetsField;
    }

    public Operation setAffectedDatasets(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAffectedDatasets(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAffectedDatasets();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "affectedDatasets", value.data());
                this._affectedDatasetsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "affectedDatasets", value.data());
                this._affectedDatasetsField = value;
            }
        }
        return this;
    }

    public Operation setAffectedDatasets(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field affectedDatasets of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "affectedDatasets", value.data());
        this._affectedDatasetsField = value;
        return this;
    }

    public boolean hasSourceType() {
        if (this._sourceTypeField != null) {
            return true;
        }
        return this._map.containsKey("sourceType");
    }

    public void removeSourceType() {
        this._map.remove("sourceType");
    }

    @Nullable
    public OperationSourceType getSourceType(GetMode mode) {
        return this.getSourceType();
    }

    @Nullable
    public OperationSourceType getSourceType() {
        if (this._sourceTypeField != null) {
            return this._sourceTypeField;
        }
        Object __rawValue = this._map.get("sourceType");
        this._sourceTypeField = DataTemplateUtil.coerceEnumOutput(__rawValue, OperationSourceType.class, OperationSourceType.$UNKNOWN);
        return this._sourceTypeField;
    }

    public Operation setSourceType(@Nullable OperationSourceType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSourceType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSourceType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
                this._sourceTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
                this._sourceTypeField = value;
            }
        }
        return this;
    }

    public Operation setSourceType(@Nonnull OperationSourceType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field sourceType of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "sourceType", value.name());
        this._sourceTypeField = value;
        return this;
    }

    public boolean hasCustomProperties() {
        if (this._customPropertiesField != null) {
            return true;
        }
        return this._map.containsKey("customProperties");
    }

    public void removeCustomProperties() {
        this._map.remove("customProperties");
    }

    @Nullable
    public StringMap getCustomProperties(GetMode mode) {
        return this.getCustomProperties();
    }

    @Nullable
    public StringMap getCustomProperties() {
        if (this._customPropertiesField != null) {
            return this._customPropertiesField;
        }
        Object __rawValue = this._map.get("customProperties");
        this._customPropertiesField = __rawValue == null ? null : new StringMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._customPropertiesField;
    }

    public Operation setCustomProperties(@Nullable StringMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCustomProperties(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCustomProperties();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
                this._customPropertiesField = value;
            }
        }
        return this;
    }

    public Operation setCustomProperties(@Nonnull StringMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field customProperties of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "customProperties", value.data());
        this._customPropertiesField = value;
        return this;
    }

    public boolean hasLastUpdatedTimestamp() {
        if (this._lastUpdatedTimestampField != null) {
            return true;
        }
        return this._map.containsKey("lastUpdatedTimestamp");
    }

    public void removeLastUpdatedTimestamp() {
        this._map.remove("lastUpdatedTimestamp");
    }

    @Nullable
    public Long getLastUpdatedTimestamp(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getLastUpdatedTimestamp();
            }
            case DEFAULT: 
            case NULL: {
                if (this._lastUpdatedTimestampField != null) {
                    return this._lastUpdatedTimestampField;
                }
                Object __rawValue = this._map.get("lastUpdatedTimestamp");
                this._lastUpdatedTimestampField = DataTemplateUtil.coerceLongOutput(__rawValue);
                return this._lastUpdatedTimestampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Long getLastUpdatedTimestamp() {
        if (this._lastUpdatedTimestampField != null) {
            return this._lastUpdatedTimestampField;
        }
        Object __rawValue = this._map.get("lastUpdatedTimestamp");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("lastUpdatedTimestamp");
        }
        this._lastUpdatedTimestampField = DataTemplateUtil.coerceLongOutput(__rawValue);
        return this._lastUpdatedTimestampField;
    }

    public Operation setLastUpdatedTimestamp(@Nullable Long value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastUpdatedTimestamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field lastUpdatedTimestamp of com.linkedin.common.Operation");
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedTimestampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastUpdatedTimestamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedTimestampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
                this._lastUpdatedTimestampField = value;
            }
        }
        return this;
    }

    public Operation setLastUpdatedTimestamp(@Nonnull Long value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastUpdatedTimestamp of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedTimestampField = value;
        return this;
    }

    public Operation setLastUpdatedTimestamp(long value) {
        CheckedUtil.putWithoutChecking(this._map, "lastUpdatedTimestamp", DataTemplateUtil.coerceLongInput(value));
        this._lastUpdatedTimestampField = value;
        return this;
    }

    public boolean hasQueries() {
        if (this._queriesField != null) {
            return true;
        }
        return this._map.containsKey("queries");
    }

    public void removeQueries() {
        this._map.remove("queries");
    }

    @Nullable
    public UrnArray getQueries(GetMode mode) {
        return this.getQueries();
    }

    @Nullable
    public UrnArray getQueries() {
        if (this._queriesField != null) {
            return this._queriesField;
        }
        Object __rawValue = this._map.get("queries");
        this._queriesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._queriesField;
    }

    public Operation setQueries(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueries(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueries();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queries", value.data());
                this._queriesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queries", value.data());
                this._queriesField = value;
            }
        }
        return this;
    }

    public Operation setQueries(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queries of com.linkedin.common.Operation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queries", value.data());
        this._queriesField = value;
        return this;
    }

    @Override
    public Operation clone() throws CloneNotSupportedException {
        Operation __clone = (Operation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public Operation copy() throws CloneNotSupportedException {
        Operation __copy = (Operation)super.copy();
        __copy._lastUpdatedTimestampField = null;
        __copy._numAffectedRowsField = null;
        __copy._eventGranularityField = null;
        __copy._messageIdField = null;
        __copy._partitionSpecField = null;
        __copy._queriesField = null;
        __copy._actorField = null;
        __copy._timestampMillisField = null;
        __copy._customPropertiesField = null;
        __copy._customOperationTypeField = null;
        __copy._sourceTypeField = null;
        __copy._operationTypeField = null;
        __copy._affectedDatasetsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_MessageId = SCHEMA.getField("messageId");
        FIELD_Actor = SCHEMA.getField("actor");
        FIELD_OperationType = SCHEMA.getField("operationType");
        FIELD_CustomOperationType = SCHEMA.getField("customOperationType");
        FIELD_NumAffectedRows = SCHEMA.getField("numAffectedRows");
        FIELD_AffectedDatasets = SCHEMA.getField("affectedDatasets");
        FIELD_SourceType = SCHEMA.getField("sourceType");
        FIELD_CustomProperties = SCHEMA.getField("customProperties");
        FIELD_LastUpdatedTimestamp = SCHEMA.getField("lastUpdatedTimestamp");
        FIELD_Queries = SCHEMA.getField("queries");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_PartitionSpec = FIELD_PartitionSpec.getDefault() == null ? null : new PartitionSpec(DataTemplateUtil.castOrThrow(FIELD_PartitionSpec.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final Operation __objectRef;

        private ChangeListener(Operation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "lastUpdatedTimestamp": {
                    this.__objectRef._lastUpdatedTimestampField = null;
                    break;
                }
                case "numAffectedRows": {
                    this.__objectRef._numAffectedRowsField = null;
                    break;
                }
                case "eventGranularity": {
                    this.__objectRef._eventGranularityField = null;
                    break;
                }
                case "messageId": {
                    this.__objectRef._messageIdField = null;
                    break;
                }
                case "partitionSpec": {
                    this.__objectRef._partitionSpecField = null;
                    break;
                }
                case "queries": {
                    this.__objectRef._queriesField = null;
                    break;
                }
                case "actor": {
                    this.__objectRef._actorField = null;
                    break;
                }
                case "timestampMillis": {
                    this.__objectRef._timestampMillisField = null;
                    break;
                }
                case "customProperties": {
                    this.__objectRef._customPropertiesField = null;
                    break;
                }
                case "customOperationType": {
                    this.__objectRef._customOperationTypeField = null;
                    break;
                }
                case "sourceType": {
                    this.__objectRef._sourceTypeField = null;
                    break;
                }
                case "operationType": {
                    this.__objectRef._operationTypeField = null;
                    break;
                }
                case "affectedDatasets": {
                    this.__objectRef._affectedDatasetsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec timestampMillis() {
            return new PathSpec(this.getPathComponents(), "timestampMillis");
        }

        public TimeWindowSize.Fields eventGranularity() {
            return new TimeWindowSize.Fields(this.getPathComponents(), "eventGranularity");
        }

        public PartitionSpec.Fields partitionSpec() {
            return new PartitionSpec.Fields(this.getPathComponents(), "partitionSpec");
        }

        public PathSpec messageId() {
            return new PathSpec(this.getPathComponents(), "messageId");
        }

        public PathSpec actor() {
            return new PathSpec(this.getPathComponents(), "actor");
        }

        public PathSpec operationType() {
            return new PathSpec(this.getPathComponents(), "operationType");
        }

        public PathSpec customOperationType() {
            return new PathSpec(this.getPathComponents(), "customOperationType");
        }

        public PathSpec numAffectedRows() {
            return new PathSpec(this.getPathComponents(), "numAffectedRows");
        }

        public PathSpec affectedDatasets() {
            return new PathSpec(this.getPathComponents(), "affectedDatasets");
        }

        public PathSpec affectedDatasets(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "affectedDatasets");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec sourceType() {
            return new PathSpec(this.getPathComponents(), "sourceType");
        }

        public PathSpec customProperties() {
            return new PathSpec(this.getPathComponents(), "customProperties");
        }

        public PathSpec lastUpdatedTimestamp() {
            return new PathSpec(this.getPathComponents(), "lastUpdatedTimestamp");
        }

        public PathSpec queries() {
            return new PathSpec(this.getPathComponents(), "queries");
        }

        public PathSpec queries(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "queries");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private TimeWindowSize.ProjectionMask _eventGranularityMask;
        private PartitionSpec.ProjectionMask _partitionSpecMask;

        ProjectionMask() {
        }

        public ProjectionMask withTimestampMillis() {
            this.getDataMap().put("timestampMillis", 1);
            return this;
        }

        public ProjectionMask withEventGranularity(Function<TimeWindowSize.ProjectionMask, TimeWindowSize.ProjectionMask> nestedMask) {
            this._eventGranularityMask = nestedMask.apply(this._eventGranularityMask == null ? TimeWindowSize.createMask() : this._eventGranularityMask);
            this.getDataMap().put("eventGranularity", this._eventGranularityMask.getDataMap());
            return this;
        }

        public ProjectionMask withEventGranularity() {
            this._eventGranularityMask = null;
            this.getDataMap().put("eventGranularity", 1);
            return this;
        }

        public ProjectionMask withPartitionSpec(Function<PartitionSpec.ProjectionMask, PartitionSpec.ProjectionMask> nestedMask) {
            this._partitionSpecMask = nestedMask.apply(this._partitionSpecMask == null ? PartitionSpec.createMask() : this._partitionSpecMask);
            this.getDataMap().put("partitionSpec", this._partitionSpecMask.getDataMap());
            return this;
        }

        public ProjectionMask withPartitionSpec() {
            this._partitionSpecMask = null;
            this.getDataMap().put("partitionSpec", 1);
            return this;
        }

        public ProjectionMask withMessageId() {
            this.getDataMap().put("messageId", 1);
            return this;
        }

        public ProjectionMask withActor() {
            this.getDataMap().put("actor", 1);
            return this;
        }

        public ProjectionMask withOperationType() {
            this.getDataMap().put("operationType", 1);
            return this;
        }

        public ProjectionMask withCustomOperationType() {
            this.getDataMap().put("customOperationType", 1);
            return this;
        }

        public ProjectionMask withNumAffectedRows() {
            this.getDataMap().put("numAffectedRows", 1);
            return this;
        }

        public ProjectionMask withAffectedDatasets() {
            this.getDataMap().put("affectedDatasets", 1);
            return this;
        }

        public ProjectionMask withAffectedDatasets(Integer start, Integer count) {
            this.getDataMap().put("affectedDatasets", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("affectedDatasets").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("affectedDatasets").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withSourceType() {
            this.getDataMap().put("sourceType", 1);
            return this;
        }

        public ProjectionMask withCustomProperties() {
            this.getDataMap().put("customProperties", 1);
            return this;
        }

        public ProjectionMask withLastUpdatedTimestamp() {
            this.getDataMap().put("lastUpdatedTimestamp", 1);
            return this;
        }

        public ProjectionMask withQueries() {
            this.getDataMap().put("queries", 1);
            return this;
        }

        public ProjectionMask withQueries(Integer start, Integer count) {
            this.getDataMap().put("queries", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("queries").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("queries").put("$count", count);
            }
            return this;
        }
    }
}

