/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormVerificationAssociation
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**An association between a verification and an entity that has been granted\nvia completion of one or more forms of type 'VERIFICATION'.*/record FormVerificationAssociation{/**The urn of the form that granted this verification.*/form:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**An audit stamp capturing who and when verification was applied for this form.*/lastModified:optional/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}", SchemaFormatType.PDL);
    private Urn _formField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Form = SCHEMA.getField("form");
    private static final RecordDataSchema.Field FIELD_LastModified = SCHEMA.getField("lastModified");

    public FormVerificationAssociation() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public FormVerificationAssociation(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasForm() {
        if (this._formField != null) {
            return true;
        }
        return this._map.containsKey("form");
    }

    public void removeForm() {
        this._map.remove("form");
    }

    @Nullable
    public Urn getForm(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getForm();
            }
            case DEFAULT: 
            case NULL: {
                if (this._formField != null) {
                    return this._formField;
                }
                Object __rawValue = this._map.get("form");
                this._formField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._formField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getForm() {
        if (this._formField != null) {
            return this._formField;
        }
        Object __rawValue = this._map.get("form");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("form");
        }
        this._formField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._formField;
    }

    public FormVerificationAssociation setForm(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setForm(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field form of com.linkedin.common.FormVerificationAssociation");
                }
                CheckedUtil.putWithoutChecking(this._map, "form", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._formField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeForm();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "form", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._formField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "form", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._formField = value;
            }
        }
        return this;
    }

    public FormVerificationAssociation setForm(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field form of com.linkedin.common.FormVerificationAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "form", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._formField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public FormVerificationAssociation setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public FormVerificationAssociation setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.common.FormVerificationAssociation to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public FormVerificationAssociation clone() throws CloneNotSupportedException {
        FormVerificationAssociation __clone = (FormVerificationAssociation)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormVerificationAssociation copy() throws CloneNotSupportedException {
        FormVerificationAssociation __copy = (FormVerificationAssociation)super.copy();
        __copy._formField = null;
        __copy._lastModifiedField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormVerificationAssociation __objectRef;

        private ChangeListener(FormVerificationAssociation reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "form": {
                    this.__objectRef._formField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec form() {
            return new PathSpec(this.getPathComponents(), "form");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withForm() {
            this.getDataMap().put("form", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

