/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.query.QueryStatement;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataTransform
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.common/**Information about a transformation. It may be a query,*/record DataTransform{/**The data transform may be defined by a query statement*/queryStatement:optional{namespace com.linkedin.query/**A query statement against one or more data assets.*/record QueryStatement{/**The query text*/value:string/**The language of the Query, e.g. SQL.*/language:enum QueryLanguage{/**A SQL Query*/SQL/**Unknown query language*/UNKNOWN}=\"SQL\"}}}", SchemaFormatType.PDL);
    private QueryStatement _queryStatementField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_QueryStatement = SCHEMA.getField("queryStatement");

    public DataTransform() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public DataTransform(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasQueryStatement() {
        if (this._queryStatementField != null) {
            return true;
        }
        return this._map.containsKey("queryStatement");
    }

    public void removeQueryStatement() {
        this._map.remove("queryStatement");
    }

    @Nullable
    public QueryStatement getQueryStatement(GetMode mode) {
        return this.getQueryStatement();
    }

    @Nullable
    public QueryStatement getQueryStatement() {
        if (this._queryStatementField != null) {
            return this._queryStatementField;
        }
        Object __rawValue = this._map.get("queryStatement");
        this._queryStatementField = __rawValue == null ? null : new QueryStatement(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._queryStatementField;
    }

    public DataTransform setQueryStatement(@Nullable QueryStatement value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQueryStatement(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQueryStatement();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "queryStatement", value.data());
                this._queryStatementField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "queryStatement", value.data());
                this._queryStatementField = value;
            }
        }
        return this;
    }

    public DataTransform setQueryStatement(@Nonnull QueryStatement value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field queryStatement of com.linkedin.common.DataTransform to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "queryStatement", value.data());
        this._queryStatementField = value;
        return this;
    }

    @Override
    public DataTransform clone() throws CloneNotSupportedException {
        DataTransform __clone = (DataTransform)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataTransform copy() throws CloneNotSupportedException {
        DataTransform __copy = (DataTransform)super.copy();
        __copy._queryStatementField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataTransform __objectRef;

        private ChangeListener(DataTransform reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "queryStatement": {
                    this.__objectRef._queryStatementField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public QueryStatement.Fields queryStatement() {
            return new QueryStatement.Fields(this.getPathComponents(), "queryStatement");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private QueryStatement.ProjectionMask _queryStatementMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withQueryStatement(Function<QueryStatement.ProjectionMask, QueryStatement.ProjectionMask> nestedMask) {
            this._queryStatementMask = nestedMask.apply(this._queryStatementMask == null ? QueryStatement.createMask() : this._queryStatementMask);
            this.getDataMap().put("queryStatement", this._queryStatementMask.getDataMap());
            return this;
        }

        public ProjectionMask withQueryStatement() {
            this._queryStatementMask = null;
            this.getDataMap().put("queryStatement", 1);
            return this;
        }
    }
}

