/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.assertion;

import com.linkedin.assertion.FieldAssertionType;
import com.linkedin.assertion.FieldMetricAssertion;
import com.linkedin.assertion.FieldValuesAssertion;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.dataset.DatasetFilter;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldAssertionInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.assertion/**Attributes defining a Field Assertion.\n*/record FieldAssertionInfo{/**The type of the field assertion being monitored.*/@Searchable={}type:enum FieldAssertionType{/**An assertion used to validate the values contained with a field / column given a set of rows.*/FIELD_VALUES/**An assertion used to validate the value of a common field / column metric (e.g. aggregation) such as null count + percentage,\nmin, max, median, and more.*/FIELD_METRIC}/**The entity targeted by this Field check.*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"Asserts\"}@Searchable.fieldType=\"URN\"entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The definition of an assertion that validates individual values of a field / column for a set of rows.\nThis type of assertion verifies that each column value meets a particular requirement.*/fieldValuesAssertion:optional/**Attributes defining a field values assertion, which asserts that the values for a field / column\nof a dataset / table matches a set of expectations.\n\nIn other words, this type of assertion acts as a semantic constraint applied to fields for a specific column.\n\nTODO: We should display the \"failed row count\" to the user if the column fails the verification rules.\nTODO: Determine whether we need an \"operator\" that can be applied to the field.*/record FieldValuesAssertion{/**The field under evaluation*/@Searchable.`/path`.fieldName=\"fieldPath\"field:{namespace com.linkedin.schema/**Lightweight spec used for referencing a particular schema field.\n*/record SchemaFieldSpec{/**The field path*/path:string/**The DataHub standard schema field type.*/type:string/**The native field type*/nativeType:string}}/**An optional transform to apply to field values\nbefore evaluating the operator.\n\nIf none is applied, the field value will be compared as is.*/transform:optional/**Definition of a transform applied to the values of a column / field.\nNote that the applicability of a field transform ultimately depends on the native type\nof the field / column.\n\nModel has single field to permit extension.*/record FieldTransform{/**The type of the field transform, e.g. the transformation\nfunction / operator to apply.*/type:enum FieldTransformType{/**Obtain the length of a string field / column (applicable to string types)*/LENGTH}}/**The predicate to evaluate against a single value of the field.\nDepending on the operator, parameters may be required in order to successfully\nevaluate the assertion against the field value.*/operator:/**A boolean operator that is applied on the input to an assertion, after an aggregation function has been applied.*/enum AssertionStdOperator{/**Value being asserted is between min_value and max_value.  Requires 'minValue' & 'maxValue' parameters.*/BETWEEN/**Value being asserted is less than a max value. Requires 'value' parameter.*/LESS_THAN/**Value being asserted is less than or equal to some value. Requires 'value' parameter.*/LESS_THAN_OR_EQUAL_TO/**Value being asserted is greater than some value. Requires 'value' parameter.*/GREATER_THAN/**Value being asserted is greater than or equal to some value. Requires 'value' parameter.*/GREATER_THAN_OR_EQUAL_TO/**Value being asserted is equal to value. Requires 'value' parameter.*/EQUAL_TO/**Value being asserted is not equal to value. Requires 'value' parameter.*/NOT_EQUAL_TO/**Value being asserted is null. Requires no parameters.*/NULL/**Value being asserted is not null. Requires no parameters.*/NOT_NULL/**Value being asserted contains value. Requires 'value' parameter.*/CONTAIN/**Value being asserted ends with value. Requires 'value' parameter.*/END_WITH/**Value being asserted starts with value. Requires 'value' parameter.*/START_WITH/**Value being asserted matches the regex value. Requires 'value' parameter.*/REGEX_MATCH/**Value being asserted is one of the array values. Requires 'value' parameter.*/IN/**Value being asserted is not in one of the array values. Requires 'value' parameter.*/NOT_IN/**Value being asserted is true. Requires no parameters.*/IS_TRUE/**Value being asserted is false. Requires no parameters.*/IS_FALSE/**Other*/_NATIVE_}/**Standard parameters required for the assertion. e.g. min_value, max_value, value, columns*/parameters:optional/**Parameters for AssertionStdOperators.*/record AssertionStdParameters{/**The value parameter of an assertion*/value:optional/**Single parameter for AssertionStdOperators.*/record AssertionStdParameter{/**The parameter value*/value:string/**The type of the parameter*/type:enum AssertionStdParameterType{/**A string value*/STRING/**A numeric value*/NUMBER/**A list of values. When used, value should be formatted as a serialized JSON array.*/LIST/**A set of values. When used, value should be formatted as a serialized JSON array.*/SET/**A value of unknown type*/UNKNOWN}}/**The maxValue parameter of an assertion*/maxValue:optional AssertionStdParameter/**The minValue parameter of an assertion*/minValue:optional AssertionStdParameter}/**Additional customization about when the assertion\nshould be officially considered failing.*/failThreshold:record FieldValuesFailThreshold{/**The type of failure threshold. Either based on the number\nof column values (rows) that fail the expectations, or the percentage\nof the total rows under consideration.*/type:enum FieldValuesFailThresholdType{COUNT,PERCENTAGE}=\"COUNT\"/**By default this is 0, meaning that ALL column values (i.e. rows) must\nmeet the defined expectations.*/value:long=0}/**Whether to ignore or allow nulls when running the values assertion. (i.e.\nconsider only non-null values) using operators OTHER than the IS_NULL operator.\n\nDefaults to true, allowing null values.*/excludeNulls:boolean=true}/**The definition of an assertion that validates a common metric obtained about a field / column for a set of rows.\nThis type of assertion verifies that the value of a high-level metric obtained by aggregating over a column meets\nexpectations*/fieldMetricAssertion:optional/**Attributes defining a field metric assertion, which asserts an expectation against\na common metric derived from the set of field / column values, for example:\nmax, min, median, null count, null percentage, unique count, unique percentage, and more.*/record FieldMetricAssertion{/**The field under evaluation*/@Searchable.`/path`.fieldName=\"fieldPath\"field:com.linkedin.schema.SchemaFieldSpec/**The specific metric to assert against. This is the value that\nwill be obtained by applying a standard operation, such as an aggregation,\nto the selected field.*/metric:/**A standard metric that can be derived from the set of values\nfor a specific field / column of a dataset / table.*/enum FieldMetricType{/**The number of unique values found in the column value set*/UNIQUE_COUNT/**The percentage of unique values to total rows for the dataset*/UNIQUE_PERCENTAGE/**The number of null values found in the column value set*/NULL_COUNT/**The percentage of null values to total rows for the dataset*/NULL_PERCENTAGE/**The minimum value in the column set (applies to numeric columns)*/MIN/**The maximum value in the column set (applies to numeric columns)*/MAX/**The mean length found in the column set (applies to numeric columns)*/MEAN/**The median length found in the column set (applies to numeric columns)*/MEDIAN/**The stddev length found in the column set (applies to numeric columns)*/STDDEV/**The number of negative values found in the value set (applies to numeric columns)*/NEGATIVE_COUNT/**The percentage of negative values to total rows for the dataset (applies to numeric columns)*/NEGATIVE_PERCENTAGE/**The number of zero values found in the value set (applies to numeric columns)*/ZERO_COUNT/**The percentage of zero values to total rows for the dataset (applies to numeric columns)*/ZERO_PERCENTAGE/**The minimum length found in the column set (applies to string columns)*/MIN_LENGTH/**The maximum length found in the column set (applies to string columns)*/MAX_LENGTH/**The number of empty string values found in the value set (applies to string columns).\nNote: This is a completely different metric different from NULL_COUNT!*/EMPTY_COUNT/**The percentage of empty string values to total rows for the dataset (applies to string columns)\nNote: This is a completely different metric different from NULL_PERCENTAGE!*/EMPTY_PERCENTAGE}/**The predicate to evaluate against the metric for the field / column.\nDepending on the operator, parameters may be required in order to successfully\nevaluate the assertion against the metric value.*/operator:AssertionStdOperator/**Standard parameters required for the assertion. e.g. min_value, max_value, value, columns*/parameters:optional AssertionStdParameters}/**A definition of the specific filters that should be applied, when performing monitoring.\nIf not provided, there is no filter, and the full table is under consideration.\nIf using DataHub Dataset Profiles as the assertion source type, the value of this field will be ignored.*/filter:optional{namespace com.linkedin.dataset/**A definition of filters that should be used when\nquerying an external Dataset or Table.\n\nNote that this models should NOT be used for working with\nsearch / filter on DataHub Platform itself.*/record DatasetFilter{/**How the partition will be represented in this model.\n\nIn the future, we'll likely add support for more structured\npredicates.*/type:enum DatasetFilterType{/**The partition is represented as a an opaque, raw SQL\nclause.*/SQL}/**The raw where clause string which will be used for monitoring.\nRequired if the type is SQL.*/sql:optional string}}}", SchemaFormatType.PDL);
    private FieldAssertionType _typeField = null;
    private Urn _entityField = null;
    private FieldValuesAssertion _fieldValuesAssertionField = null;
    private FieldMetricAssertion _fieldMetricAssertionField = null;
    private DatasetFilter _filterField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_FieldValuesAssertion = SCHEMA.getField("fieldValuesAssertion");
    private static final RecordDataSchema.Field FIELD_FieldMetricAssertion = SCHEMA.getField("fieldMetricAssertion");
    private static final RecordDataSchema.Field FIELD_Filter = SCHEMA.getField("filter");

    public FieldAssertionInfo() {
        super(new DataMap(7, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public FieldAssertionInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FieldAssertionType getType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldAssertionType.class, FieldAssertionType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FieldAssertionType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("type");
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FieldAssertionType.class, FieldAssertionType.$UNKNOWN);
        return this._typeField;
    }

    public FieldAssertionInfo setType(@Nullable FieldAssertionType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.assertion.FieldAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FieldAssertionInfo setType(@Nonnull FieldAssertionType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.assertion.FieldAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public FieldAssertionInfo setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.assertion.FieldAssertionInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public FieldAssertionInfo setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.assertion.FieldAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasFieldValuesAssertion() {
        if (this._fieldValuesAssertionField != null) {
            return true;
        }
        return this._map.containsKey("fieldValuesAssertion");
    }

    public void removeFieldValuesAssertion() {
        this._map.remove("fieldValuesAssertion");
    }

    @Nullable
    public FieldValuesAssertion getFieldValuesAssertion(GetMode mode) {
        return this.getFieldValuesAssertion();
    }

    @Nullable
    public FieldValuesAssertion getFieldValuesAssertion() {
        if (this._fieldValuesAssertionField != null) {
            return this._fieldValuesAssertionField;
        }
        Object __rawValue = this._map.get("fieldValuesAssertion");
        this._fieldValuesAssertionField = __rawValue == null ? null : new FieldValuesAssertion(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fieldValuesAssertionField;
    }

    public FieldAssertionInfo setFieldValuesAssertion(@Nullable FieldValuesAssertion value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldValuesAssertion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldValuesAssertion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldValuesAssertion", value.data());
                this._fieldValuesAssertionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldValuesAssertion", value.data());
                this._fieldValuesAssertionField = value;
            }
        }
        return this;
    }

    public FieldAssertionInfo setFieldValuesAssertion(@Nonnull FieldValuesAssertion value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldValuesAssertion of com.linkedin.assertion.FieldAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldValuesAssertion", value.data());
        this._fieldValuesAssertionField = value;
        return this;
    }

    public boolean hasFieldMetricAssertion() {
        if (this._fieldMetricAssertionField != null) {
            return true;
        }
        return this._map.containsKey("fieldMetricAssertion");
    }

    public void removeFieldMetricAssertion() {
        this._map.remove("fieldMetricAssertion");
    }

    @Nullable
    public FieldMetricAssertion getFieldMetricAssertion(GetMode mode) {
        return this.getFieldMetricAssertion();
    }

    @Nullable
    public FieldMetricAssertion getFieldMetricAssertion() {
        if (this._fieldMetricAssertionField != null) {
            return this._fieldMetricAssertionField;
        }
        Object __rawValue = this._map.get("fieldMetricAssertion");
        this._fieldMetricAssertionField = __rawValue == null ? null : new FieldMetricAssertion(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._fieldMetricAssertionField;
    }

    public FieldAssertionInfo setFieldMetricAssertion(@Nullable FieldMetricAssertion value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFieldMetricAssertion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFieldMetricAssertion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "fieldMetricAssertion", value.data());
                this._fieldMetricAssertionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "fieldMetricAssertion", value.data());
                this._fieldMetricAssertionField = value;
            }
        }
        return this;
    }

    public FieldAssertionInfo setFieldMetricAssertion(@Nonnull FieldMetricAssertion value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field fieldMetricAssertion of com.linkedin.assertion.FieldAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "fieldMetricAssertion", value.data());
        this._fieldMetricAssertionField = value;
        return this;
    }

    public boolean hasFilter() {
        if (this._filterField != null) {
            return true;
        }
        return this._map.containsKey("filter");
    }

    public void removeFilter() {
        this._map.remove("filter");
    }

    @Nullable
    public DatasetFilter getFilter(GetMode mode) {
        return this.getFilter();
    }

    @Nullable
    public DatasetFilter getFilter() {
        if (this._filterField != null) {
            return this._filterField;
        }
        Object __rawValue = this._map.get("filter");
        this._filterField = __rawValue == null ? null : new DatasetFilter(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._filterField;
    }

    public FieldAssertionInfo setFilter(@Nullable DatasetFilter value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setFilter(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeFilter();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
                this._filterField = value;
            }
        }
        return this;
    }

    public FieldAssertionInfo setFilter(@Nonnull DatasetFilter value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field filter of com.linkedin.assertion.FieldAssertionInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "filter", value.data());
        this._filterField = value;
        return this;
    }

    @Override
    public FieldAssertionInfo clone() throws CloneNotSupportedException {
        FieldAssertionInfo __clone = (FieldAssertionInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FieldAssertionInfo copy() throws CloneNotSupportedException {
        FieldAssertionInfo __copy = (FieldAssertionInfo)super.copy();
        __copy._fieldMetricAssertionField = null;
        __copy._filterField = null;
        __copy._typeField = null;
        __copy._entityField = null;
        __copy._fieldValuesAssertionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FieldAssertionInfo __objectRef;

        private ChangeListener(FieldAssertionInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "fieldMetricAssertion": {
                    this.__objectRef._fieldMetricAssertionField = null;
                    break;
                }
                case "filter": {
                    this.__objectRef._filterField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                    break;
                }
                case "fieldValuesAssertion": {
                    this.__objectRef._fieldValuesAssertionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public FieldValuesAssertion.Fields fieldValuesAssertion() {
            return new FieldValuesAssertion.Fields(this.getPathComponents(), "fieldValuesAssertion");
        }

        public FieldMetricAssertion.Fields fieldMetricAssertion() {
            return new FieldMetricAssertion.Fields(this.getPathComponents(), "fieldMetricAssertion");
        }

        public DatasetFilter.Fields filter() {
            return new DatasetFilter.Fields(this.getPathComponents(), "filter");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FieldValuesAssertion.ProjectionMask _fieldValuesAssertionMask;
        private FieldMetricAssertion.ProjectionMask _fieldMetricAssertionMask;
        private DatasetFilter.ProjectionMask _filterMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withFieldValuesAssertion(Function<FieldValuesAssertion.ProjectionMask, FieldValuesAssertion.ProjectionMask> nestedMask) {
            this._fieldValuesAssertionMask = nestedMask.apply(this._fieldValuesAssertionMask == null ? FieldValuesAssertion.createMask() : this._fieldValuesAssertionMask);
            this.getDataMap().put("fieldValuesAssertion", this._fieldValuesAssertionMask.getDataMap());
            return this;
        }

        public ProjectionMask withFieldValuesAssertion() {
            this._fieldValuesAssertionMask = null;
            this.getDataMap().put("fieldValuesAssertion", 1);
            return this;
        }

        public ProjectionMask withFieldMetricAssertion(Function<FieldMetricAssertion.ProjectionMask, FieldMetricAssertion.ProjectionMask> nestedMask) {
            this._fieldMetricAssertionMask = nestedMask.apply(this._fieldMetricAssertionMask == null ? FieldMetricAssertion.createMask() : this._fieldMetricAssertionMask);
            this.getDataMap().put("fieldMetricAssertion", this._fieldMetricAssertionMask.getDataMap());
            return this;
        }

        public ProjectionMask withFieldMetricAssertion() {
            this._fieldMetricAssertionMask = null;
            this.getDataMap().put("fieldMetricAssertion", 1);
            return this;
        }

        public ProjectionMask withFilter(Function<DatasetFilter.ProjectionMask, DatasetFilter.ProjectionMask> nestedMask) {
            this._filterMask = nestedMask.apply(this._filterMask == null ? DatasetFilter.createMask() : this._filterMask);
            this.getDataMap().put("filter", this._filterMask.getDataMap());
            return this;
        }

        public ProjectionMask withFilter() {
            this._filterMask = null;
            this.getDataMap().put("filter", 1);
            return this;
        }
    }
}

