/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util;

import com.linkedin.data.Data;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.DataMapBuilder;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.template.DataTemplateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataComplexUtil {
    private DataComplexUtil() {
    }

    public static DataMap convertMap(Map<String, ?> input, boolean stringify) {
        return DataComplexUtil.convertMap(input, false, stringify);
    }

    public static DataMap convertMap(Map<String, ?> input) {
        return DataComplexUtil.convertMap(input, false, false);
    }

    public static DataMap convertMapRetainingNulls(Map<String, ?> input) {
        return DataComplexUtil.convertMap(input, true, false);
    }

    public static DataList convertList(List<?> input) {
        return DataComplexUtil.convertList(input, false, false);
    }

    public static DataList convertListRetainingNulls(List<?> input) {
        return DataComplexUtil.convertList(input, true, false);
    }

    public static Object convertObject(Object dataObject) {
        return DataComplexUtil.convertObject(dataObject, false, false);
    }

    public static Object convertObject(Object value, boolean retainNulls, boolean stringify) {
        if (value instanceof DataMap || value instanceof DataList) {
            return value;
        }
        if (value instanceof Map) {
            return DataComplexUtil.convertMap((Map)value, retainNulls, stringify);
        }
        if (value instanceof List) {
            return DataComplexUtil.convertList((List)value, retainNulls, stringify);
        }
        return stringify ? DataTemplateUtil.stringify(value) : value;
    }

    public static Object convertToJavaObject(Object value, boolean retainNulls) {
        if (value instanceof HashMap || value instanceof ArrayList) {
            return value;
        }
        if (value instanceof Map) {
            return DataComplexUtil.convertToJavaMap((Map)value, retainNulls);
        }
        if (value instanceof List) {
            return DataComplexUtil.convertToJavaList((List)value, retainNulls);
        }
        if (value == Data.NULL) {
            return null;
        }
        return value;
    }

    private static DataMap convertMap(Map<String, ?> input, boolean retainNulls, boolean stringify) {
        if (input instanceof DataMap) {
            return (DataMap)input;
        }
        DataMap result = new DataMap(DataMapBuilder.getOptimumHashMapCapacityFromSize(input.size()));
        input.forEach((key, value) -> {
            Object convertedValue = DataComplexUtil.convertObject(value, retainNulls, stringify);
            if (convertedValue != null) {
                CheckedUtil.putWithoutCheckingOrChangeNotification(result, key, convertedValue);
            } else if (retainNulls) {
                CheckedUtil.putWithoutCheckingOrChangeNotification(result, key, Data.NULL);
            }
        });
        return result;
    }

    private static HashMap<String, Object> convertToJavaMap(Map input, boolean retainNulls) {
        if (input instanceof HashMap) {
            return (HashMap)input;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(input.size());
        input.forEach((key, value) -> {
            Object convertedValue = DataComplexUtil.convertToJavaObject(value, retainNulls);
            if (convertedValue != null) {
                result.put((String)key, convertedValue);
            } else if (retainNulls) {
                result.put((String)key, null);
            }
        });
        return result;
    }

    private static DataList convertList(List<?> input, boolean retainNulls, boolean stringify) {
        if (input instanceof DataList) {
            return (DataList)input;
        }
        DataList result = new DataList(input.size());
        input.forEach(entry -> {
            Object convertedEntry = DataComplexUtil.convertObject(entry, retainNulls, stringify);
            if (convertedEntry != null) {
                CheckedUtil.addWithoutChecking(result, convertedEntry);
            } else if (retainNulls) {
                CheckedUtil.addWithoutChecking(result, Data.NULL);
            }
        });
        return result;
    }

    private static ArrayList<Object> convertToJavaList(List input, boolean retainNulls) {
        if (input instanceof ArrayList) {
            return (ArrayList)input;
        }
        ArrayList<Object> result = new ArrayList<Object>(input.size());
        input.forEach(entry -> {
            Object convertedEntry = DataComplexUtil.convertToJavaObject(entry, retainNulls);
            if (convertedEntry != null) {
                result.add(convertedEntry);
            } else if (retainNulls) {
                result.add(null);
            }
        });
        return result;
    }
}

