/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.common.AuditStamp;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructuredPropertySettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.structured/**Settings specific to a structured property entity*/@Aspect.name=\"structuredPropertySettings\"record StructuredPropertySettings{/**Whether or not this asset should be hidden in the main application*/@Searchable.fieldType=\"BOOLEAN\"isHidden:boolean=false/**Whether or not this asset should be displayed as a search filter*/@Searchable.fieldType=\"BOOLEAN\"showInSearchFilters:boolean=false/**Whether or not this asset should be displayed in the asset sidebar*/@Searchable.fieldType=\"BOOLEAN\"showInAssetSummary:boolean=false/**Whether or not this asset should be displayed as an asset badge on other\nasset's headers*/@Searchable.fieldType=\"BOOLEAN\"showAsAssetBadge:boolean=false/**Whether or not this asset should be displayed as a column in the schema field table\nin a Dataset's \"Columns\" tab.*/@Searchable.fieldType=\"BOOLEAN\"showInColumnsTable:boolean=false/**Last Modified Audit stamp*/@Searchable.`/time`={\"fieldName\":\"lastModifiedSettings\",\"fieldType\":\"DATETIME\"}lastModified:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}}", SchemaFormatType.PDL);
    private Boolean _isHiddenField = null;
    private Boolean _showInSearchFiltersField = null;
    private Boolean _showInAssetSummaryField = null;
    private Boolean _showAsAssetBadgeField = null;
    private Boolean _showInColumnsTableField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_IsHidden = SCHEMA.getField("isHidden");
    private static final Boolean DEFAULT_IsHidden;
    private static final RecordDataSchema.Field FIELD_ShowInSearchFilters;
    private static final Boolean DEFAULT_ShowInSearchFilters;
    private static final RecordDataSchema.Field FIELD_ShowInAssetSummary;
    private static final Boolean DEFAULT_ShowInAssetSummary;
    private static final RecordDataSchema.Field FIELD_ShowAsAssetBadge;
    private static final Boolean DEFAULT_ShowAsAssetBadge;
    private static final RecordDataSchema.Field FIELD_ShowInColumnsTable;
    private static final Boolean DEFAULT_ShowInColumnsTable;
    private static final RecordDataSchema.Field FIELD_LastModified;

    public StructuredPropertySettings() {
        super(new DataMap(8, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public StructuredPropertySettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasIsHidden() {
        if (this._isHiddenField != null) {
            return true;
        }
        return this._map.containsKey("isHidden");
    }

    public void removeIsHidden() {
        this._map.remove("isHidden");
    }

    @Nullable
    public Boolean isIsHidden(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isIsHidden();
            }
            case NULL: {
                if (this._isHiddenField != null) {
                    return this._isHiddenField;
                }
                Object __rawValue = this._map.get("isHidden");
                this._isHiddenField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._isHiddenField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isIsHidden() {
        if (this._isHiddenField != null) {
            return this._isHiddenField;
        }
        Object __rawValue = this._map.get("isHidden");
        if (__rawValue == null) {
            return DEFAULT_IsHidden;
        }
        this._isHiddenField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._isHiddenField;
    }

    public StructuredPropertySettings setIsHidden(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setIsHidden(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field isHidden of com.linkedin.structured.StructuredPropertySettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "isHidden", value);
                this._isHiddenField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeIsHidden();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "isHidden", value);
                this._isHiddenField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "isHidden", value);
                this._isHiddenField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setIsHidden(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field isHidden of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "isHidden", value);
        this._isHiddenField = value;
        return this;
    }

    public StructuredPropertySettings setIsHidden(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "isHidden", value);
        this._isHiddenField = value;
        return this;
    }

    public boolean hasShowInSearchFilters() {
        if (this._showInSearchFiltersField != null) {
            return true;
        }
        return this._map.containsKey("showInSearchFilters");
    }

    public void removeShowInSearchFilters() {
        this._map.remove("showInSearchFilters");
    }

    @Nullable
    public Boolean isShowInSearchFilters(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isShowInSearchFilters();
            }
            case NULL: {
                if (this._showInSearchFiltersField != null) {
                    return this._showInSearchFiltersField;
                }
                Object __rawValue = this._map.get("showInSearchFilters");
                this._showInSearchFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._showInSearchFiltersField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isShowInSearchFilters() {
        if (this._showInSearchFiltersField != null) {
            return this._showInSearchFiltersField;
        }
        Object __rawValue = this._map.get("showInSearchFilters");
        if (__rawValue == null) {
            return DEFAULT_ShowInSearchFilters;
        }
        this._showInSearchFiltersField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showInSearchFiltersField;
    }

    public StructuredPropertySettings setShowInSearchFilters(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowInSearchFilters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field showInSearchFilters of com.linkedin.structured.StructuredPropertySettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "showInSearchFilters", value);
                this._showInSearchFiltersField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowInSearchFilters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showInSearchFilters", value);
                this._showInSearchFiltersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showInSearchFilters", value);
                this._showInSearchFiltersField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setShowInSearchFilters(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showInSearchFilters of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showInSearchFilters", value);
        this._showInSearchFiltersField = value;
        return this;
    }

    public StructuredPropertySettings setShowInSearchFilters(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showInSearchFilters", value);
        this._showInSearchFiltersField = value;
        return this;
    }

    public boolean hasShowInAssetSummary() {
        if (this._showInAssetSummaryField != null) {
            return true;
        }
        return this._map.containsKey("showInAssetSummary");
    }

    public void removeShowInAssetSummary() {
        this._map.remove("showInAssetSummary");
    }

    @Nullable
    public Boolean isShowInAssetSummary(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isShowInAssetSummary();
            }
            case NULL: {
                if (this._showInAssetSummaryField != null) {
                    return this._showInAssetSummaryField;
                }
                Object __rawValue = this._map.get("showInAssetSummary");
                this._showInAssetSummaryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._showInAssetSummaryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isShowInAssetSummary() {
        if (this._showInAssetSummaryField != null) {
            return this._showInAssetSummaryField;
        }
        Object __rawValue = this._map.get("showInAssetSummary");
        if (__rawValue == null) {
            return DEFAULT_ShowInAssetSummary;
        }
        this._showInAssetSummaryField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showInAssetSummaryField;
    }

    public StructuredPropertySettings setShowInAssetSummary(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowInAssetSummary(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field showInAssetSummary of com.linkedin.structured.StructuredPropertySettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "showInAssetSummary", value);
                this._showInAssetSummaryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowInAssetSummary();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showInAssetSummary", value);
                this._showInAssetSummaryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showInAssetSummary", value);
                this._showInAssetSummaryField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setShowInAssetSummary(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showInAssetSummary of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showInAssetSummary", value);
        this._showInAssetSummaryField = value;
        return this;
    }

    public StructuredPropertySettings setShowInAssetSummary(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showInAssetSummary", value);
        this._showInAssetSummaryField = value;
        return this;
    }

    public boolean hasShowAsAssetBadge() {
        if (this._showAsAssetBadgeField != null) {
            return true;
        }
        return this._map.containsKey("showAsAssetBadge");
    }

    public void removeShowAsAssetBadge() {
        this._map.remove("showAsAssetBadge");
    }

    @Nullable
    public Boolean isShowAsAssetBadge(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isShowAsAssetBadge();
            }
            case NULL: {
                if (this._showAsAssetBadgeField != null) {
                    return this._showAsAssetBadgeField;
                }
                Object __rawValue = this._map.get("showAsAssetBadge");
                this._showAsAssetBadgeField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._showAsAssetBadgeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isShowAsAssetBadge() {
        if (this._showAsAssetBadgeField != null) {
            return this._showAsAssetBadgeField;
        }
        Object __rawValue = this._map.get("showAsAssetBadge");
        if (__rawValue == null) {
            return DEFAULT_ShowAsAssetBadge;
        }
        this._showAsAssetBadgeField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showAsAssetBadgeField;
    }

    public StructuredPropertySettings setShowAsAssetBadge(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowAsAssetBadge(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field showAsAssetBadge of com.linkedin.structured.StructuredPropertySettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "showAsAssetBadge", value);
                this._showAsAssetBadgeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowAsAssetBadge();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showAsAssetBadge", value);
                this._showAsAssetBadgeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showAsAssetBadge", value);
                this._showAsAssetBadgeField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setShowAsAssetBadge(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showAsAssetBadge of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showAsAssetBadge", value);
        this._showAsAssetBadgeField = value;
        return this;
    }

    public StructuredPropertySettings setShowAsAssetBadge(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showAsAssetBadge", value);
        this._showAsAssetBadgeField = value;
        return this;
    }

    public boolean hasShowInColumnsTable() {
        if (this._showInColumnsTableField != null) {
            return true;
        }
        return this._map.containsKey("showInColumnsTable");
    }

    public void removeShowInColumnsTable() {
        this._map.remove("showInColumnsTable");
    }

    @Nullable
    public Boolean isShowInColumnsTable(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isShowInColumnsTable();
            }
            case NULL: {
                if (this._showInColumnsTableField != null) {
                    return this._showInColumnsTableField;
                }
                Object __rawValue = this._map.get("showInColumnsTable");
                this._showInColumnsTableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._showInColumnsTableField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isShowInColumnsTable() {
        if (this._showInColumnsTableField != null) {
            return this._showInColumnsTableField;
        }
        Object __rawValue = this._map.get("showInColumnsTable");
        if (__rawValue == null) {
            return DEFAULT_ShowInColumnsTable;
        }
        this._showInColumnsTableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._showInColumnsTableField;
    }

    public StructuredPropertySettings setShowInColumnsTable(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setShowInColumnsTable(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field showInColumnsTable of com.linkedin.structured.StructuredPropertySettings");
                }
                CheckedUtil.putWithoutChecking(this._map, "showInColumnsTable", value);
                this._showInColumnsTableField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeShowInColumnsTable();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "showInColumnsTable", value);
                this._showInColumnsTableField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "showInColumnsTable", value);
                this._showInColumnsTableField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setShowInColumnsTable(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field showInColumnsTable of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "showInColumnsTable", value);
        this._showInColumnsTableField = value;
        return this;
    }

    public StructuredPropertySettings setShowInColumnsTable(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "showInColumnsTable", value);
        this._showInColumnsTableField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public StructuredPropertySettings setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public StructuredPropertySettings setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.structured.StructuredPropertySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public StructuredPropertySettings clone() throws CloneNotSupportedException {
        StructuredPropertySettings __clone = (StructuredPropertySettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public StructuredPropertySettings copy() throws CloneNotSupportedException {
        StructuredPropertySettings __copy = (StructuredPropertySettings)super.copy();
        __copy._showInColumnsTableField = null;
        __copy._showAsAssetBadgeField = null;
        __copy._showInAssetSummaryField = null;
        __copy._showInSearchFiltersField = null;
        __copy._lastModifiedField = null;
        __copy._isHiddenField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_ShowInSearchFilters = SCHEMA.getField("showInSearchFilters");
        FIELD_ShowInAssetSummary = SCHEMA.getField("showInAssetSummary");
        FIELD_ShowAsAssetBadge = SCHEMA.getField("showAsAssetBadge");
        FIELD_ShowInColumnsTable = SCHEMA.getField("showInColumnsTable");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        DEFAULT_IsHidden = DataTemplateUtil.coerceBooleanOutput(FIELD_IsHidden.getDefault());
        DEFAULT_ShowInSearchFilters = DataTemplateUtil.coerceBooleanOutput(FIELD_ShowInSearchFilters.getDefault());
        DEFAULT_ShowInAssetSummary = DataTemplateUtil.coerceBooleanOutput(FIELD_ShowInAssetSummary.getDefault());
        DEFAULT_ShowAsAssetBadge = DataTemplateUtil.coerceBooleanOutput(FIELD_ShowAsAssetBadge.getDefault());
        DEFAULT_ShowInColumnsTable = DataTemplateUtil.coerceBooleanOutput(FIELD_ShowInColumnsTable.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final StructuredPropertySettings __objectRef;

        private ChangeListener(StructuredPropertySettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "showInColumnsTable": {
                    this.__objectRef._showInColumnsTableField = null;
                    break;
                }
                case "showAsAssetBadge": {
                    this.__objectRef._showAsAssetBadgeField = null;
                    break;
                }
                case "showInAssetSummary": {
                    this.__objectRef._showInAssetSummaryField = null;
                    break;
                }
                case "showInSearchFilters": {
                    this.__objectRef._showInSearchFiltersField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "isHidden": {
                    this.__objectRef._isHiddenField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec isHidden() {
            return new PathSpec(this.getPathComponents(), "isHidden");
        }

        public PathSpec showInSearchFilters() {
            return new PathSpec(this.getPathComponents(), "showInSearchFilters");
        }

        public PathSpec showInAssetSummary() {
            return new PathSpec(this.getPathComponents(), "showInAssetSummary");
        }

        public PathSpec showAsAssetBadge() {
            return new PathSpec(this.getPathComponents(), "showAsAssetBadge");
        }

        public PathSpec showInColumnsTable() {
            return new PathSpec(this.getPathComponents(), "showInColumnsTable");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
            super(8);
        }

        public ProjectionMask withIsHidden() {
            this.getDataMap().put("isHidden", 1);
            return this;
        }

        public ProjectionMask withShowInSearchFilters() {
            this.getDataMap().put("showInSearchFilters", 1);
            return this;
        }

        public ProjectionMask withShowInAssetSummary() {
            this.getDataMap().put("showInAssetSummary", 1);
            return this;
        }

        public ProjectionMask withShowAsAssetBadge() {
            this.getDataMap().put("showAsAssetBadge", 1);
            return this;
        }

        public ProjectionMask withShowInColumnsTable() {
            this.getDataMap().put("showInColumnsTable", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

