/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.structured;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArrayMap;
import com.linkedin.datahub.DataHubSearchConfig;
import com.linkedin.structured.PropertyCardinality;
import com.linkedin.structured.PropertyValueArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StructuredPropertyDefinition
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.structured@Aspect.name=\"propertyDefinition\"record StructuredPropertyDefinition{/**The fully qualified name of the property. e.g. io.acryl.datahub.myProperty*/@Searchable={}qualifiedName:string/**The display name of the property. This is the name that will be shown in the UI and can be used to look up the property id.*/@Searchable={}displayName:optional string/**The value type of the property. Must be a dataType.\ne.g. To indicate that the property is of type DATE, use urn:li:dataType:datahub.date*/@UrnValidation={\"entityTypes\":[\"dataType\"],\"exist\":true,\"strict\":true}valueType:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**A map that allows for type specialization of the valueType.\ne.g. a valueType of urn:li:dataType:datahub.urn\ncan be specialized to be a USER or GROUP URN by adding a typeQualifier like \n{ \"allowedTypes\": [\"urn:li:entityType:datahub.corpuser\", \"urn:li:entityType:datahub.corpGroup\"] }*/typeQualifier:optional map[string,array[string]]/**A list of allowed values that the property is allowed to take. \nIf this is not specified, then the property can take any value of given type.*/allowedValues:optional array[record PropertyValue{value:/**Represents a stored primitive property value\n*/typeref PrimitivePropertyValue=union[string,double]/**Optional description of the property value*/description:optional string}]/**The cardinality of the property. If not specified, then the property is assumed to be single valued..*/cardinality:optional enum PropertyCardinality{SINGLE,MULTIPLE}=\"SINGLE\"@Relationship.`/*`={\"entityTypes\":[\"entityType\"],\"name\":\"StructuredPropertyOf\"}@Searchable.`/*`.fieldName=\"entityTypes\"@UrnValidation={\"entityTypes\":[\"entityType\"],\"exist\":true,\"strict\":true}entityTypes:array[com.linkedin.common.Urn]/**The description of the property. This is the description that will be shown in the UI.*/description:optional string/**Search configuration for this property. If not specified, then the property is indexed using the default mapping.\nfrom the logical type.*/searchConfiguration:optional{namespace com.linkedin.datahub/**Configuration for how any given field should be indexed and matched in the DataHub search index.\n*/record DataHubSearchConfig{/**Name of the field in the search index. Defaults to the field name otherwise\n*/fieldName:optional string/**Type of the field. Defines how the field is indexed and matched\n*/fieldType:optional enum SearchFieldType{KEYWORD,TEXT,TEXT_PARTIAL,BROWSE_PATH,URN,URN_PARTIAL,BOOLEAN,COUNT,DATETIME,OBJECT,BROWSE_PATH_V2,WORD_GRAM}/**Whether we should match the field for the default search query\n*/queryByDefault:boolean=false/**Whether we should use the field for default autocomplete\n*/enableAutocomplete:boolean=false/**Whether or not to add field to filters.\n*/addToFilters:boolean=false/**Whether or not to add the \"has values\" to filters.\ncheck if this is conditional on addToFilters being true\n*/addHasValuesToFilters:boolean=true/**Display name of the filter\n*/filterNameOverride:optional string/**Display name of the has values filter\n*/hasValuesFilterNameOverride:optional string/**Boost multiplier to the match score. Matches on fields with higher boost score ranks higher\n*/boostScore:double=1.0/**If set, add a index field of the given name that checks whether the field exists\n*/hasValuesFieldName:optional string/**If set, add a index field of the given name that checks the number of elements\n*/numValuesFieldName:optional string/**(Optional) Weights to apply to score for a given value\n*/weightsPerFieldValue:optional map[string,double]/**(Optional) Aliases for this given field that can be used for sorting etc.\n*/fieldNameAliases:optional array[string]}}/**Whether the structured property value is immutable once applied to an entity.*/@Searchable.fieldType=\"BOOLEAN\"immutable:boolean=false/**Definition version - Allows breaking schema changes. String is compared case-insensitive and new\n                     versions must be monotonically increasing. Cannot use periods/dots.\n                     Suggestions: v1, v2\n                                  20240610, 20240611*/version:optional string/**Created Audit stamp*/@Searchable.`/time`={\"fieldName\":\"createdTime\",\"fieldType\":\"DATETIME\"}created:optional{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**Last Modified Audit stamp*/@Searchable.`/time`={\"fieldName\":\"lastModified\",\"fieldType\":\"DATETIME\"}lastModified:optional com.linkedin.common.AuditStamp}", SchemaFormatType.PDL);
    private String _qualifiedNameField = null;
    private String _displayNameField = null;
    private Urn _valueTypeField = null;
    private StringArrayMap _typeQualifierField = null;
    private PropertyValueArray _allowedValuesField = null;
    private PropertyCardinality _cardinalityField = null;
    private UrnArray _entityTypesField = null;
    private String _descriptionField = null;
    private DataHubSearchConfig _searchConfigurationField = null;
    private Boolean _immutableField = null;
    private String _versionField = null;
    private AuditStamp _createdField = null;
    private AuditStamp _lastModifiedField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_QualifiedName = SCHEMA.getField("qualifiedName");
    private static final RecordDataSchema.Field FIELD_DisplayName = SCHEMA.getField("displayName");
    private static final RecordDataSchema.Field FIELD_ValueType = SCHEMA.getField("valueType");
    private static final RecordDataSchema.Field FIELD_TypeQualifier = SCHEMA.getField("typeQualifier");
    private static final RecordDataSchema.Field FIELD_AllowedValues = SCHEMA.getField("allowedValues");
    private static final RecordDataSchema.Field FIELD_Cardinality = SCHEMA.getField("cardinality");
    private static final PropertyCardinality DEFAULT_Cardinality;
    private static final RecordDataSchema.Field FIELD_EntityTypes;
    private static final RecordDataSchema.Field FIELD_Description;
    private static final RecordDataSchema.Field FIELD_SearchConfiguration;
    private static final RecordDataSchema.Field FIELD_Immutable;
    private static final Boolean DEFAULT_Immutable;
    private static final RecordDataSchema.Field FIELD_Version;
    private static final RecordDataSchema.Field FIELD_Created;
    private static final RecordDataSchema.Field FIELD_LastModified;

    public StructuredPropertyDefinition() {
        super(new DataMap(), SCHEMA, 8);
        this.addChangeListener(this.__changeListener);
    }

    public StructuredPropertyDefinition(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasQualifiedName() {
        if (this._qualifiedNameField != null) {
            return true;
        }
        return this._map.containsKey("qualifiedName");
    }

    public void removeQualifiedName() {
        this._map.remove("qualifiedName");
    }

    @Nullable
    public String getQualifiedName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getQualifiedName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._qualifiedNameField != null) {
                    return this._qualifiedNameField;
                }
                Object __rawValue = this._map.get("qualifiedName");
                this._qualifiedNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._qualifiedNameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getQualifiedName() {
        if (this._qualifiedNameField != null) {
            return this._qualifiedNameField;
        }
        Object __rawValue = this._map.get("qualifiedName");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("qualifiedName");
        }
        this._qualifiedNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._qualifiedNameField;
    }

    public StructuredPropertyDefinition setQualifiedName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setQualifiedName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field qualifiedName of com.linkedin.structured.StructuredPropertyDefinition");
                }
                CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
                this._qualifiedNameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeQualifiedName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
                this._qualifiedNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
                this._qualifiedNameField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setQualifiedName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field qualifiedName of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "qualifiedName", value);
        this._qualifiedNameField = value;
        return this;
    }

    public boolean hasDisplayName() {
        if (this._displayNameField != null) {
            return true;
        }
        return this._map.containsKey("displayName");
    }

    public void removeDisplayName() {
        this._map.remove("displayName");
    }

    @Nullable
    public String getDisplayName(GetMode mode) {
        return this.getDisplayName();
    }

    @Nullable
    public String getDisplayName() {
        if (this._displayNameField != null) {
            return this._displayNameField;
        }
        Object __rawValue = this._map.get("displayName");
        this._displayNameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._displayNameField;
    }

    public StructuredPropertyDefinition setDisplayName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDisplayName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDisplayName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "displayName", value);
                this._displayNameField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setDisplayName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field displayName of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "displayName", value);
        this._displayNameField = value;
        return this;
    }

    public boolean hasValueType() {
        if (this._valueTypeField != null) {
            return true;
        }
        return this._map.containsKey("valueType");
    }

    public void removeValueType() {
        this._map.remove("valueType");
    }

    @Nullable
    public Urn getValueType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getValueType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._valueTypeField != null) {
                    return this._valueTypeField;
                }
                Object __rawValue = this._map.get("valueType");
                this._valueTypeField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._valueTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getValueType() {
        if (this._valueTypeField != null) {
            return this._valueTypeField;
        }
        Object __rawValue = this._map.get("valueType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("valueType");
        }
        this._valueTypeField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._valueTypeField;
    }

    public StructuredPropertyDefinition setValueType(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setValueType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field valueType of com.linkedin.structured.StructuredPropertyDefinition");
                }
                CheckedUtil.putWithoutChecking(this._map, "valueType", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._valueTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeValueType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "valueType", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._valueTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "valueType", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._valueTypeField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setValueType(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field valueType of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "valueType", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._valueTypeField = value;
        return this;
    }

    public boolean hasTypeQualifier() {
        if (this._typeQualifierField != null) {
            return true;
        }
        return this._map.containsKey("typeQualifier");
    }

    public void removeTypeQualifier() {
        this._map.remove("typeQualifier");
    }

    @Nullable
    public StringArrayMap getTypeQualifier(GetMode mode) {
        return this.getTypeQualifier();
    }

    @Nullable
    public StringArrayMap getTypeQualifier() {
        if (this._typeQualifierField != null) {
            return this._typeQualifierField;
        }
        Object __rawValue = this._map.get("typeQualifier");
        this._typeQualifierField = __rawValue == null ? null : new StringArrayMap(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._typeQualifierField;
    }

    public StructuredPropertyDefinition setTypeQualifier(@Nullable StringArrayMap value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTypeQualifier(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTypeQualifier();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "typeQualifier", value.data());
                this._typeQualifierField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "typeQualifier", value.data());
                this._typeQualifierField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setTypeQualifier(@Nonnull StringArrayMap value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field typeQualifier of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "typeQualifier", value.data());
        this._typeQualifierField = value;
        return this;
    }

    public boolean hasAllowedValues() {
        if (this._allowedValuesField != null) {
            return true;
        }
        return this._map.containsKey("allowedValues");
    }

    public void removeAllowedValues() {
        this._map.remove("allowedValues");
    }

    @Nullable
    public PropertyValueArray getAllowedValues(GetMode mode) {
        return this.getAllowedValues();
    }

    @Nullable
    public PropertyValueArray getAllowedValues() {
        if (this._allowedValuesField != null) {
            return this._allowedValuesField;
        }
        Object __rawValue = this._map.get("allowedValues");
        this._allowedValuesField = __rawValue == null ? null : new PropertyValueArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._allowedValuesField;
    }

    public StructuredPropertyDefinition setAllowedValues(@Nullable PropertyValueArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAllowedValues(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAllowedValues();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "allowedValues", value.data());
                this._allowedValuesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "allowedValues", value.data());
                this._allowedValuesField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setAllowedValues(@Nonnull PropertyValueArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field allowedValues of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "allowedValues", value.data());
        this._allowedValuesField = value;
        return this;
    }

    public boolean hasCardinality() {
        if (this._cardinalityField != null) {
            return true;
        }
        return this._map.containsKey("cardinality");
    }

    public void removeCardinality() {
        this._map.remove("cardinality");
    }

    @Nullable
    public PropertyCardinality getCardinality(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getCardinality();
            }
            case NULL: {
                if (this._cardinalityField != null) {
                    return this._cardinalityField;
                }
                Object __rawValue = this._map.get("cardinality");
                this._cardinalityField = DataTemplateUtil.coerceEnumOutput(__rawValue, PropertyCardinality.class, PropertyCardinality.$UNKNOWN);
                return this._cardinalityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public PropertyCardinality getCardinality() {
        if (this._cardinalityField != null) {
            return this._cardinalityField;
        }
        Object __rawValue = this._map.get("cardinality");
        if (__rawValue == null) {
            return DEFAULT_Cardinality;
        }
        this._cardinalityField = DataTemplateUtil.coerceEnumOutput(__rawValue, PropertyCardinality.class, PropertyCardinality.$UNKNOWN);
        return this._cardinalityField;
    }

    public StructuredPropertyDefinition setCardinality(@Nullable PropertyCardinality value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCardinality(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCardinality();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
                this._cardinalityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
                this._cardinalityField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setCardinality(@Nonnull PropertyCardinality value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field cardinality of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "cardinality", value.name());
        this._cardinalityField = value;
        return this;
    }

    public boolean hasEntityTypes() {
        if (this._entityTypesField != null) {
            return true;
        }
        return this._map.containsKey("entityTypes");
    }

    public void removeEntityTypes() {
        this._map.remove("entityTypes");
    }

    @Nullable
    public UrnArray getEntityTypes(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntityTypes();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityTypesField != null) {
                    return this._entityTypesField;
                }
                Object __rawValue = this._map.get("entityTypes");
                this._entityTypesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._entityTypesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public UrnArray getEntityTypes() {
        if (this._entityTypesField != null) {
            return this._entityTypesField;
        }
        Object __rawValue = this._map.get("entityTypes");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entityTypes");
        }
        this._entityTypesField = __rawValue == null ? null : new UrnArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._entityTypesField;
    }

    public StructuredPropertyDefinition setEntityTypes(@Nullable UrnArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityTypes(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entityTypes of com.linkedin.structured.StructuredPropertyDefinition");
                }
                CheckedUtil.putWithoutChecking(this._map, "entityTypes", value.data());
                this._entityTypesField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityTypes();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityTypes", value.data());
                this._entityTypesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityTypes", value.data());
                this._entityTypesField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setEntityTypes(@Nonnull UrnArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityTypes of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityTypes", value.data());
        this._entityTypesField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public StructuredPropertyDefinition setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasSearchConfiguration() {
        if (this._searchConfigurationField != null) {
            return true;
        }
        return this._map.containsKey("searchConfiguration");
    }

    public void removeSearchConfiguration() {
        this._map.remove("searchConfiguration");
    }

    @Nullable
    public DataHubSearchConfig getSearchConfiguration(GetMode mode) {
        return this.getSearchConfiguration();
    }

    @Nullable
    public DataHubSearchConfig getSearchConfiguration() {
        if (this._searchConfigurationField != null) {
            return this._searchConfigurationField;
        }
        Object __rawValue = this._map.get("searchConfiguration");
        this._searchConfigurationField = __rawValue == null ? null : new DataHubSearchConfig(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._searchConfigurationField;
    }

    public StructuredPropertyDefinition setSearchConfiguration(@Nullable DataHubSearchConfig value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSearchConfiguration(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSearchConfiguration();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "searchConfiguration", value.data());
                this._searchConfigurationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "searchConfiguration", value.data());
                this._searchConfigurationField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setSearchConfiguration(@Nonnull DataHubSearchConfig value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field searchConfiguration of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "searchConfiguration", value.data());
        this._searchConfigurationField = value;
        return this;
    }

    public boolean hasImmutable() {
        if (this._immutableField != null) {
            return true;
        }
        return this._map.containsKey("immutable");
    }

    public void removeImmutable() {
        this._map.remove("immutable");
    }

    @Nullable
    public Boolean isImmutable(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.isImmutable();
            }
            case NULL: {
                if (this._immutableField != null) {
                    return this._immutableField;
                }
                Object __rawValue = this._map.get("immutable");
                this._immutableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
                return this._immutableField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Boolean isImmutable() {
        if (this._immutableField != null) {
            return this._immutableField;
        }
        Object __rawValue = this._map.get("immutable");
        if (__rawValue == null) {
            return DEFAULT_Immutable;
        }
        this._immutableField = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._immutableField;
    }

    public StructuredPropertyDefinition setImmutable(@Nullable Boolean value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setImmutable(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field immutable of com.linkedin.structured.StructuredPropertyDefinition");
                }
                CheckedUtil.putWithoutChecking(this._map, "immutable", value);
                this._immutableField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeImmutable();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "immutable", value);
                this._immutableField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "immutable", value);
                this._immutableField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setImmutable(@Nonnull Boolean value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field immutable of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "immutable", value);
        this._immutableField = value;
        return this;
    }

    public StructuredPropertyDefinition setImmutable(boolean value) {
        CheckedUtil.putWithoutChecking(this._map, "immutable", value);
        this._immutableField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public String getVersion(GetMode mode) {
        return this.getVersion();
    }

    @Nullable
    public String getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        this._versionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._versionField;
    }

    public StructuredPropertyDefinition setVersion(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", value);
                this._versionField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setVersion(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", value);
        this._versionField = value;
        return this;
    }

    public boolean hasCreated() {
        if (this._createdField != null) {
            return true;
        }
        return this._map.containsKey("created");
    }

    public void removeCreated() {
        this._map.remove("created");
    }

    @Nullable
    public AuditStamp getCreated(GetMode mode) {
        return this.getCreated();
    }

    @Nullable
    public AuditStamp getCreated() {
        if (this._createdField != null) {
            return this._createdField;
        }
        Object __rawValue = this._map.get("created");
        this._createdField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._createdField;
    }

    public StructuredPropertyDefinition setCreated(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCreated(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCreated();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "created", value.data());
                this._createdField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setCreated(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field created of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "created", value.data());
        this._createdField = value;
        return this;
    }

    public boolean hasLastModified() {
        if (this._lastModifiedField != null) {
            return true;
        }
        return this._map.containsKey("lastModified");
    }

    public void removeLastModified() {
        this._map.remove("lastModified");
    }

    @Nullable
    public AuditStamp getLastModified(GetMode mode) {
        return this.getLastModified();
    }

    @Nullable
    public AuditStamp getLastModified() {
        if (this._lastModifiedField != null) {
            return this._lastModifiedField;
        }
        Object __rawValue = this._map.get("lastModified");
        this._lastModifiedField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._lastModifiedField;
    }

    public StructuredPropertyDefinition setLastModified(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setLastModified(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeLastModified();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
                this._lastModifiedField = value;
            }
        }
        return this;
    }

    public StructuredPropertyDefinition setLastModified(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field lastModified of com.linkedin.structured.StructuredPropertyDefinition to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "lastModified", value.data());
        this._lastModifiedField = value;
        return this;
    }

    @Override
    public StructuredPropertyDefinition clone() throws CloneNotSupportedException {
        StructuredPropertyDefinition __clone = (StructuredPropertyDefinition)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public StructuredPropertyDefinition copy() throws CloneNotSupportedException {
        StructuredPropertyDefinition __copy = (StructuredPropertyDefinition)super.copy();
        __copy._allowedValuesField = null;
        __copy._qualifiedNameField = null;
        __copy._displayNameField = null;
        __copy._createdField = null;
        __copy._descriptionField = null;
        __copy._versionField = null;
        __copy._cardinalityField = null;
        __copy._immutableField = null;
        __copy._valueTypeField = null;
        __copy._entityTypesField = null;
        __copy._lastModifiedField = null;
        __copy._typeQualifierField = null;
        __copy._searchConfigurationField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_EntityTypes = SCHEMA.getField("entityTypes");
        FIELD_Description = SCHEMA.getField("description");
        FIELD_SearchConfiguration = SCHEMA.getField("searchConfiguration");
        FIELD_Immutable = SCHEMA.getField("immutable");
        FIELD_Version = SCHEMA.getField("version");
        FIELD_Created = SCHEMA.getField("created");
        FIELD_LastModified = SCHEMA.getField("lastModified");
        Custom.initializeCustomClass(Urn.class);
        DEFAULT_Cardinality = DataTemplateUtil.coerceEnumOutput(FIELD_Cardinality.getDefault(), PropertyCardinality.class, PropertyCardinality.$UNKNOWN);
        DEFAULT_Immutable = DataTemplateUtil.coerceBooleanOutput(FIELD_Immutable.getDefault());
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final StructuredPropertyDefinition __objectRef;

        private ChangeListener(StructuredPropertyDefinition reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "allowedValues": {
                    this.__objectRef._allowedValuesField = null;
                    break;
                }
                case "qualifiedName": {
                    this.__objectRef._qualifiedNameField = null;
                    break;
                }
                case "displayName": {
                    this.__objectRef._displayNameField = null;
                    break;
                }
                case "created": {
                    this.__objectRef._createdField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                    break;
                }
                case "cardinality": {
                    this.__objectRef._cardinalityField = null;
                    break;
                }
                case "immutable": {
                    this.__objectRef._immutableField = null;
                    break;
                }
                case "valueType": {
                    this.__objectRef._valueTypeField = null;
                    break;
                }
                case "entityTypes": {
                    this.__objectRef._entityTypesField = null;
                    break;
                }
                case "lastModified": {
                    this.__objectRef._lastModifiedField = null;
                    break;
                }
                case "typeQualifier": {
                    this.__objectRef._typeQualifierField = null;
                    break;
                }
                case "searchConfiguration": {
                    this.__objectRef._searchConfigurationField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec qualifiedName() {
            return new PathSpec(this.getPathComponents(), "qualifiedName");
        }

        public PathSpec displayName() {
            return new PathSpec(this.getPathComponents(), "displayName");
        }

        public PathSpec valueType() {
            return new PathSpec(this.getPathComponents(), "valueType");
        }

        public PathSpec typeQualifier() {
            return new PathSpec(this.getPathComponents(), "typeQualifier");
        }

        public PropertyValueArray.Fields allowedValues() {
            return new PropertyValueArray.Fields(this.getPathComponents(), "allowedValues");
        }

        public PathSpec allowedValues(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "allowedValues");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec cardinality() {
            return new PathSpec(this.getPathComponents(), "cardinality");
        }

        public PathSpec entityTypes() {
            return new PathSpec(this.getPathComponents(), "entityTypes");
        }

        public PathSpec entityTypes(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "entityTypes");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public DataHubSearchConfig.Fields searchConfiguration() {
            return new DataHubSearchConfig.Fields(this.getPathComponents(), "searchConfiguration");
        }

        public PathSpec immutable() {
            return new PathSpec(this.getPathComponents(), "immutable");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }

        public AuditStamp.Fields created() {
            return new AuditStamp.Fields(this.getPathComponents(), "created");
        }

        public AuditStamp.Fields lastModified() {
            return new AuditStamp.Fields(this.getPathComponents(), "lastModified");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private PropertyValueArray.ProjectionMask _allowedValuesMask;
        private DataHubSearchConfig.ProjectionMask _searchConfigurationMask;
        private AuditStamp.ProjectionMask _createdMask;
        private AuditStamp.ProjectionMask _lastModifiedMask;

        ProjectionMask() {
        }

        public ProjectionMask withQualifiedName() {
            this.getDataMap().put("qualifiedName", 1);
            return this;
        }

        public ProjectionMask withDisplayName() {
            this.getDataMap().put("displayName", 1);
            return this;
        }

        public ProjectionMask withValueType() {
            this.getDataMap().put("valueType", 1);
            return this;
        }

        public ProjectionMask withTypeQualifier() {
            this.getDataMap().put("typeQualifier", 1);
            return this;
        }

        public ProjectionMask withAllowedValues(Function<PropertyValueArray.ProjectionMask, PropertyValueArray.ProjectionMask> nestedMask) {
            this._allowedValuesMask = nestedMask.apply(this._allowedValuesMask == null ? PropertyValueArray.createMask() : this._allowedValuesMask);
            this.getDataMap().put("allowedValues", this._allowedValuesMask.getDataMap());
            return this;
        }

        public ProjectionMask withAllowedValues() {
            this._allowedValuesMask = null;
            this.getDataMap().put("allowedValues", 1);
            return this;
        }

        public ProjectionMask withAllowedValues(Function<PropertyValueArray.ProjectionMask, PropertyValueArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._allowedValuesMask = nestedMask.apply(this._allowedValuesMask == null ? PropertyValueArray.createMask() : this._allowedValuesMask);
            this.getDataMap().put("allowedValues", this._allowedValuesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("allowedValues").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("allowedValues").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withAllowedValues(Integer start, Integer count) {
            this._allowedValuesMask = null;
            this.getDataMap().put("allowedValues", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("allowedValues").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("allowedValues").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withCardinality() {
            this.getDataMap().put("cardinality", 1);
            return this;
        }

        public ProjectionMask withEntityTypes() {
            this.getDataMap().put("entityTypes", 1);
            return this;
        }

        public ProjectionMask withEntityTypes(Integer start, Integer count) {
            this.getDataMap().put("entityTypes", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("entityTypes").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("entityTypes").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withSearchConfiguration(Function<DataHubSearchConfig.ProjectionMask, DataHubSearchConfig.ProjectionMask> nestedMask) {
            this._searchConfigurationMask = nestedMask.apply(this._searchConfigurationMask == null ? DataHubSearchConfig.createMask() : this._searchConfigurationMask);
            this.getDataMap().put("searchConfiguration", this._searchConfigurationMask.getDataMap());
            return this;
        }

        public ProjectionMask withSearchConfiguration() {
            this._searchConfigurationMask = null;
            this.getDataMap().put("searchConfiguration", 1);
            return this;
        }

        public ProjectionMask withImmutable() {
            this.getDataMap().put("immutable", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }

        public ProjectionMask withCreated(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._createdMask = nestedMask.apply(this._createdMask == null ? AuditStamp.createMask() : this._createdMask);
            this.getDataMap().put("created", this._createdMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated(MaskMap nestedMask) {
            this.getDataMap().put("created", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withCreated() {
            this._createdMask = null;
            this.getDataMap().put("created", 1);
            return this;
        }

        public ProjectionMask withLastModified(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._lastModifiedMask = nestedMask.apply(this._lastModifiedMask == null ? AuditStamp.createMask() : this._lastModifiedMask);
            this.getDataMap().put("lastModified", this._lastModifiedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified(MaskMap nestedMask) {
            this.getDataMap().put("lastModified", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withLastModified() {
            this._lastModifiedMask = null;
            this.getDataMap().put("lastModified", 1);
            return this;
        }
    }
}

