/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.settings.asset;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.settings.asset.AssetSummarySettingsTemplateArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssetSummarySettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.settings.asset/**Information related to the asset summary for this asset*/record AssetSummarySettings{/**The list of templates applied to this asset in order. Right now we only expect one.*/@Relationship.`/*/template`={\"entityTypes\":[\"dataHubPageTemplate\"],\"name\":\"HasSummaryTemplate\"}templates:optional array[/**Object containing the template and any additional info for asset summary settings*/record AssetSummarySettingsTemplate{/**The urn of the template*/template:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}]=[]}", SchemaFormatType.PDL);
    private AssetSummarySettingsTemplateArray _templatesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Templates = SCHEMA.getField("templates");
    private static final AssetSummarySettingsTemplateArray DEFAULT_Templates = FIELD_Templates.getDefault() == null ? null : new AssetSummarySettingsTemplateArray(DataTemplateUtil.castOrThrow(FIELD_Templates.getDefault(), DataList.class));

    public AssetSummarySettings() {
        super(new DataMap(2, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public AssetSummarySettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTemplates() {
        if (this._templatesField != null) {
            return true;
        }
        return this._map.containsKey("templates");
    }

    public void removeTemplates() {
        this._map.remove("templates");
    }

    @Nullable
    public AssetSummarySettingsTemplateArray getTemplates(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getTemplates();
            }
            case NULL: {
                if (this._templatesField != null) {
                    return this._templatesField;
                }
                Object __rawValue = this._map.get("templates");
                this._templatesField = __rawValue == null ? null : new AssetSummarySettingsTemplateArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._templatesField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nullable
    public AssetSummarySettingsTemplateArray getTemplates() {
        if (this._templatesField != null) {
            return this._templatesField;
        }
        Object __rawValue = this._map.get("templates");
        if (__rawValue == null) {
            return DEFAULT_Templates;
        }
        this._templatesField = __rawValue == null ? null : new AssetSummarySettingsTemplateArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._templatesField;
    }

    public AssetSummarySettings setTemplates(@Nullable AssetSummarySettingsTemplateArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTemplates(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTemplates();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "templates", value.data());
                this._templatesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "templates", value.data());
                this._templatesField = value;
            }
        }
        return this;
    }

    public AssetSummarySettings setTemplates(@Nonnull AssetSummarySettingsTemplateArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field templates of com.linkedin.settings.asset.AssetSummarySettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "templates", value.data());
        this._templatesField = value;
        return this;
    }

    @Override
    public AssetSummarySettings clone() throws CloneNotSupportedException {
        AssetSummarySettings __clone = (AssetSummarySettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public AssetSummarySettings copy() throws CloneNotSupportedException {
        AssetSummarySettings __copy = (AssetSummarySettings)super.copy();
        __copy._templatesField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final AssetSummarySettings __objectRef;

        private ChangeListener(AssetSummarySettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "templates": {
                    this.__objectRef._templatesField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public AssetSummarySettingsTemplateArray.Fields templates() {
            return new AssetSummarySettingsTemplateArray.Fields(this.getPathComponents(), "templates");
        }

        public PathSpec templates(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "templates");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private AssetSummarySettingsTemplateArray.ProjectionMask _templatesMask;

        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withTemplates(Function<AssetSummarySettingsTemplateArray.ProjectionMask, AssetSummarySettingsTemplateArray.ProjectionMask> nestedMask) {
            this._templatesMask = nestedMask.apply(this._templatesMask == null ? AssetSummarySettingsTemplateArray.createMask() : this._templatesMask);
            this.getDataMap().put("templates", this._templatesMask.getDataMap());
            return this;
        }

        public ProjectionMask withTemplates() {
            this._templatesMask = null;
            this.getDataMap().put("templates", 1);
            return this;
        }

        public ProjectionMask withTemplates(Function<AssetSummarySettingsTemplateArray.ProjectionMask, AssetSummarySettingsTemplateArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._templatesMask = nestedMask.apply(this._templatesMask == null ? AssetSummarySettingsTemplateArray.createMask() : this._templatesMask);
            this.getDataMap().put("templates", this._templatesMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("templates").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("templates").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withTemplates(Integer start, Integer count) {
            this._templatesMask = null;
            this.getDataMap().put("templates", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("templates").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("templates").put("$count", count);
            }
            return this;
        }
    }
}

