/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MySqlDDL
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.schema/**Schema holder for MySql data definition language that describes an MySql table.*/record MySqlDDL{/**The native schema in the dataset's platform. This is a human readable (json blob) table schema.*/tableSchema:string}", SchemaFormatType.PDL);
    private String _tableSchemaField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_TableSchema = SCHEMA.getField("tableSchema");

    public MySqlDDL() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public MySqlDDL(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasTableSchema() {
        if (this._tableSchemaField != null) {
            return true;
        }
        return this._map.containsKey("tableSchema");
    }

    public void removeTableSchema() {
        this._map.remove("tableSchema");
    }

    @Nullable
    public String getTableSchema(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTableSchema();
            }
            case DEFAULT: 
            case NULL: {
                if (this._tableSchemaField != null) {
                    return this._tableSchemaField;
                }
                Object __rawValue = this._map.get("tableSchema");
                this._tableSchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._tableSchemaField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTableSchema() {
        if (this._tableSchemaField != null) {
            return this._tableSchemaField;
        }
        Object __rawValue = this._map.get("tableSchema");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("tableSchema");
        }
        this._tableSchemaField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._tableSchemaField;
    }

    public MySqlDDL setTableSchema(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTableSchema(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field tableSchema of com.linkedin.schema.MySqlDDL");
                }
                CheckedUtil.putWithoutChecking(this._map, "tableSchema", value);
                this._tableSchemaField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTableSchema();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "tableSchema", value);
                this._tableSchemaField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "tableSchema", value);
                this._tableSchemaField = value;
            }
        }
        return this;
    }

    public MySqlDDL setTableSchema(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field tableSchema of com.linkedin.schema.MySqlDDL to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "tableSchema", value);
        this._tableSchemaField = value;
        return this;
    }

    @Override
    public MySqlDDL clone() throws CloneNotSupportedException {
        MySqlDDL __clone = (MySqlDDL)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MySqlDDL copy() throws CloneNotSupportedException {
        MySqlDDL __copy = (MySqlDDL)super.copy();
        __copy._tableSchemaField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MySqlDDL __objectRef;

        private ChangeListener(MySqlDDL reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "tableSchema": {
                    this.__objectRef._tableSchemaField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec tableSchema() {
            return new PathSpec(this.getPathComponents(), "tableSchema");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(2);
        }

        public ProjectionMask withTableSchema() {
            this.getDataMap().put("tableSchema", 1);
            return this;
        }
    }
}

