/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.schema;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.TemplateOutputCastException;
import com.linkedin.data.template.WrappingArrayTemplate;
import com.linkedin.schema.ForeignKeyConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class ForeignKeyConstraintArray
extends WrappingArrayTemplate<ForeignKeyConstraint> {
    private static final ArrayDataSchema SCHEMA = (ArrayDataSchema)DataTemplateUtil.parseSchema("array[{namespace com.linkedin.schema/**Description of a foreign key constraint in a schema.*/record ForeignKeyConstraint{/**Name of the constraint, likely provided from the source*/name:string/**Fields the constraint maps to on the foreign dataset*/@Relationship.`/*`={\"entityTypes\":[\"schemaField\"],\"name\":\"ForeignKeyTo\"}foreignFields:array[{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}]/**Fields the constraint maps to on the source dataset*/sourceFields:array[com.linkedin.common.Urn]/**Reference to the foreign dataset for ease of lookup*/@Relationship={\"entityTypes\":[\"dataset\"],\"name\":\"ForeignKeyToDataset\"}foreignDataset:com.linkedin.common.Urn}}]", SchemaFormatType.PDL);

    public ForeignKeyConstraintArray() {
        this(new DataList());
    }

    public ForeignKeyConstraintArray(int initialCapacity) {
        this(new DataList(initialCapacity));
    }

    public ForeignKeyConstraintArray(Collection<ForeignKeyConstraint> c) {
        this(new DataList(c.size()));
        this.addAll(c);
    }

    public ForeignKeyConstraintArray(DataList data) {
        super(data, SCHEMA, ForeignKeyConstraint.class);
    }

    public ForeignKeyConstraintArray(ForeignKeyConstraint first, ForeignKeyConstraint ... rest) {
        this(new DataList(rest.length + 1));
        this.add(first);
        this.addAll(Arrays.asList(rest));
    }

    public static ArrayDataSchema dataSchema() {
        return SCHEMA;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public ForeignKeyConstraintArray clone() throws CloneNotSupportedException {
        ForeignKeyConstraintArray __clone = (ForeignKeyConstraintArray)super.clone();
        return __clone;
    }

    @Override
    public ForeignKeyConstraintArray copy() throws CloneNotSupportedException {
        ForeignKeyConstraintArray __copy = (ForeignKeyConstraintArray)super.copy();
        return __copy;
    }

    @Override
    protected ForeignKeyConstraint coerceOutput(Object object) throws TemplateOutputCastException {
        assert (object != null);
        return object == null ? null : new ForeignKeyConstraint(DataTemplateUtil.castOrThrow(object, DataMap.class));
    }

    public static class ProjectionMask
    extends MaskMap {
        private ForeignKeyConstraint.ProjectionMask _itemsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withItems(Function<ForeignKeyConstraint.ProjectionMask, ForeignKeyConstraint.ProjectionMask> nestedMask) {
            this._itemsMask = nestedMask.apply(this._itemsMask == null ? ForeignKeyConstraint.createMask() : this._itemsMask);
            this.getDataMap().put("$*", this._itemsMask.getDataMap());
            return this;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public ForeignKeyConstraint.Fields items() {
            return new ForeignKeyConstraint.Fields(this.getPathComponents(), PathSpec.WILDCARD);
        }
    }
}

