/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.platform.event.v1;

import com.linkedin.common.AuditStamp;
import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.platform.event.v1.Parameters;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityChangeEvent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.platform.event.v1/**Shared fields for all entity change events.*/@Event.name=\"entityChangeEvent\"record EntityChangeEvent{/**The type of the entity affected. Corresponds to the entity registry, e.g. 'dataset', 'chart', 'dashboard', etc.*/entityType:string/**The urn of the entity which was affected.*/entityUrn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}/**The category type (TAG, GLOSSARY_TERM, OWNERSHIP, TECHNICAL_SCHEMA, etc). This is used to determine what the rest of the schema will look like.*/category:string/**The operation type. This is used to determine what the rest of the schema will look like.*/operation:string/**The urn of the entity which was affected.*/modifier:optional string/**Arbitrary key-value parameters corresponding to the event.*/parameters:optional/**Arbitrary key-value parameters for an Entity Change Event. (any record).*/record Parameters{}/**Audit stamp of the operation*/auditStamp:{namespace com.linkedin.common/**Data captured on a resource/association/sub-resource level giving insight into when that resource/association/sub-resource moved into a particular lifecycle stage, and who acted to move it into that specific lifecycle stage.*/record AuditStamp{/**When did the resource/association/sub-resource move into the specific lifecycle stage represented by this AuditEvent.*/time:/**Number of milliseconds since midnight, January 1, 1970 UTC. It must be a positive number*/typeref Time=long/**The entity (e.g. a member URN) which will be credited for moving the resource/association/sub-resource into the specific lifecycle stage. It is also the one used to authorize the change.*/actor:Urn/**The entity (e.g. a service URN) which performs the change on behalf of the Actor and must be authorized to act as the Actor.*/impersonator:optional Urn/**Additional context around how DataHub was informed of the particular change. For example: was the change created by an automated process, or manually.*/message:optional string}}/**The version of the event type, incremented in integers.*/version:int}", SchemaFormatType.PDL);
    private String _entityTypeField = null;
    private Urn _entityUrnField = null;
    private String _categoryField = null;
    private String _operationField = null;
    private String _modifierField = null;
    private Parameters _parametersField = null;
    private AuditStamp _auditStampField = null;
    private Integer _versionField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_EntityType = SCHEMA.getField("entityType");
    private static final RecordDataSchema.Field FIELD_EntityUrn = SCHEMA.getField("entityUrn");
    private static final RecordDataSchema.Field FIELD_Category = SCHEMA.getField("category");
    private static final RecordDataSchema.Field FIELD_Operation = SCHEMA.getField("operation");
    private static final RecordDataSchema.Field FIELD_Modifier = SCHEMA.getField("modifier");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private static final RecordDataSchema.Field FIELD_AuditStamp = SCHEMA.getField("auditStamp");
    private static final RecordDataSchema.Field FIELD_Version = SCHEMA.getField("version");

    public EntityChangeEvent() {
        super(new DataMap(11, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public EntityChangeEvent(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntityType() {
        if (this._entityTypeField != null) {
            return true;
        }
        return this._map.containsKey("entityType");
    }

    public void removeEntityType() {
        this._map.remove("entityType");
    }

    @Nullable
    public String getEntityType(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntityType();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityTypeField != null) {
                    return this._entityTypeField;
                }
                Object __rawValue = this._map.get("entityType");
                this._entityTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._entityTypeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getEntityType() {
        if (this._entityTypeField != null) {
            return this._entityTypeField;
        }
        Object __rawValue = this._map.get("entityType");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entityType");
        }
        this._entityTypeField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._entityTypeField;
    }

    public EntityChangeEvent setEntityType(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entityType of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityType", value);
                this._entityTypeField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setEntityType(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityType of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityType", value);
        this._entityTypeField = value;
        return this;
    }

    public boolean hasEntityUrn() {
        if (this._entityUrnField != null) {
            return true;
        }
        return this._map.containsKey("entityUrn");
    }

    public void removeEntityUrn() {
        this._map.remove("entityUrn");
    }

    @Nullable
    public Urn getEntityUrn(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntityUrn();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityUrnField != null) {
                    return this._entityUrnField;
                }
                Object __rawValue = this._map.get("entityUrn");
                this._entityUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityUrnField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntityUrn() {
        if (this._entityUrnField != null) {
            return this._entityUrnField;
        }
        Object __rawValue = this._map.get("entityUrn");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entityUrn");
        }
        this._entityUrnField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityUrnField;
    }

    public EntityChangeEvent setEntityUrn(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityUrn(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entityUrn of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityUrnField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityUrn();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityUrnField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityUrnField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setEntityUrn(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityUrn of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityUrn", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityUrnField = value;
        return this;
    }

    public boolean hasCategory() {
        if (this._categoryField != null) {
            return true;
        }
        return this._map.containsKey("category");
    }

    public void removeCategory() {
        this._map.remove("category");
    }

    @Nullable
    public String getCategory(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getCategory();
            }
            case DEFAULT: 
            case NULL: {
                if (this._categoryField != null) {
                    return this._categoryField;
                }
                Object __rawValue = this._map.get("category");
                this._categoryField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._categoryField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getCategory() {
        if (this._categoryField != null) {
            return this._categoryField;
        }
        Object __rawValue = this._map.get("category");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("category");
        }
        this._categoryField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._categoryField;
    }

    public EntityChangeEvent setCategory(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setCategory(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field category of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeCategory();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "category", value);
                this._categoryField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setCategory(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field category of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "category", value);
        this._categoryField = value;
        return this;
    }

    public boolean hasOperation() {
        if (this._operationField != null) {
            return true;
        }
        return this._map.containsKey("operation");
    }

    public void removeOperation() {
        this._map.remove("operation");
    }

    @Nullable
    public String getOperation(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getOperation();
            }
            case DEFAULT: 
            case NULL: {
                if (this._operationField != null) {
                    return this._operationField;
                }
                Object __rawValue = this._map.get("operation");
                this._operationField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._operationField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getOperation() {
        if (this._operationField != null) {
            return this._operationField;
        }
        Object __rawValue = this._map.get("operation");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("operation");
        }
        this._operationField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._operationField;
    }

    public EntityChangeEvent setOperation(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setOperation(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field operation of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "operation", value);
                this._operationField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeOperation();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "operation", value);
                this._operationField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "operation", value);
                this._operationField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setOperation(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field operation of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "operation", value);
        this._operationField = value;
        return this;
    }

    public boolean hasModifier() {
        if (this._modifierField != null) {
            return true;
        }
        return this._map.containsKey("modifier");
    }

    public void removeModifier() {
        this._map.remove("modifier");
    }

    @Nullable
    public String getModifier(GetMode mode) {
        return this.getModifier();
    }

    @Nullable
    public String getModifier() {
        if (this._modifierField != null) {
            return this._modifierField;
        }
        Object __rawValue = this._map.get("modifier");
        this._modifierField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._modifierField;
    }

    public EntityChangeEvent setModifier(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setModifier(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeModifier();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "modifier", value);
                this._modifierField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "modifier", value);
                this._modifierField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setModifier(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field modifier of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "modifier", value);
        this._modifierField = value;
        return this;
    }

    public boolean hasParameters() {
        if (this._parametersField != null) {
            return true;
        }
        return this._map.containsKey("parameters");
    }

    public void removeParameters() {
        this._map.remove("parameters");
    }

    @Nullable
    public Parameters getParameters(GetMode mode) {
        return this.getParameters();
    }

    @Nullable
    public Parameters getParameters() {
        if (this._parametersField != null) {
            return this._parametersField;
        }
        Object __rawValue = this._map.get("parameters");
        this._parametersField = __rawValue == null ? null : new Parameters(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._parametersField;
    }

    public EntityChangeEvent setParameters(@Nullable Parameters value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setParameters(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeParameters();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
                this._parametersField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setParameters(@Nonnull Parameters value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field parameters of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "parameters", value.data());
        this._parametersField = value;
        return this;
    }

    public boolean hasAuditStamp() {
        if (this._auditStampField != null) {
            return true;
        }
        return this._map.containsKey("auditStamp");
    }

    public void removeAuditStamp() {
        this._map.remove("auditStamp");
    }

    @Nullable
    public AuditStamp getAuditStamp(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAuditStamp();
            }
            case DEFAULT: 
            case NULL: {
                if (this._auditStampField != null) {
                    return this._auditStampField;
                }
                Object __rawValue = this._map.get("auditStamp");
                this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._auditStampField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public AuditStamp getAuditStamp() {
        if (this._auditStampField != null) {
            return this._auditStampField;
        }
        Object __rawValue = this._map.get("auditStamp");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("auditStamp");
        }
        this._auditStampField = __rawValue == null ? null : new AuditStamp(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._auditStampField;
    }

    public EntityChangeEvent setAuditStamp(@Nullable AuditStamp value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAuditStamp(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field auditStamp of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAuditStamp();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
                this._auditStampField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setAuditStamp(@Nonnull AuditStamp value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field auditStamp of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "auditStamp", value.data());
        this._auditStampField = value;
        return this;
    }

    public boolean hasVersion() {
        if (this._versionField != null) {
            return true;
        }
        return this._map.containsKey("version");
    }

    public void removeVersion() {
        this._map.remove("version");
    }

    @Nullable
    public Integer getVersion(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getVersion();
            }
            case DEFAULT: 
            case NULL: {
                if (this._versionField != null) {
                    return this._versionField;
                }
                Object __rawValue = this._map.get("version");
                this._versionField = DataTemplateUtil.coerceIntOutput(__rawValue);
                return this._versionField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Integer getVersion() {
        if (this._versionField != null) {
            return this._versionField;
        }
        Object __rawValue = this._map.get("version");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("version");
        }
        this._versionField = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._versionField;
    }

    public EntityChangeEvent setVersion(@Nullable Integer value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setVersion(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field version of com.linkedin.platform.event.v1.EntityChangeEvent");
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceIntInput(value));
                this._versionField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeVersion();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceIntInput(value));
                this._versionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceIntInput(value));
                this._versionField = value;
            }
        }
        return this;
    }

    public EntityChangeEvent setVersion(@Nonnull Integer value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field version of com.linkedin.platform.event.v1.EntityChangeEvent to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceIntInput(value));
        this._versionField = value;
        return this;
    }

    public EntityChangeEvent setVersion(int value) {
        CheckedUtil.putWithoutChecking(this._map, "version", DataTemplateUtil.coerceIntInput(value));
        this._versionField = value;
        return this;
    }

    @Override
    public EntityChangeEvent clone() throws CloneNotSupportedException {
        EntityChangeEvent __clone = (EntityChangeEvent)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EntityChangeEvent copy() throws CloneNotSupportedException {
        EntityChangeEvent __copy = (EntityChangeEvent)super.copy();
        __copy._auditStampField = null;
        __copy._entityUrnField = null;
        __copy._entityTypeField = null;
        __copy._modifierField = null;
        __copy._categoryField = null;
        __copy._operationField = null;
        __copy._parametersField = null;
        __copy._versionField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EntityChangeEvent __objectRef;

        private ChangeListener(EntityChangeEvent reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "auditStamp": {
                    this.__objectRef._auditStampField = null;
                    break;
                }
                case "entityUrn": {
                    this.__objectRef._entityUrnField = null;
                    break;
                }
                case "entityType": {
                    this.__objectRef._entityTypeField = null;
                    break;
                }
                case "modifier": {
                    this.__objectRef._modifierField = null;
                    break;
                }
                case "category": {
                    this.__objectRef._categoryField = null;
                    break;
                }
                case "operation": {
                    this.__objectRef._operationField = null;
                    break;
                }
                case "parameters": {
                    this.__objectRef._parametersField = null;
                    break;
                }
                case "version": {
                    this.__objectRef._versionField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entityType() {
            return new PathSpec(this.getPathComponents(), "entityType");
        }

        public PathSpec entityUrn() {
            return new PathSpec(this.getPathComponents(), "entityUrn");
        }

        public PathSpec category() {
            return new PathSpec(this.getPathComponents(), "category");
        }

        public PathSpec operation() {
            return new PathSpec(this.getPathComponents(), "operation");
        }

        public PathSpec modifier() {
            return new PathSpec(this.getPathComponents(), "modifier");
        }

        public Parameters.Fields parameters() {
            return new Parameters.Fields(this.getPathComponents(), "parameters");
        }

        public AuditStamp.Fields auditStamp() {
            return new AuditStamp.Fields(this.getPathComponents(), "auditStamp");
        }

        public PathSpec version() {
            return new PathSpec(this.getPathComponents(), "version");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private Parameters.ProjectionMask _parametersMask;
        private AuditStamp.ProjectionMask _auditStampMask;

        ProjectionMask() {
            super(11);
        }

        public ProjectionMask withEntityType() {
            this.getDataMap().put("entityType", 1);
            return this;
        }

        public ProjectionMask withEntityUrn() {
            this.getDataMap().put("entityUrn", 1);
            return this;
        }

        public ProjectionMask withCategory() {
            this.getDataMap().put("category", 1);
            return this;
        }

        public ProjectionMask withOperation() {
            this.getDataMap().put("operation", 1);
            return this;
        }

        public ProjectionMask withModifier() {
            this.getDataMap().put("modifier", 1);
            return this;
        }

        public ProjectionMask withParameters(Function<Parameters.ProjectionMask, Parameters.ProjectionMask> nestedMask) {
            this._parametersMask = nestedMask.apply(this._parametersMask == null ? Parameters.createMask() : this._parametersMask);
            this.getDataMap().put("parameters", this._parametersMask.getDataMap());
            return this;
        }

        public ProjectionMask withParameters() {
            this._parametersMask = null;
            this.getDataMap().put("parameters", 1);
            return this;
        }

        public ProjectionMask withAuditStamp(Function<AuditStamp.ProjectionMask, AuditStamp.ProjectionMask> nestedMask) {
            this._auditStampMask = nestedMask.apply(this._auditStampMask == null ? AuditStamp.createMask() : this._auditStampMask);
            this.getDataMap().put("auditStamp", this._auditStampMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp(MaskMap nestedMask) {
            this.getDataMap().put("auditStamp", nestedMask.getDataMap());
            return this;
        }

        public ProjectionMask withAuditStamp() {
            this._auditStampMask = null;
            this.getDataMap().put("auditStamp", 1);
            return this;
        }

        public ProjectionMask withVersion() {
            this.getDataMap().put("version", 1);
            return this;
        }
    }
}

