/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.ml.metadata.MLModelFactorsArray;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MLModelFactorPrompts
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**Prompts which affect the performance of the MLModel*/@Aspect.name=\"mlModelFactorPrompts\"record MLModelFactorPrompts{/**What are foreseeable salient factors for which MLModel performance may vary, and how were these determined?*/relevantFactors:optional array[/**Factors affecting the performance of the MLModel.*/record MLModelFactors{/**Groups refers to distinct categories with similar characteristics that are present in the evaluation data instances.\nFor human-centric machine learning MLModels, groups are people who share one or multiple characteristics.*/groups:optional array[string]/**The performance of a MLModel can vary depending on what instruments were used to capture the input to the MLModel.\nFor example, a face detection model may perform differently depending on the camera's hardware and software,\nincluding lens, image stabilization, high dynamic range techniques, and background blurring for portrait mode.*/instrumentation:optional array[string]/**A further factor affecting MLModel performance is the environment in which it is deployed.*/environment:optional array[string]}]/**Which factors are being reported, and why were these chosen?*/evaluationFactors:optional array[MLModelFactors]}", SchemaFormatType.PDL);
    private MLModelFactorsArray _relevantFactorsField = null;
    private MLModelFactorsArray _evaluationFactorsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_RelevantFactors = SCHEMA.getField("relevantFactors");
    private static final RecordDataSchema.Field FIELD_EvaluationFactors = SCHEMA.getField("evaluationFactors");

    public MLModelFactorPrompts() {
        super(new DataMap(3, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public MLModelFactorPrompts(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasRelevantFactors() {
        if (this._relevantFactorsField != null) {
            return true;
        }
        return this._map.containsKey("relevantFactors");
    }

    public void removeRelevantFactors() {
        this._map.remove("relevantFactors");
    }

    @Nullable
    public MLModelFactorsArray getRelevantFactors(GetMode mode) {
        return this.getRelevantFactors();
    }

    @Nullable
    public MLModelFactorsArray getRelevantFactors() {
        if (this._relevantFactorsField != null) {
            return this._relevantFactorsField;
        }
        Object __rawValue = this._map.get("relevantFactors");
        this._relevantFactorsField = __rawValue == null ? null : new MLModelFactorsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._relevantFactorsField;
    }

    public MLModelFactorPrompts setRelevantFactors(@Nullable MLModelFactorsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelevantFactors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelevantFactors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relevantFactors", value.data());
                this._relevantFactorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relevantFactors", value.data());
                this._relevantFactorsField = value;
            }
        }
        return this;
    }

    public MLModelFactorPrompts setRelevantFactors(@Nonnull MLModelFactorsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relevantFactors of com.linkedin.ml.metadata.MLModelFactorPrompts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relevantFactors", value.data());
        this._relevantFactorsField = value;
        return this;
    }

    public boolean hasEvaluationFactors() {
        if (this._evaluationFactorsField != null) {
            return true;
        }
        return this._map.containsKey("evaluationFactors");
    }

    public void removeEvaluationFactors() {
        this._map.remove("evaluationFactors");
    }

    @Nullable
    public MLModelFactorsArray getEvaluationFactors(GetMode mode) {
        return this.getEvaluationFactors();
    }

    @Nullable
    public MLModelFactorsArray getEvaluationFactors() {
        if (this._evaluationFactorsField != null) {
            return this._evaluationFactorsField;
        }
        Object __rawValue = this._map.get("evaluationFactors");
        this._evaluationFactorsField = __rawValue == null ? null : new MLModelFactorsArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._evaluationFactorsField;
    }

    public MLModelFactorPrompts setEvaluationFactors(@Nullable MLModelFactorsArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEvaluationFactors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEvaluationFactors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "evaluationFactors", value.data());
                this._evaluationFactorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "evaluationFactors", value.data());
                this._evaluationFactorsField = value;
            }
        }
        return this;
    }

    public MLModelFactorPrompts setEvaluationFactors(@Nonnull MLModelFactorsArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field evaluationFactors of com.linkedin.ml.metadata.MLModelFactorPrompts to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "evaluationFactors", value.data());
        this._evaluationFactorsField = value;
        return this;
    }

    @Override
    public MLModelFactorPrompts clone() throws CloneNotSupportedException {
        MLModelFactorPrompts __clone = (MLModelFactorPrompts)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public MLModelFactorPrompts copy() throws CloneNotSupportedException {
        MLModelFactorPrompts __copy = (MLModelFactorPrompts)super.copy();
        __copy._evaluationFactorsField = null;
        __copy._relevantFactorsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final MLModelFactorPrompts __objectRef;

        private ChangeListener(MLModelFactorPrompts reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "evaluationFactors": {
                    this.__objectRef._evaluationFactorsField = null;
                    break;
                }
                case "relevantFactors": {
                    this.__objectRef._relevantFactorsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public MLModelFactorsArray.Fields relevantFactors() {
            return new MLModelFactorsArray.Fields(this.getPathComponents(), "relevantFactors");
        }

        public PathSpec relevantFactors(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "relevantFactors");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public MLModelFactorsArray.Fields evaluationFactors() {
            return new MLModelFactorsArray.Fields(this.getPathComponents(), "evaluationFactors");
        }

        public PathSpec evaluationFactors(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "evaluationFactors");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private MLModelFactorsArray.ProjectionMask _relevantFactorsMask;
        private MLModelFactorsArray.ProjectionMask _evaluationFactorsMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withRelevantFactors(Function<MLModelFactorsArray.ProjectionMask, MLModelFactorsArray.ProjectionMask> nestedMask) {
            this._relevantFactorsMask = nestedMask.apply(this._relevantFactorsMask == null ? MLModelFactorsArray.createMask() : this._relevantFactorsMask);
            this.getDataMap().put("relevantFactors", this._relevantFactorsMask.getDataMap());
            return this;
        }

        public ProjectionMask withRelevantFactors() {
            this._relevantFactorsMask = null;
            this.getDataMap().put("relevantFactors", 1);
            return this;
        }

        public ProjectionMask withRelevantFactors(Function<MLModelFactorsArray.ProjectionMask, MLModelFactorsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._relevantFactorsMask = nestedMask.apply(this._relevantFactorsMask == null ? MLModelFactorsArray.createMask() : this._relevantFactorsMask);
            this.getDataMap().put("relevantFactors", this._relevantFactorsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("relevantFactors").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relevantFactors").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRelevantFactors(Integer start, Integer count) {
            this._relevantFactorsMask = null;
            this.getDataMap().put("relevantFactors", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("relevantFactors").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("relevantFactors").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEvaluationFactors(Function<MLModelFactorsArray.ProjectionMask, MLModelFactorsArray.ProjectionMask> nestedMask) {
            this._evaluationFactorsMask = nestedMask.apply(this._evaluationFactorsMask == null ? MLModelFactorsArray.createMask() : this._evaluationFactorsMask);
            this.getDataMap().put("evaluationFactors", this._evaluationFactorsMask.getDataMap());
            return this;
        }

        public ProjectionMask withEvaluationFactors() {
            this._evaluationFactorsMask = null;
            this.getDataMap().put("evaluationFactors", 1);
            return this;
        }

        public ProjectionMask withEvaluationFactors(Function<MLModelFactorsArray.ProjectionMask, MLModelFactorsArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._evaluationFactorsMask = nestedMask.apply(this._evaluationFactorsMask == null ? MLModelFactorsArray.createMask() : this._evaluationFactorsMask);
            this.getDataMap().put("evaluationFactors", this._evaluationFactorsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("evaluationFactors").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("evaluationFactors").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withEvaluationFactors(Integer start, Integer count) {
            this._evaluationFactorsMask = null;
            this.getDataMap().put("evaluationFactors", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("evaluationFactors").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("evaluationFactors").put("$count", count);
            }
            return this;
        }
    }
}

