/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import java.util.List;

public class HyperParameterValueType
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[string,int,float,double,boolean]", SchemaFormatType.PDL);
    private String _stringMember = null;
    private Integer _intMember = null;
    private Float _floatMember = null;
    private Double _doubleMember = null;
    private Boolean _booleanMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_String = SCHEMA.getTypeByMemberKey("string");
    public static final String MEMBERKEY_String = "string";
    private static final DataSchema MEMBER_Int = SCHEMA.getTypeByMemberKey("int");
    public static final String MEMBERKEY_Int = "int";
    private static final DataSchema MEMBER_Float = SCHEMA.getTypeByMemberKey("float");
    public static final String MEMBERKEY_Float = "float";
    private static final DataSchema MEMBER_Double = SCHEMA.getTypeByMemberKey("double");
    public static final String MEMBERKEY_Double = "double";
    private static final DataSchema MEMBER_Boolean = SCHEMA.getTypeByMemberKey("boolean");
    public static final String MEMBERKEY_Boolean = "boolean";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public HyperParameterValueType() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public HyperParameterValueType(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static HyperParameterValueType create(String value) {
        HyperParameterValueType newUnion = new HyperParameterValueType();
        newUnion.setString(value);
        return newUnion;
    }

    public boolean isString() {
        return this.memberIs(MEMBERKEY_String);
    }

    public String getString() {
        this.checkNotNull();
        if (this._stringMember != null) {
            return this._stringMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_String);
        this._stringMember = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._stringMember;
    }

    public void setString(String value) {
        this.checkNotNull();
        this._map.clear();
        this._stringMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_String, value);
    }

    public static HyperParameterValueType create(Integer value) {
        HyperParameterValueType newUnion = new HyperParameterValueType();
        newUnion.setInt(value);
        return newUnion;
    }

    public boolean isInt() {
        return this.memberIs(MEMBERKEY_Int);
    }

    public Integer getInt() {
        this.checkNotNull();
        if (this._intMember != null) {
            return this._intMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Int);
        this._intMember = DataTemplateUtil.coerceIntOutput(__rawValue);
        return this._intMember;
    }

    public void setInt(Integer value) {
        this.checkNotNull();
        this._map.clear();
        this._intMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Int, DataTemplateUtil.coerceIntInput(value));
    }

    public static HyperParameterValueType create(Float value) {
        HyperParameterValueType newUnion = new HyperParameterValueType();
        newUnion.setFloat(value);
        return newUnion;
    }

    public boolean isFloat() {
        return this.memberIs(MEMBERKEY_Float);
    }

    public Float getFloat() {
        this.checkNotNull();
        if (this._floatMember != null) {
            return this._floatMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Float);
        this._floatMember = DataTemplateUtil.coerceFloatOutput(__rawValue);
        return this._floatMember;
    }

    public void setFloat(Float value) {
        this.checkNotNull();
        this._map.clear();
        this._floatMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Float, DataTemplateUtil.coerceFloatInput(value));
    }

    public static HyperParameterValueType create(Double value) {
        HyperParameterValueType newUnion = new HyperParameterValueType();
        newUnion.setDouble(value);
        return newUnion;
    }

    public boolean isDouble() {
        return this.memberIs(MEMBERKEY_Double);
    }

    public Double getDouble() {
        this.checkNotNull();
        if (this._doubleMember != null) {
            return this._doubleMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Double);
        this._doubleMember = DataTemplateUtil.coerceDoubleOutput(__rawValue);
        return this._doubleMember;
    }

    public void setDouble(Double value) {
        this.checkNotNull();
        this._map.clear();
        this._doubleMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Double, DataTemplateUtil.coerceDoubleInput(value));
    }

    public static HyperParameterValueType create(Boolean value) {
        HyperParameterValueType newUnion = new HyperParameterValueType();
        newUnion.setBoolean(value);
        return newUnion;
    }

    public boolean isBoolean() {
        return this.memberIs(MEMBERKEY_Boolean);
    }

    public Boolean getBoolean() {
        this.checkNotNull();
        if (this._booleanMember != null) {
            return this._booleanMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_Boolean);
        this._booleanMember = DataTemplateUtil.coerceBooleanOutput(__rawValue);
        return this._booleanMember;
    }

    public void setBoolean(Boolean value) {
        this.checkNotNull();
        this._map.clear();
        this._booleanMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_Boolean, value);
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public HyperParameterValueType clone() throws CloneNotSupportedException {
        HyperParameterValueType __clone = (HyperParameterValueType)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public HyperParameterValueType copy() throws CloneNotSupportedException {
        HyperParameterValueType __copy = (HyperParameterValueType)super.copy();
        __copy._booleanMember = null;
        __copy._stringMember = null;
        __copy._doubleMember = null;
        __copy._floatMember = null;
        __copy._intMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final HyperParameterValueType __objectRef;

        private ChangeListener(HyperParameterValueType reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "boolean": {
                    this.__objectRef._booleanMember = null;
                    break;
                }
                case "string": {
                    this.__objectRef._stringMember = null;
                    break;
                }
                case "double": {
                    this.__objectRef._doubleMember = null;
                    break;
                }
                case "float": {
                    this.__objectRef._floatMember = null;
                    break;
                }
                case "int": {
                    this.__objectRef._intMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withString() {
            this.getDataMap().put(HyperParameterValueType.MEMBERKEY_String, 1);
            return this;
        }

        public ProjectionMask withInt() {
            this.getDataMap().put(HyperParameterValueType.MEMBERKEY_Int, 1);
            return this;
        }

        public ProjectionMask withFloat() {
            this.getDataMap().put(HyperParameterValueType.MEMBERKEY_Float, 1);
            return this;
        }

        public ProjectionMask withDouble() {
            this.getDataMap().put(HyperParameterValueType.MEMBERKEY_Double, 1);
            return this;
        }

        public ProjectionMask withBoolean() {
            this.getDataMap().put(HyperParameterValueType.MEMBERKEY_Boolean, 1);
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**A union of all supported metadata aspects for HyperParameter Value*/typeref HyperParameterValueType=union[string,int,float,double,boolean]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec String() {
            return new PathSpec(this.getPathComponents(), HyperParameterValueType.MEMBERKEY_String);
        }

        public PathSpec Int() {
            return new PathSpec(this.getPathComponents(), HyperParameterValueType.MEMBERKEY_Int);
        }

        public PathSpec Float() {
            return new PathSpec(this.getPathComponents(), HyperParameterValueType.MEMBERKEY_Float);
        }

        public PathSpec Double() {
            return new PathSpec(this.getPathComponents(), HyperParameterValueType.MEMBERKEY_Double);
        }

        public PathSpec Boolean() {
            return new PathSpec(this.getPathComponents(), HyperParameterValueType.MEMBERKEY_Boolean);
        }
    }
}

