/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ml.metadata;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EthicalConsiderations
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ml.metadata/**This section is intended to demonstrate the ethical considerations that went into MLModel development, surfacing ethical challenges and solutions to stakeholders.*/@Aspect.name=\"mlModelEthicalConsiderations\"record EthicalConsiderations{/**Does the MLModel use any sensitive data (e.g., protected classes)?*/data:optional array[string]/** Is the MLModel intended to inform decisions about matters central to human life or flourishing - e.g., health or safety? Or could it be used in such a way?*/humanLife:optional array[string]/**What risk mitigation strategies were used during MLModel development?*/mitigations:optional array[string]/**What risks may be present in MLModel usage? Try to identify the potential recipients, likelihood, and magnitude of harms. If these cannot be determined, note that they were considered but remain unknown.*/risksAndHarms:optional array[string]/**Are there any known MLModel use cases that are especially fraught? This may connect directly to the intended use section*/useCases:optional array[string]}", SchemaFormatType.PDL);
    private StringArray _dataField = null;
    private StringArray _humanLifeField = null;
    private StringArray _mitigationsField = null;
    private StringArray _risksAndHarmsField = null;
    private StringArray _useCasesField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Data = SCHEMA.getField("data");
    private static final RecordDataSchema.Field FIELD_HumanLife = SCHEMA.getField("humanLife");
    private static final RecordDataSchema.Field FIELD_Mitigations = SCHEMA.getField("mitigations");
    private static final RecordDataSchema.Field FIELD_RisksAndHarms = SCHEMA.getField("risksAndHarms");
    private static final RecordDataSchema.Field FIELD_UseCases = SCHEMA.getField("useCases");

    public EthicalConsiderations() {
        super(new DataMap(7, 0.75f), SCHEMA, 7);
        this.addChangeListener(this.__changeListener);
    }

    public EthicalConsiderations(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasData() {
        if (this._dataField != null) {
            return true;
        }
        return this._map.containsKey("data");
    }

    public void removeData() {
        this._map.remove("data");
    }

    @Nullable
    public StringArray getData(GetMode mode) {
        return this.getData();
    }

    @Nullable
    public StringArray getData() {
        if (this._dataField != null) {
            return this._dataField;
        }
        Object __rawValue = this._map.get("data");
        this._dataField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._dataField;
    }

    public EthicalConsiderations setData(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setData(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeData();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "data", value.data());
                this._dataField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "data", value.data());
                this._dataField = value;
            }
        }
        return this;
    }

    public EthicalConsiderations setData(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field data of com.linkedin.ml.metadata.EthicalConsiderations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "data", value.data());
        this._dataField = value;
        return this;
    }

    public boolean hasHumanLife() {
        if (this._humanLifeField != null) {
            return true;
        }
        return this._map.containsKey("humanLife");
    }

    public void removeHumanLife() {
        this._map.remove("humanLife");
    }

    @Nullable
    public StringArray getHumanLife(GetMode mode) {
        return this.getHumanLife();
    }

    @Nullable
    public StringArray getHumanLife() {
        if (this._humanLifeField != null) {
            return this._humanLifeField;
        }
        Object __rawValue = this._map.get("humanLife");
        this._humanLifeField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._humanLifeField;
    }

    public EthicalConsiderations setHumanLife(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setHumanLife(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeHumanLife();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "humanLife", value.data());
                this._humanLifeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "humanLife", value.data());
                this._humanLifeField = value;
            }
        }
        return this;
    }

    public EthicalConsiderations setHumanLife(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field humanLife of com.linkedin.ml.metadata.EthicalConsiderations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "humanLife", value.data());
        this._humanLifeField = value;
        return this;
    }

    public boolean hasMitigations() {
        if (this._mitigationsField != null) {
            return true;
        }
        return this._map.containsKey("mitigations");
    }

    public void removeMitigations() {
        this._map.remove("mitigations");
    }

    @Nullable
    public StringArray getMitigations(GetMode mode) {
        return this.getMitigations();
    }

    @Nullable
    public StringArray getMitigations() {
        if (this._mitigationsField != null) {
            return this._mitigationsField;
        }
        Object __rawValue = this._map.get("mitigations");
        this._mitigationsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._mitigationsField;
    }

    public EthicalConsiderations setMitigations(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setMitigations(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeMitigations();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "mitigations", value.data());
                this._mitigationsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "mitigations", value.data());
                this._mitigationsField = value;
            }
        }
        return this;
    }

    public EthicalConsiderations setMitigations(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field mitigations of com.linkedin.ml.metadata.EthicalConsiderations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "mitigations", value.data());
        this._mitigationsField = value;
        return this;
    }

    public boolean hasRisksAndHarms() {
        if (this._risksAndHarmsField != null) {
            return true;
        }
        return this._map.containsKey("risksAndHarms");
    }

    public void removeRisksAndHarms() {
        this._map.remove("risksAndHarms");
    }

    @Nullable
    public StringArray getRisksAndHarms(GetMode mode) {
        return this.getRisksAndHarms();
    }

    @Nullable
    public StringArray getRisksAndHarms() {
        if (this._risksAndHarmsField != null) {
            return this._risksAndHarmsField;
        }
        Object __rawValue = this._map.get("risksAndHarms");
        this._risksAndHarmsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._risksAndHarmsField;
    }

    public EthicalConsiderations setRisksAndHarms(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRisksAndHarms(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRisksAndHarms();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "risksAndHarms", value.data());
                this._risksAndHarmsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "risksAndHarms", value.data());
                this._risksAndHarmsField = value;
            }
        }
        return this;
    }

    public EthicalConsiderations setRisksAndHarms(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field risksAndHarms of com.linkedin.ml.metadata.EthicalConsiderations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "risksAndHarms", value.data());
        this._risksAndHarmsField = value;
        return this;
    }

    public boolean hasUseCases() {
        if (this._useCasesField != null) {
            return true;
        }
        return this._map.containsKey("useCases");
    }

    public void removeUseCases() {
        this._map.remove("useCases");
    }

    @Nullable
    public StringArray getUseCases(GetMode mode) {
        return this.getUseCases();
    }

    @Nullable
    public StringArray getUseCases() {
        if (this._useCasesField != null) {
            return this._useCasesField;
        }
        Object __rawValue = this._map.get("useCases");
        this._useCasesField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._useCasesField;
    }

    public EthicalConsiderations setUseCases(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUseCases(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUseCases();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "useCases", value.data());
                this._useCasesField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "useCases", value.data());
                this._useCasesField = value;
            }
        }
        return this;
    }

    public EthicalConsiderations setUseCases(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field useCases of com.linkedin.ml.metadata.EthicalConsiderations to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "useCases", value.data());
        this._useCasesField = value;
        return this;
    }

    @Override
    public EthicalConsiderations clone() throws CloneNotSupportedException {
        EthicalConsiderations __clone = (EthicalConsiderations)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public EthicalConsiderations copy() throws CloneNotSupportedException {
        EthicalConsiderations __copy = (EthicalConsiderations)super.copy();
        __copy._useCasesField = null;
        __copy._dataField = null;
        __copy._risksAndHarmsField = null;
        __copy._mitigationsField = null;
        __copy._humanLifeField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final EthicalConsiderations __objectRef;

        private ChangeListener(EthicalConsiderations reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "useCases": {
                    this.__objectRef._useCasesField = null;
                    break;
                }
                case "data": {
                    this.__objectRef._dataField = null;
                    break;
                }
                case "risksAndHarms": {
                    this.__objectRef._risksAndHarmsField = null;
                    break;
                }
                case "mitigations": {
                    this.__objectRef._mitigationsField = null;
                    break;
                }
                case "humanLife": {
                    this.__objectRef._humanLifeField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec data() {
            return new PathSpec(this.getPathComponents(), "data");
        }

        public PathSpec data(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "data");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec humanLife() {
            return new PathSpec(this.getPathComponents(), "humanLife");
        }

        public PathSpec humanLife(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "humanLife");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec mitigations() {
            return new PathSpec(this.getPathComponents(), "mitigations");
        }

        public PathSpec mitigations(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "mitigations");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec risksAndHarms() {
            return new PathSpec(this.getPathComponents(), "risksAndHarms");
        }

        public PathSpec risksAndHarms(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "risksAndHarms");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public PathSpec useCases() {
            return new PathSpec(this.getPathComponents(), "useCases");
        }

        public PathSpec useCases(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "useCases");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withData() {
            this.getDataMap().put("data", 1);
            return this;
        }

        public ProjectionMask withData(Integer start, Integer count) {
            this.getDataMap().put("data", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("data").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("data").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withHumanLife() {
            this.getDataMap().put("humanLife", 1);
            return this;
        }

        public ProjectionMask withHumanLife(Integer start, Integer count) {
            this.getDataMap().put("humanLife", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("humanLife").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("humanLife").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withMitigations() {
            this.getDataMap().put("mitigations", 1);
            return this;
        }

        public ProjectionMask withMitigations(Integer start, Integer count) {
            this.getDataMap().put("mitigations", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("mitigations").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("mitigations").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withRisksAndHarms() {
            this.getDataMap().put("risksAndHarms", 1);
            return this;
        }

        public ProjectionMask withRisksAndHarms(Integer start, Integer count) {
            this.getDataMap().put("risksAndHarms", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("risksAndHarms").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("risksAndHarms").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withUseCases() {
            this.getDataMap().put("useCases", 1);
            return this;
        }

        public ProjectionMask withUseCases(Integer start, Integer count) {
            this.getDataMap().put("useCases", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("useCases").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("useCases").put("$count", count);
            }
            return this;
        }
    }
}

