/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.utils;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrencyUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConcurrencyUtils.class);

    private ConcurrencyUtils() {
    }

    public static <O, T> List<T> transformAndCollectAsync(List<O> originalList, Function<O, T> transformer) {
        return ConcurrencyUtils.transformAndCollectAsync(originalList, transformer, Collectors.toList());
    }

    public static <O, T, OUTPUT> OUTPUT transformAndCollectAsync(Collection<O> originalCollection, Function<O, T> transformer, Collector<T, ?, OUTPUT> collector) {
        return originalCollection.stream().map(element -> CompletableFuture.supplyAsync(() -> transformer.apply(element))).collect(Collectors.collectingAndThen(Collectors.toList(), completableFutureList -> completableFutureList.stream().map(CompletableFuture::join))).collect(collector);
    }

    public static <O, T> List<T> transformAndCollectAsync(List<O> originalList, Function<O, T> transformer, BiFunction<O, Throwable, ? extends T> exceptionHandler) {
        return ConcurrencyUtils.transformAndCollectAsync(originalList, transformer, exceptionHandler, Collectors.toList());
    }

    public static <O, T, OUTPUT> OUTPUT transformAndCollectAsync(Collection<O> originalCollection, Function<O, T> transformer, BiFunction<O, Throwable, ? extends T> exceptionHandler, Collector<T, ?, OUTPUT> collector) {
        return originalCollection.stream().map(element -> CompletableFuture.supplyAsync(() -> transformer.apply(element)).exceptionally(e -> exceptionHandler.apply((Object)element, (Throwable)e))).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.toList(), completableFutureList -> completableFutureList.stream().map(CompletableFuture::join))).collect(collector);
    }

    public static <T> List<T> getAllCompleted(List<CompletableFuture<T>> futuresList, long timeout, TimeUnit unit) {
        CompletableFuture<Void> allFuturesResult = CompletableFuture.allOf(futuresList.toArray(new CompletableFuture[0]));
        try {
            allFuturesResult.get(timeout, unit);
        }
        catch (Exception e) {
            log.info("Timed out while waiting for futures to complete");
        }
        return futuresList.stream().filter(future -> future.isDone() && !future.isCompletedExceptionally()).map(CompletableFuture::join).collect(Collectors.toList());
    }
}

