/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.run;

import com.linkedin.common.urn.Urn;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.Custom;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RelatedAspect
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.run/**Metadata about how an aspect is related to some urn*/record RelatedAspect{/** Urn of the entity that is referenced by the aspect.*/entity:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}aspect:string,relationship:string}", SchemaFormatType.PDL);
    private Urn _entityField = null;
    private String _aspectField = null;
    private String _relationshipField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Entity = SCHEMA.getField("entity");
    private static final RecordDataSchema.Field FIELD_Aspect = SCHEMA.getField("aspect");
    private static final RecordDataSchema.Field FIELD_Relationship = SCHEMA.getField("relationship");

    public RelatedAspect() {
        super(new DataMap(4, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public RelatedAspect(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasEntity() {
        if (this._entityField != null) {
            return true;
        }
        return this._map.containsKey("entity");
    }

    public void removeEntity() {
        this._map.remove("entity");
    }

    @Nullable
    public Urn getEntity(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getEntity();
            }
            case DEFAULT: 
            case NULL: {
                if (this._entityField != null) {
                    return this._entityField;
                }
                Object __rawValue = this._map.get("entity");
                this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
                return this._entityField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public Urn getEntity() {
        if (this._entityField != null) {
            return this._entityField;
        }
        Object __rawValue = this._map.get("entity");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("entity");
        }
        this._entityField = DataTemplateUtil.coerceCustomOutput(__rawValue, Urn.class);
        return this._entityField;
    }

    public RelatedAspect setEntity(@Nullable Urn value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntity(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field entity of com.linkedin.metadata.run.RelatedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntity();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
                this._entityField = value;
            }
        }
        return this;
    }

    public RelatedAspect setEntity(@Nonnull Urn value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entity of com.linkedin.metadata.run.RelatedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entity", DataTemplateUtil.coerceCustomInput(value, Urn.class));
        this._entityField = value;
        return this;
    }

    public boolean hasAspect() {
        if (this._aspectField != null) {
            return true;
        }
        return this._map.containsKey("aspect");
    }

    public void removeAspect() {
        this._map.remove("aspect");
    }

    @Nullable
    public String getAspect(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getAspect();
            }
            case DEFAULT: 
            case NULL: {
                if (this._aspectField != null) {
                    return this._aspectField;
                }
                Object __rawValue = this._map.get("aspect");
                this._aspectField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._aspectField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getAspect() {
        if (this._aspectField != null) {
            return this._aspectField;
        }
        Object __rawValue = this._map.get("aspect");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("aspect");
        }
        this._aspectField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._aspectField;
    }

    public RelatedAspect setAspect(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setAspect(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field aspect of com.linkedin.metadata.run.RelatedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeAspect();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "aspect", value);
                this._aspectField = value;
            }
        }
        return this;
    }

    public RelatedAspect setAspect(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field aspect of com.linkedin.metadata.run.RelatedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "aspect", value);
        this._aspectField = value;
        return this;
    }

    public boolean hasRelationship() {
        if (this._relationshipField != null) {
            return true;
        }
        return this._map.containsKey("relationship");
    }

    public void removeRelationship() {
        this._map.remove("relationship");
    }

    @Nullable
    public String getRelationship(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getRelationship();
            }
            case DEFAULT: 
            case NULL: {
                if (this._relationshipField != null) {
                    return this._relationshipField;
                }
                Object __rawValue = this._map.get("relationship");
                this._relationshipField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._relationshipField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getRelationship() {
        if (this._relationshipField != null) {
            return this._relationshipField;
        }
        Object __rawValue = this._map.get("relationship");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("relationship");
        }
        this._relationshipField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._relationshipField;
    }

    public RelatedAspect setRelationship(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setRelationship(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field relationship of com.linkedin.metadata.run.RelatedAspect");
                }
                CheckedUtil.putWithoutChecking(this._map, "relationship", value);
                this._relationshipField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeRelationship();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "relationship", value);
                this._relationshipField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "relationship", value);
                this._relationshipField = value;
            }
        }
        return this;
    }

    public RelatedAspect setRelationship(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field relationship of com.linkedin.metadata.run.RelatedAspect to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "relationship", value);
        this._relationshipField = value;
        return this;
    }

    @Override
    public RelatedAspect clone() throws CloneNotSupportedException {
        RelatedAspect __clone = (RelatedAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RelatedAspect copy() throws CloneNotSupportedException {
        RelatedAspect __copy = (RelatedAspect)super.copy();
        __copy._aspectField = null;
        __copy._relationshipField = null;
        __copy._entityField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        Custom.initializeCustomClass(Urn.class);
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RelatedAspect __objectRef;

        private ChangeListener(RelatedAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "aspect": {
                    this.__objectRef._aspectField = null;
                    break;
                }
                case "relationship": {
                    this.__objectRef._relationshipField = null;
                    break;
                }
                case "entity": {
                    this.__objectRef._entityField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec entity() {
            return new PathSpec(this.getPathComponents(), "entity");
        }

        public PathSpec aspect() {
            return new PathSpec(this.getPathComponents(), "aspect");
        }

        public PathSpec relationship() {
            return new PathSpec(this.getPathComponents(), "relationship");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withEntity() {
            this.getDataMap().put("entity", 1);
            return this;
        }

        public ProjectionMask withAspect() {
            this.getDataMap().put("aspect", 1);
            return this;
        }

        public ProjectionMask withRelationship() {
            this.getDataMap().put("relationship", 1);
            return this;
        }
    }
}

