/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.recommendation;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.recommendation.EntityRequestContext;
import com.linkedin.metadata.recommendation.ScenarioType;
import com.linkedin.metadata.recommendation.SearchRequestContext;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecommendationRequestContext
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.recommendation/**Context that defines the page requesting recommendations\ni.e. for search pages, the query/filters. for entity pages, the entity urn and tab*/record RecommendationRequestContext{/**Scenario in which the recommendations will be displayed*/scenario:/**Type of the scenario requesting recommendation*/enum ScenarioType{/**Recommendations to show on the users home page*/HOME/**Recommendations to show on the search results page*/SEARCH_RESULTS/**Recommendations to show on an Entity Profile page*/ENTITY_PROFILE/**Recommendations to show on the search bar when clicked*/SEARCH_BAR}/**Additional context for defining the search page requesting recommendations*/searchRequestContext:optional/**Context that defines a search page requesting recommendations*/record SearchRequestContext{/**Search query*/query:string/**filters applied to search results*/filters:array[{namespace com.linkedin.metadata.query.filter/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}}]=[]}/**Additional context for defining the entity page requesting recommendations*/entityRequestContext:optional/**Context that defines an entity page requesting recommendations*/record EntityRequestContext{/**Type of the entity being displayed*/type:string/**Urn of the entity being displayed*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}}", SchemaFormatType.PDL);
    private ScenarioType _scenarioField = null;
    private SearchRequestContext _searchRequestContextField = null;
    private EntityRequestContext _entityRequestContextField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Scenario = SCHEMA.getField("scenario");
    private static final RecordDataSchema.Field FIELD_SearchRequestContext = SCHEMA.getField("searchRequestContext");
    private static final RecordDataSchema.Field FIELD_EntityRequestContext = SCHEMA.getField("entityRequestContext");

    public RecommendationRequestContext() {
        super(new DataMap(4, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public RecommendationRequestContext(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasScenario() {
        if (this._scenarioField != null) {
            return true;
        }
        return this._map.containsKey("scenario");
    }

    public void removeScenario() {
        this._map.remove("scenario");
    }

    @Nullable
    public ScenarioType getScenario(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getScenario();
            }
            case DEFAULT: 
            case NULL: {
                if (this._scenarioField != null) {
                    return this._scenarioField;
                }
                Object __rawValue = this._map.get("scenario");
                this._scenarioField = DataTemplateUtil.coerceEnumOutput(__rawValue, ScenarioType.class, ScenarioType.$UNKNOWN);
                return this._scenarioField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public ScenarioType getScenario() {
        if (this._scenarioField != null) {
            return this._scenarioField;
        }
        Object __rawValue = this._map.get("scenario");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("scenario");
        }
        this._scenarioField = DataTemplateUtil.coerceEnumOutput(__rawValue, ScenarioType.class, ScenarioType.$UNKNOWN);
        return this._scenarioField;
    }

    public RecommendationRequestContext setScenario(@Nullable ScenarioType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setScenario(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field scenario of com.linkedin.metadata.recommendation.RecommendationRequestContext");
                }
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeScenario();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
                this._scenarioField = value;
            }
        }
        return this;
    }

    public RecommendationRequestContext setScenario(@Nonnull ScenarioType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field scenario of com.linkedin.metadata.recommendation.RecommendationRequestContext to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "scenario", value.name());
        this._scenarioField = value;
        return this;
    }

    public boolean hasSearchRequestContext() {
        if (this._searchRequestContextField != null) {
            return true;
        }
        return this._map.containsKey("searchRequestContext");
    }

    public void removeSearchRequestContext() {
        this._map.remove("searchRequestContext");
    }

    @Nullable
    public SearchRequestContext getSearchRequestContext(GetMode mode) {
        return this.getSearchRequestContext();
    }

    @Nullable
    public SearchRequestContext getSearchRequestContext() {
        if (this._searchRequestContextField != null) {
            return this._searchRequestContextField;
        }
        Object __rawValue = this._map.get("searchRequestContext");
        this._searchRequestContextField = __rawValue == null ? null : new SearchRequestContext(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._searchRequestContextField;
    }

    public RecommendationRequestContext setSearchRequestContext(@Nullable SearchRequestContext value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSearchRequestContext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSearchRequestContext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "searchRequestContext", value.data());
                this._searchRequestContextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "searchRequestContext", value.data());
                this._searchRequestContextField = value;
            }
        }
        return this;
    }

    public RecommendationRequestContext setSearchRequestContext(@Nonnull SearchRequestContext value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field searchRequestContext of com.linkedin.metadata.recommendation.RecommendationRequestContext to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "searchRequestContext", value.data());
        this._searchRequestContextField = value;
        return this;
    }

    public boolean hasEntityRequestContext() {
        if (this._entityRequestContextField != null) {
            return true;
        }
        return this._map.containsKey("entityRequestContext");
    }

    public void removeEntityRequestContext() {
        this._map.remove("entityRequestContext");
    }

    @Nullable
    public EntityRequestContext getEntityRequestContext(GetMode mode) {
        return this.getEntityRequestContext();
    }

    @Nullable
    public EntityRequestContext getEntityRequestContext() {
        if (this._entityRequestContextField != null) {
            return this._entityRequestContextField;
        }
        Object __rawValue = this._map.get("entityRequestContext");
        this._entityRequestContextField = __rawValue == null ? null : new EntityRequestContext(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._entityRequestContextField;
    }

    public RecommendationRequestContext setEntityRequestContext(@Nullable EntityRequestContext value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityRequestContext(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityRequestContext();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityRequestContext", value.data());
                this._entityRequestContextField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityRequestContext", value.data());
                this._entityRequestContextField = value;
            }
        }
        return this;
    }

    public RecommendationRequestContext setEntityRequestContext(@Nonnull EntityRequestContext value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityRequestContext of com.linkedin.metadata.recommendation.RecommendationRequestContext to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityRequestContext", value.data());
        this._entityRequestContextField = value;
        return this;
    }

    @Override
    public RecommendationRequestContext clone() throws CloneNotSupportedException {
        RecommendationRequestContext __clone = (RecommendationRequestContext)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RecommendationRequestContext copy() throws CloneNotSupportedException {
        RecommendationRequestContext __copy = (RecommendationRequestContext)super.copy();
        __copy._scenarioField = null;
        __copy._searchRequestContextField = null;
        __copy._entityRequestContextField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RecommendationRequestContext __objectRef;

        private ChangeListener(RecommendationRequestContext reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "scenario": {
                    this.__objectRef._scenarioField = null;
                    break;
                }
                case "searchRequestContext": {
                    this.__objectRef._searchRequestContextField = null;
                    break;
                }
                case "entityRequestContext": {
                    this.__objectRef._entityRequestContextField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec scenario() {
            return new PathSpec(this.getPathComponents(), "scenario");
        }

        public SearchRequestContext.Fields searchRequestContext() {
            return new SearchRequestContext.Fields(this.getPathComponents(), "searchRequestContext");
        }

        public EntityRequestContext.Fields entityRequestContext() {
            return new EntityRequestContext.Fields(this.getPathComponents(), "entityRequestContext");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SearchRequestContext.ProjectionMask _searchRequestContextMask;
        private EntityRequestContext.ProjectionMask _entityRequestContextMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withScenario() {
            this.getDataMap().put("scenario", 1);
            return this;
        }

        public ProjectionMask withSearchRequestContext(Function<SearchRequestContext.ProjectionMask, SearchRequestContext.ProjectionMask> nestedMask) {
            this._searchRequestContextMask = nestedMask.apply(this._searchRequestContextMask == null ? SearchRequestContext.createMask() : this._searchRequestContextMask);
            this.getDataMap().put("searchRequestContext", this._searchRequestContextMask.getDataMap());
            return this;
        }

        public ProjectionMask withSearchRequestContext() {
            this._searchRequestContextMask = null;
            this.getDataMap().put("searchRequestContext", 1);
            return this;
        }

        public ProjectionMask withEntityRequestContext(Function<EntityRequestContext.ProjectionMask, EntityRequestContext.ProjectionMask> nestedMask) {
            this._entityRequestContextMask = nestedMask.apply(this._entityRequestContextMask == null ? EntityRequestContext.createMask() : this._entityRequestContextMask);
            this.getDataMap().put("entityRequestContext", this._entityRequestContextMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntityRequestContext() {
            this._entityRequestContextMask = null;
            this.getDataMap().put("entityRequestContext", 1);
            return this;
        }
    }
}

