/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.recommendation;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.metadata.recommendation.ContentParams;
import com.linkedin.metadata.recommendation.EntityProfileParams;
import com.linkedin.metadata.recommendation.SearchParams;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecommendationParams
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.recommendation/**Parameters required to render a recommendation of a given type*/record RecommendationParams{/**Context to define the search recommendations*/searchParams:optional/**Context to define the search recommendations*/record SearchParams{/**Entity types to be searched. If this is not provided, all entities will be searched.*/types:array[string]=[]/**Search query*/query:string/**Filters*/filters:array[{namespace com.linkedin.metadata.query.filter/**A criterion for matching a field with given value*/record Criterion{/**The name of the field that the criterion refers to*/field:string/**The value of the intended field*/value:string/**Values. one of which the intended field should match\nNote, if values is set, the above \"value\" field will be ignored*/values:array[string]=[]/**The condition for the criterion, e.g. EQUAL, START_WITH*/condition:/**The matching condition in a filter criterion*/enum Condition{/**Represent the relation: String field contains value, e.g. name contains Profile*/CONTAIN/**Represent the relation: String field ends with value, e.g. name ends with Event*/END_WITH/**Represent the relation: field = value, e.g. platform = hdfs*/EQUAL/**Represent the relation: field = value and support case insensitive values, e.g. platform = hdfs*/IEQUAL/**Represent the relation: field is null, e.g. platform is null*/IS_NULL/**Represents the relation: field exists and is non-empty, e.g. owners is not null and != [] (empty)*/EXISTS/**Represent the relation greater than, e.g. ownerCount > 5*/GREATER_THAN/**Represent the relation greater than or equal to, e.g. ownerCount >= 5*/GREATER_THAN_OR_EQUAL_TO/**Represent the relation: String field is one of the array values to, e.g. name in [\"Profile\", \"Event\"]*/IN/**Represent the relation less than, e.g. ownerCount < 3*/LESS_THAN/**Represent the relation less than or equal to, e.g. ownerCount <= 3*/LESS_THAN_OR_EQUAL_TO/**Represent the relation: String field starts with value, e.g. name starts with PageView*/START_WITH/**Represent the relation: URN field any nested children in addition to the given URN*/DESCENDANTS_INCL/**Represent the relation: URN field matches any nested parent in addition to the given URN*/ANCESTORS_INCL/**Represent the relation: URN field matches any nested child or parent in addition to the given URN*/RELATED_INCL}=\"EQUAL\"/**Whether the condition should be negated*/negated:boolean=false}}]=[]}/**Context to define the entity profile page*/entityProfileParams:optional/**Context to define the entity profile page*/record EntityProfileParams{/**Urn of the entity being shown*/urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Context about the recommendation*/contentParams:optional/**Params about the recommended content*/record ContentParams{/**Number of entities corresponding to the recommended content*/count:long}}", SchemaFormatType.PDL);
    private SearchParams _searchParamsField = null;
    private EntityProfileParams _entityProfileParamsField = null;
    private ContentParams _contentParamsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_SearchParams = SCHEMA.getField("searchParams");
    private static final RecordDataSchema.Field FIELD_EntityProfileParams = SCHEMA.getField("entityProfileParams");
    private static final RecordDataSchema.Field FIELD_ContentParams = SCHEMA.getField("contentParams");

    public RecommendationParams() {
        super(new DataMap(4, 0.75f), SCHEMA, 4);
        this.addChangeListener(this.__changeListener);
    }

    public RecommendationParams(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasSearchParams() {
        if (this._searchParamsField != null) {
            return true;
        }
        return this._map.containsKey("searchParams");
    }

    public void removeSearchParams() {
        this._map.remove("searchParams");
    }

    @Nullable
    public SearchParams getSearchParams(GetMode mode) {
        return this.getSearchParams();
    }

    @Nullable
    public SearchParams getSearchParams() {
        if (this._searchParamsField != null) {
            return this._searchParamsField;
        }
        Object __rawValue = this._map.get("searchParams");
        this._searchParamsField = __rawValue == null ? null : new SearchParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._searchParamsField;
    }

    public RecommendationParams setSearchParams(@Nullable SearchParams value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setSearchParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeSearchParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "searchParams", value.data());
                this._searchParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "searchParams", value.data());
                this._searchParamsField = value;
            }
        }
        return this;
    }

    public RecommendationParams setSearchParams(@Nonnull SearchParams value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field searchParams of com.linkedin.metadata.recommendation.RecommendationParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "searchParams", value.data());
        this._searchParamsField = value;
        return this;
    }

    public boolean hasEntityProfileParams() {
        if (this._entityProfileParamsField != null) {
            return true;
        }
        return this._map.containsKey("entityProfileParams");
    }

    public void removeEntityProfileParams() {
        this._map.remove("entityProfileParams");
    }

    @Nullable
    public EntityProfileParams getEntityProfileParams(GetMode mode) {
        return this.getEntityProfileParams();
    }

    @Nullable
    public EntityProfileParams getEntityProfileParams() {
        if (this._entityProfileParamsField != null) {
            return this._entityProfileParamsField;
        }
        Object __rawValue = this._map.get("entityProfileParams");
        this._entityProfileParamsField = __rawValue == null ? null : new EntityProfileParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._entityProfileParamsField;
    }

    public RecommendationParams setEntityProfileParams(@Nullable EntityProfileParams value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setEntityProfileParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeEntityProfileParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "entityProfileParams", value.data());
                this._entityProfileParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "entityProfileParams", value.data());
                this._entityProfileParamsField = value;
            }
        }
        return this;
    }

    public RecommendationParams setEntityProfileParams(@Nonnull EntityProfileParams value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field entityProfileParams of com.linkedin.metadata.recommendation.RecommendationParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "entityProfileParams", value.data());
        this._entityProfileParamsField = value;
        return this;
    }

    public boolean hasContentParams() {
        if (this._contentParamsField != null) {
            return true;
        }
        return this._map.containsKey("contentParams");
    }

    public void removeContentParams() {
        this._map.remove("contentParams");
    }

    @Nullable
    public ContentParams getContentParams(GetMode mode) {
        return this.getContentParams();
    }

    @Nullable
    public ContentParams getContentParams() {
        if (this._contentParamsField != null) {
            return this._contentParamsField;
        }
        Object __rawValue = this._map.get("contentParams");
        this._contentParamsField = __rawValue == null ? null : new ContentParams(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._contentParamsField;
    }

    public RecommendationParams setContentParams(@Nullable ContentParams value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setContentParams(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeContentParams();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "contentParams", value.data());
                this._contentParamsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "contentParams", value.data());
                this._contentParamsField = value;
            }
        }
        return this;
    }

    public RecommendationParams setContentParams(@Nonnull ContentParams value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field contentParams of com.linkedin.metadata.recommendation.RecommendationParams to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "contentParams", value.data());
        this._contentParamsField = value;
        return this;
    }

    @Override
    public RecommendationParams clone() throws CloneNotSupportedException {
        RecommendationParams __clone = (RecommendationParams)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public RecommendationParams copy() throws CloneNotSupportedException {
        RecommendationParams __copy = (RecommendationParams)super.copy();
        __copy._entityProfileParamsField = null;
        __copy._contentParamsField = null;
        __copy._searchParamsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final RecommendationParams __objectRef;

        private ChangeListener(RecommendationParams reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "entityProfileParams": {
                    this.__objectRef._entityProfileParamsField = null;
                    break;
                }
                case "contentParams": {
                    this.__objectRef._contentParamsField = null;
                    break;
                }
                case "searchParams": {
                    this.__objectRef._searchParamsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public SearchParams.Fields searchParams() {
            return new SearchParams.Fields(this.getPathComponents(), "searchParams");
        }

        public EntityProfileParams.Fields entityProfileParams() {
            return new EntityProfileParams.Fields(this.getPathComponents(), "entityProfileParams");
        }

        public ContentParams.Fields contentParams() {
            return new ContentParams.Fields(this.getPathComponents(), "contentParams");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private SearchParams.ProjectionMask _searchParamsMask;
        private EntityProfileParams.ProjectionMask _entityProfileParamsMask;
        private ContentParams.ProjectionMask _contentParamsMask;

        ProjectionMask() {
            super(4);
        }

        public ProjectionMask withSearchParams(Function<SearchParams.ProjectionMask, SearchParams.ProjectionMask> nestedMask) {
            this._searchParamsMask = nestedMask.apply(this._searchParamsMask == null ? SearchParams.createMask() : this._searchParamsMask);
            this.getDataMap().put("searchParams", this._searchParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withSearchParams() {
            this._searchParamsMask = null;
            this.getDataMap().put("searchParams", 1);
            return this;
        }

        public ProjectionMask withEntityProfileParams(Function<EntityProfileParams.ProjectionMask, EntityProfileParams.ProjectionMask> nestedMask) {
            this._entityProfileParamsMask = nestedMask.apply(this._entityProfileParamsMask == null ? EntityProfileParams.createMask() : this._entityProfileParamsMask);
            this.getDataMap().put("entityProfileParams", this._entityProfileParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withEntityProfileParams() {
            this._entityProfileParamsMask = null;
            this.getDataMap().put("entityProfileParams", 1);
            return this;
        }

        public ProjectionMask withContentParams(Function<ContentParams.ProjectionMask, ContentParams.ProjectionMask> nestedMask) {
            this._contentParamsMask = nestedMask.apply(this._contentParamsMask == null ? ContentParams.createMask() : this._contentParamsMask);
            this.getDataMap().put("contentParams", this._contentParamsMask.getDataMap());
            return this;
        }

        public ProjectionMask withContentParams() {
            this._contentParamsMask = null;
            this.getDataMap().put("contentParams", 1);
            return this;
        }
    }
}

