/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.registry;

import com.linkedin.metadata.aspect.plugins.PluginFactory;
import com.linkedin.metadata.aspect.plugins.config.PluginConfiguration;
import com.linkedin.metadata.models.registry.EntityRegistry;
import com.linkedin.metadata.models.registry.EntityRegistryException;
import com.linkedin.metadata.models.registry.MergedEntityRegistry;
import com.linkedin.metadata.models.registry.PatchEntityRegistry;
import com.linkedin.metadata.models.registry.config.EntityRegistryLoadResult;
import com.linkedin.metadata.models.registry.config.LoadStatus;
import com.linkedin.util.Pair;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginEntityRegistryLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginEntityRegistryLoader.class);
    private static int _MAXLOADFAILURES = 5;
    private final Boolean scanningEnabled;
    private final String pluginDirectory;
    private final int loadDelaySeconds;
    private final Map<String, Map<ComparableVersion, Pair<EntityRegistry, EntityRegistryLoadResult>>> patchRegistries;
    private MergedEntityRegistry mergedEntityRegistry;
    @Nullable
    private final BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider;
    private boolean started = false;
    private final Lock lock = new ReentrantLock();
    private final Condition initialized = this.lock.newCondition();
    private boolean booted = false;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    public PluginEntityRegistryLoader(String pluginDirectory, int loadDelaySeconds, @Nullable BiFunction<PluginConfiguration, List<ClassLoader>, PluginFactory> pluginFactoryProvider) {
        File directory = new File(pluginDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            log.warn("{} directory does not exist or is not a directory. Plugin scanning will be disabled.", (Object)directory);
            this.scanningEnabled = false;
        } else {
            this.scanningEnabled = true;
        }
        this.pluginDirectory = pluginDirectory;
        this.patchRegistries = new HashMap<String, Map<ComparableVersion, Pair<EntityRegistry, EntityRegistryLoadResult>>>();
        this.loadDelaySeconds = loadDelaySeconds;
        this.pluginFactoryProvider = pluginFactoryProvider;
    }

    public Map<String, Map<ComparableVersion, Pair<EntityRegistry, EntityRegistryLoadResult>>> getPatchRegistries() {
        return this.patchRegistries;
    }

    public PluginEntityRegistryLoader withBaseRegistry(MergedEntityRegistry baseEntityRegistry) {
        this.mergedEntityRegistry = baseEntityRegistry;
        return this;
    }

    public PluginEntityRegistryLoader start(boolean waitForInitialization) throws InterruptedException {
        if (this.started) {
            log.warn("Already started!. Skipping");
            return this;
        }
        if (!this.scanningEnabled.booleanValue()) {
            return this;
        }
        this.executorService.scheduleAtFixedRate(() -> {
            this.lock.lock();
            try {
                Path rootPath = Paths.get(this.pluginDirectory, new String[0]);
                int rootDepth = rootPath.getNameCount();
                List paths = Files.walk(rootPath, 2, new FileVisitOption[0]).filter(x -> x.getNameCount() - rootDepth == 2).collect(Collectors.toList());
                log.debug("Size of list {}", (Object)paths.size());
                log.debug("Paths : {}", (Object)paths.stream().map(x -> x.toString() + ";").collect(Collectors.joining()));
                List<Path> versionedPaths = paths.stream().filter(path -> {
                    try {
                        ComparableVersion comparableVersion = new ComparableVersion(path.getName(rootDepth + 1).toString());
                        return true;
                    }
                    catch (Exception e) {
                        log.warn(String.format("Will skip %s since we weren't able to parse a legal version from it", path.toString()));
                        return false;
                    }
                }).sorted((path1, path2) -> {
                    if (path1.getName(rootDepth).equals(path2.getName(rootDepth))) {
                        return new ComparableVersion(path1.getName(rootDepth + 1).toString()).compareTo(new ComparableVersion(path2.getName(rootDepth + 1).toString()));
                    }
                    return path1.getName(rootDepth).compareTo(path2.getName(rootDepth));
                }).collect(Collectors.toList());
                log.debug("Will be loading paths in this order {}", (Object)versionedPaths.stream().map(p -> p.toString()).collect(Collectors.joining(";")));
                versionedPaths.forEach(x -> this.loadOneRegistry(this.mergedEntityRegistry, x.getName(rootDepth).toString(), x.getName(rootDepth + 1).toString(), x.toString()));
            }
            catch (Exception e) {
                log.warn("Failed to walk directory with exception", e);
            }
            finally {
                this.booted = true;
                this.initialized.signal();
                this.lock.unlock();
            }
        }, 0L, this.loadDelaySeconds, TimeUnit.SECONDS);
        this.started = true;
        if (waitForInitialization) {
            this.lock.lock();
            try {
                while (!this.booted) {
                    this.initialized.await(100L, TimeUnit.SECONDS);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this;
    }

    private void loadOneRegistry(MergedEntityRegistry parentRegistry, String registryName, String registryVersionStr, String patchDirectory) {
        ComparableVersion registryVersion = new ComparableVersion("0.0.0-dev");
        try {
            ComparableVersion maybeVersion = new ComparableVersion(registryVersionStr);
            log.debug("{}: Found registry version {}", (Object)this, (Object)maybeVersion);
            registryVersion = maybeVersion;
        }
        catch (IllegalArgumentException ie) {
            log.warn("Found un-parseable registry version {}, will default to {}", (Object)registryVersionStr, (Object)registryVersion);
        }
        if (this.registryExists(registryName, registryVersion)) {
            log.debug("Registry {}:{} already exists. Skipping loading...", (Object)registryName, (Object)registryVersion);
            return;
        }
        log.info("{}: Registry {}:{} discovered. Loading...", this, registryName, registryVersion);
        EntityRegistryLoadResult.EntityRegistryLoadResultBuilder loadResultBuilder = EntityRegistryLoadResult.builder().registryLocation(patchDirectory);
        PatchEntityRegistry entityRegistry = null;
        try {
            entityRegistry = new PatchEntityRegistry(patchDirectory, registryName, registryVersion, this.pluginFactoryProvider);
            parentRegistry.apply(entityRegistry);
            loadResultBuilder.loadResult(LoadStatus.SUCCESS);
            loadResultBuilder.plugins(entityRegistry.getPluginFactory().getPluginLoadResult());
            log.info("Loaded registry {} successfully", (Object)entityRegistry);
        }
        catch (EntityRegistryException | Exception e) {
            log.error("{}: Failed to load registry {} with {}", this, registryName, e.getMessage(), e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            loadResultBuilder.loadResult(LoadStatus.FAILURE).failureReason(sw.toString()).failureCount(1);
        }
        this.addLoadResult(registryName, registryVersion, loadResultBuilder.build(), entityRegistry);
    }

    private boolean registryExists(String registryName, ComparableVersion registryVersion) {
        Map nameTree = this.patchRegistries.getOrDefault(registryName, new HashMap());
        return nameTree.containsKey(registryVersion) && (((EntityRegistryLoadResult)((Pair)nameTree.get(registryVersion)).getSecond()).getLoadResult() == LoadStatus.SUCCESS || ((EntityRegistryLoadResult)((Pair)nameTree.get(registryVersion)).getSecond()).getFailureCount() == _MAXLOADFAILURES);
    }

    private void addLoadResult(String registryName, ComparableVersion semanticVersion, EntityRegistryLoadResult loadResult, EntityRegistry e) {
        Map nameTree = this.patchRegistries.getOrDefault(registryName, new HashMap());
        if (nameTree.containsKey(semanticVersion)) {
            if (loadResult.getLoadResult() == LoadStatus.FAILURE && ((EntityRegistryLoadResult)((Pair)nameTree.get(semanticVersion)).getSecond()).getLoadResult() == LoadStatus.FAILURE) {
                loadResult.setFailureCount(((EntityRegistryLoadResult)((Pair)nameTree.get(semanticVersion)).getSecond()).getFailureCount() + 1);
                if (loadResult.getFailureCount() == _MAXLOADFAILURES) {
                    log.error("Tried {} times. Failed to load registry {} with {}", loadResult.getFailureCount(), registryName, loadResult.getFailureReason());
                }
            }
            log.warn(String.format("Attempt %d to re-load registry %s: %s", loadResult.getFailureCount(), registryName, semanticVersion));
        }
        nameTree.put(semanticVersion, new Pair<EntityRegistry, EntityRegistryLoadResult>(e, loadResult));
        this.patchRegistries.put(registryName, nameTree);
    }
}

