/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models.annotation;

import com.linkedin.data.schema.DataSchema;
import com.linkedin.metadata.models.ModelValidationException;
import com.linkedin.metadata.models.annotation.AnnotationUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;

public final class TimeseriesFieldAnnotation {
    public static final String ANNOTATION_NAME = "TimeseriesField";
    private final String statName;
    private final AggregationType aggregationType;
    private final FieldType fieldType;

    @Nonnull
    public static TimeseriesFieldAnnotation fromPegasusAnnotationObject(@Nonnull Object annotationObj, @Nonnull String schemaFieldName, @Nonnull DataSchema.Type schemaDataType, @Nonnull String context) {
        if (!Map.class.isAssignableFrom(annotationObj.getClass())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid value type provided (Expected Map)", ANNOTATION_NAME, context));
        }
        Map map = (Map)annotationObj;
        Optional<String> statName = AnnotationUtils.getField(map, "name", String.class);
        Optional<String> aggregationType = AnnotationUtils.getField(map, "aggregationType", String.class);
        Optional<String> fieldType = AnnotationUtils.getField(map, "fieldType", String.class);
        if (fieldType.isPresent() && !EnumUtils.isValidEnum(FieldType.class, fieldType.get())) {
            throw new ModelValidationException(String.format("Failed to validate @%s annotation declared at %s: Invalid field 'fieldType'. Invalid fieldType provided. Valid types are %s", ANNOTATION_NAME, context, Arrays.toString((Object[])FieldType.values())));
        }
        FieldType resolvedFieldType = TimeseriesFieldAnnotation.getFieldType(fieldType, schemaDataType);
        return new TimeseriesFieldAnnotation(statName.orElse(schemaFieldName), aggregationType.map(AggregationType::valueOf).orElse(AggregationType.LATEST), resolvedFieldType);
    }

    private static FieldType getFieldType(Optional<String> maybeFieldType, DataSchema.Type schemaDataType) {
        if (!maybeFieldType.isPresent()) {
            return TimeseriesFieldAnnotation.getDefaultFieldType(schemaDataType);
        }
        return FieldType.valueOf(maybeFieldType.get());
    }

    private static FieldType getDefaultFieldType(DataSchema.Type schemaDataType) {
        switch (schemaDataType) {
            case INT: {
                return FieldType.INT;
            }
            case LONG: {
                return FieldType.LONG;
            }
            case FLOAT: {
                return FieldType.FLOAT;
            }
            case DOUBLE: {
                return FieldType.DOUBLE;
            }
        }
        return FieldType.KEYWORD;
    }

    @Generated
    public TimeseriesFieldAnnotation(String statName, AggregationType aggregationType, FieldType fieldType) {
        this.statName = statName;
        this.aggregationType = aggregationType;
        this.fieldType = fieldType;
    }

    @Generated
    public String getStatName() {
        return this.statName;
    }

    @Generated
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Generated
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeseriesFieldAnnotation)) {
            return false;
        }
        TimeseriesFieldAnnotation other = (TimeseriesFieldAnnotation)o;
        String this$statName = this.getStatName();
        String other$statName = other.getStatName();
        if (this$statName == null ? other$statName != null : !this$statName.equals(other$statName)) {
            return false;
        }
        AggregationType this$aggregationType = this.getAggregationType();
        AggregationType other$aggregationType = other.getAggregationType();
        if (this$aggregationType == null ? other$aggregationType != null : !((Object)((Object)this$aggregationType)).equals((Object)other$aggregationType)) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        return !(this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $statName = this.getStatName();
        result = result * 59 + ($statName == null ? 43 : $statName.hashCode());
        AggregationType $aggregationType = this.getAggregationType();
        result = result * 59 + ($aggregationType == null ? 43 : ((Object)((Object)$aggregationType)).hashCode());
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeseriesFieldAnnotation(statName=" + this.getStatName() + ", aggregationType=" + String.valueOf((Object)this.getAggregationType()) + ", fieldType=" + String.valueOf((Object)this.getFieldType()) + ")";
    }

    public static enum FieldType {
        DATETIME,
        KEYWORD,
        DOUBLE,
        INT,
        FLOAT,
        LONG;

    }

    public static enum AggregationType {
        LATEST,
        SUM;

    }
}

