/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.models;

import com.google.common.collect.ImmutableList;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.annotation.TraverserContext;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FieldSpecUtils {
    private FieldSpecUtils() {
    }

    public static String getSchemaFieldName(PathSpec pathSpec) {
        List<String> components = pathSpec.getPathComponents();
        String lastComponent = components.get(components.size() - 1);
        if (lastComponent.equals("*")) {
            return components.get(components.size() - 2);
        }
        return lastComponent;
    }

    public static Map<String, Object> getResolvedProperties(DataSchema schema, Map<String, Object> fallback) {
        if (!schema.getResolvedProperties().isEmpty()) {
            return schema.getResolvedProperties();
        }
        if (!schema.getProperties().isEmpty()) {
            return schema.getProperties();
        }
        return fallback;
    }

    public static Optional<PathSpec> getPathSpecWithAspectName(TraverserContext context) {
        Object aspectAnnotationObj = context.getTopLevelSchema().getProperties().get("Aspect");
        if (aspectAnnotationObj == null || !Map.class.isAssignableFrom(aspectAnnotationObj.getClass()) || !((Map)aspectAnnotationObj).containsKey("name")) {
            return Optional.empty();
        }
        String aspectName = ((Map)aspectAnnotationObj).get("name").toString();
        return Optional.of(new PathSpec(((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(aspectName)).addAll(context.getSchemaPathSpec())).build()));
    }
}

