/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.key;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DashboardKey
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.key/**Key for a Dashboard*/@Aspect.name=\"dashboardKey\"record DashboardKey{/**The name of the dashboard tool such as looker, redash etc.*/@Searchable={\"boostScore\":4.0,\"fieldName\":\"tool\",\"fieldType\":\"TEXT_PARTIAL\"}dashboardTool:string/**Unique id for the dashboard. This id should be globally unique for a dashboarding tool even when there are multiple deployments of it. As an example, dashboard URL could be used here for Looker such as 'looker.linkedin.com/dashboards/1234'*/dashboardId:string}", SchemaFormatType.PDL);
    private String _dashboardToolField = null;
    private String _dashboardIdField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_DashboardTool = SCHEMA.getField("dashboardTool");
    private static final RecordDataSchema.Field FIELD_DashboardId = SCHEMA.getField("dashboardId");

    public DashboardKey() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DashboardKey(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasDashboardTool() {
        if (this._dashboardToolField != null) {
            return true;
        }
        return this._map.containsKey("dashboardTool");
    }

    public void removeDashboardTool() {
        this._map.remove("dashboardTool");
    }

    @Nullable
    public String getDashboardTool(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDashboardTool();
            }
            case DEFAULT: 
            case NULL: {
                if (this._dashboardToolField != null) {
                    return this._dashboardToolField;
                }
                Object __rawValue = this._map.get("dashboardTool");
                this._dashboardToolField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._dashboardToolField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDashboardTool() {
        if (this._dashboardToolField != null) {
            return this._dashboardToolField;
        }
        Object __rawValue = this._map.get("dashboardTool");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dashboardTool");
        }
        this._dashboardToolField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._dashboardToolField;
    }

    public DashboardKey setDashboardTool(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDashboardTool(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dashboardTool of com.linkedin.metadata.key.DashboardKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDashboardTool();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
                this._dashboardToolField = value;
            }
        }
        return this;
    }

    public DashboardKey setDashboardTool(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dashboardTool of com.linkedin.metadata.key.DashboardKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dashboardTool", value);
        this._dashboardToolField = value;
        return this;
    }

    public boolean hasDashboardId() {
        if (this._dashboardIdField != null) {
            return true;
        }
        return this._map.containsKey("dashboardId");
    }

    public void removeDashboardId() {
        this._map.remove("dashboardId");
    }

    @Nullable
    public String getDashboardId(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getDashboardId();
            }
            case DEFAULT: 
            case NULL: {
                if (this._dashboardIdField != null) {
                    return this._dashboardIdField;
                }
                Object __rawValue = this._map.get("dashboardId");
                this._dashboardIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._dashboardIdField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getDashboardId() {
        if (this._dashboardIdField != null) {
            return this._dashboardIdField;
        }
        Object __rawValue = this._map.get("dashboardId");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("dashboardId");
        }
        this._dashboardIdField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._dashboardIdField;
    }

    public DashboardKey setDashboardId(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDashboardId(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field dashboardId of com.linkedin.metadata.key.DashboardKey");
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardId", value);
                this._dashboardIdField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDashboardId();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "dashboardId", value);
                this._dashboardIdField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "dashboardId", value);
                this._dashboardIdField = value;
            }
        }
        return this;
    }

    public DashboardKey setDashboardId(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field dashboardId of com.linkedin.metadata.key.DashboardKey to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "dashboardId", value);
        this._dashboardIdField = value;
        return this;
    }

    @Override
    public DashboardKey clone() throws CloneNotSupportedException {
        DashboardKey __clone = (DashboardKey)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DashboardKey copy() throws CloneNotSupportedException {
        DashboardKey __copy = (DashboardKey)super.copy();
        __copy._dashboardIdField = null;
        __copy._dashboardToolField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DashboardKey __objectRef;

        private ChangeListener(DashboardKey reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "dashboardId": {
                    this.__objectRef._dashboardIdField = null;
                    break;
                }
                case "dashboardTool": {
                    this.__objectRef._dashboardToolField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec dashboardTool() {
            return new PathSpec(this.getPathComponents(), "dashboardTool");
        }

        public PathSpec dashboardId() {
            return new PathSpec(this.getPathComponents(), "dashboardId");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withDashboardTool() {
            this.getDataMap().put("dashboardTool", 1);
            return this;
        }

        public ProjectionMask withDashboardId() {
            this.getDataMap().put("dashboardId", 1);
            return this;
        }
    }
}

