/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.validation;

import com.linkedin.common.urn.Urn;
import com.linkedin.entity.Aspect;
import com.linkedin.identity.CorpUserInfo;
import com.linkedin.metadata.aspect.RetrieverContext;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.batch.ChangeMCP;
import com.linkedin.metadata.aspect.plugins.config.AspectPluginConfig;
import com.linkedin.metadata.aspect.plugins.validation.AspectPayloadValidator;
import com.linkedin.metadata.aspect.plugins.validation.AspectValidationException;
import com.linkedin.metadata.aspect.plugins.validation.ValidationExceptionCollection;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeleteValidator
extends AspectPayloadValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserDeleteValidator.class);
    @Nonnull
    private AspectPluginConfig config;

    @Override
    protected Stream<AspectValidationException> validateProposedAspects(@Nonnull Collection<? extends BatchItem> mcpItems, @Nonnull RetrieverContext retrieverContext) {
        ValidationExceptionCollection exceptions = ValidationExceptionCollection.newCollection();
        mcpItems.forEach(i -> {
            Urn entityUrn = i.getUrn();
            Aspect aspect = retrieverContext.getAspectRetriever().getLatestAspectObject(entityUrn, "corpUserInfo");
            if (aspect == null) {
                log.warn("CorpUser {} does not have have a CorpUserInfo aspect, ignoring...", (Object)entityUrn);
                return;
            }
            CorpUserInfo corpUserInfo = new CorpUserInfo(aspect.data());
            if (corpUserInfo.isSystem().booleanValue()) {
                exceptions.addException(AspectValidationException.forItem(i, "System users can not be deleted"));
            }
        });
        return exceptions.streamAllExceptions();
    }

    @Override
    protected Stream<AspectValidationException> validatePreCommitAspects(@Nonnull Collection<ChangeMCP> changeMCPs, @Nonnull RetrieverContext retrieverContext) {
        return Stream.empty();
    }

    @Override
    @Generated
    public UserDeleteValidator setConfig(@Nonnull AspectPluginConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        return this;
    }

    @Override
    @Nonnull
    @Generated
    public AspectPluginConfig getConfig() {
        return this.config;
    }
}

