/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.plugins.validation;

import com.linkedin.common.urn.Urn;
import com.linkedin.events.metadata.ChangeType;
import com.linkedin.metadata.aspect.batch.BatchItem;
import com.linkedin.metadata.aspect.plugins.validation.ValidationSubType;
import com.linkedin.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class AspectValidationException
extends Exception {
    @Nonnull
    private final BatchItem item;
    @Nonnull
    private final ChangeType changeType;
    @Nonnull
    private final Urn entityUrn;
    @Nonnull
    private final String aspectName;
    @Nonnull
    private final ValidationSubType subType;
    @Nullable
    private final String msg;

    public static AspectValidationException forItem(BatchItem item, String msg) {
        return AspectValidationException.forItem(item, msg, null);
    }

    public static AspectValidationException forItem(BatchItem item, String msg, Exception e) {
        return new AspectValidationException(item, msg, ValidationSubType.VALIDATION, e);
    }

    public static AspectValidationException forPrecondition(BatchItem item, String msg) {
        return AspectValidationException.forPrecondition(item, msg, null);
    }

    public static AspectValidationException forFilter(BatchItem item, String msg) {
        return new AspectValidationException(item, msg, ValidationSubType.FILTER);
    }

    public static AspectValidationException forAuth(BatchItem item, String msg) {
        return new AspectValidationException(item, msg, ValidationSubType.AUTHORIZATION);
    }

    public static AspectValidationException forPrecondition(BatchItem item, String msg, Exception e) {
        return new AspectValidationException(item, msg, ValidationSubType.PRECONDITION, e);
    }

    public AspectValidationException(@Nonnull BatchItem item, String msg, ValidationSubType subType) {
        this(item, msg, subType, null);
    }

    public AspectValidationException(@Nonnull BatchItem item, @Nonnull String msg, @Nullable ValidationSubType subType, Exception e) {
        super(msg, e);
        this.item = item;
        this.changeType = item.getChangeType();
        this.entityUrn = item.getUrn();
        this.aspectName = item.getAspectName();
        this.msg = msg;
        this.subType = subType != null ? subType : ValidationSubType.VALIDATION;
    }

    public Pair<Urn, String> getAspectGroup() {
        return Pair.of(this.entityUrn, this.aspectName);
    }

    @Nonnull
    @Generated
    public BatchItem getItem() {
        return this.item;
    }

    @Nonnull
    @Generated
    public ChangeType getChangeType() {
        return this.changeType;
    }

    @Nonnull
    @Generated
    public Urn getEntityUrn() {
        return this.entityUrn;
    }

    @Nonnull
    @Generated
    public String getAspectName() {
        return this.aspectName;
    }

    @Nonnull
    @Generated
    public ValidationSubType getSubType() {
        return this.subType;
    }

    @Nullable
    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Override
    @Generated
    public String toString() {
        return "AspectValidationException(item=" + String.valueOf(this.getItem()) + ", changeType=" + String.valueOf((Object)this.getChangeType()) + ", entityUrn=" + String.valueOf(this.getEntityUrn()) + ", aspectName=" + this.getAspectName() + ", subType=" + String.valueOf((Object)this.getSubType()) + ", msg=" + this.getMsg() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectValidationException)) {
            return false;
        }
        AspectValidationException other = (AspectValidationException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BatchItem this$item = this.getItem();
        BatchItem other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        ChangeType this$changeType = this.getChangeType();
        ChangeType other$changeType = other.getChangeType();
        if (this$changeType == null ? other$changeType != null : !((Object)((Object)this$changeType)).equals((Object)other$changeType)) {
            return false;
        }
        Urn this$entityUrn = this.getEntityUrn();
        Urn other$entityUrn = other.getEntityUrn();
        if (this$entityUrn == null ? other$entityUrn != null : !((Object)this$entityUrn).equals(other$entityUrn)) {
            return false;
        }
        String this$aspectName = this.getAspectName();
        String other$aspectName = other.getAspectName();
        if (this$aspectName == null ? other$aspectName != null : !this$aspectName.equals(other$aspectName)) {
            return false;
        }
        ValidationSubType this$subType = this.getSubType();
        ValidationSubType other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !((Object)((Object)this$subType)).equals((Object)other$subType)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AspectValidationException;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BatchItem $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        ChangeType $changeType = this.getChangeType();
        result = result * 59 + ($changeType == null ? 43 : ((Object)((Object)$changeType)).hashCode());
        Urn $entityUrn = this.getEntityUrn();
        result = result * 59 + ($entityUrn == null ? 43 : ((Object)$entityUrn).hashCode());
        String $aspectName = this.getAspectName();
        result = result * 59 + ($aspectName == null ? 43 : $aspectName.hashCode());
        ValidationSubType $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : ((Object)((Object)$subType)).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }
}

