/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template.structuredproperty;

import com.linkedin.common.UrnArray;
import com.linkedin.common.urn.UrnUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.CompoundKeyTemplate;
import com.linkedin.structured.StructuredPropertyDefinition;
import datahub.shaded.jackson.databind.JsonNode;
import datahub.shaded.jackson.databind.node.ArrayNode;
import java.util.Collections;
import javax.annotation.Nonnull;

public class StructuredPropertyDefinitionTemplate
extends CompoundKeyTemplate<StructuredPropertyDefinition> {
    private static final String ENTITY_TYPES_FIELD_NAME = "entityTypes";
    private static final String ALLOWED_VALUES_FIELD_NAME = "allowedValues";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String UNIT_SEPARATOR_DELIMITER = "\u241f";

    @Override
    public StructuredPropertyDefinition getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (recordTemplate instanceof StructuredPropertyDefinition) {
            return (StructuredPropertyDefinition)recordTemplate;
        }
        throw new ClassCastException("Unable to cast RecordTemplate to StructuredPropertyDefinition");
    }

    @Override
    public Class<StructuredPropertyDefinition> getTemplateType() {
        return StructuredPropertyDefinition.class;
    }

    @Override
    @Nonnull
    public StructuredPropertyDefinition getDefault() {
        StructuredPropertyDefinition definition = new StructuredPropertyDefinition();
        definition.setQualifiedName("");
        definition.setValueType(UrnUtils.getUrn("urn:li:dataType:datahub.string"));
        definition.setEntityTypes(new UrnArray());
        return definition;
    }

    @Override
    @Nonnull
    public JsonNode transformFields(JsonNode baseNode) {
        JsonNode transformedNode = this.arrayFieldToMap(baseNode, ENTITY_TYPES_FIELD_NAME, Collections.emptyList());
        if (transformedNode.get(ALLOWED_VALUES_FIELD_NAME) == null) {
            return transformedNode;
        }
        JsonNode allowedValues = transformedNode.get(ALLOWED_VALUES_FIELD_NAME);
        if (((ArrayNode)allowedValues).size() > 0) {
            JsonNode allowedValue = ((ArrayNode)allowedValues).get(0);
            JsonNode value = allowedValue.get(VALUE_FIELD_NAME);
            String secondaryKeyName = value.fieldNames().next();
            return this.arrayFieldToMap(transformedNode, ALLOWED_VALUES_FIELD_NAME, Collections.singletonList("value\u241f" + secondaryKeyName));
        }
        return this.arrayFieldToMap(transformedNode, ALLOWED_VALUES_FIELD_NAME, Collections.singletonList(VALUE_FIELD_NAME));
    }

    @Override
    @Nonnull
    public JsonNode rebaseFields(JsonNode patched) {
        JsonNode patchedNode = this.transformedMapToArray(patched, ENTITY_TYPES_FIELD_NAME, Collections.emptyList());
        if (patchedNode.get(ALLOWED_VALUES_FIELD_NAME) == null) {
            return patchedNode;
        }
        return this.transformedMapToArray(patchedNode, ALLOWED_VALUES_FIELD_NAME, Collections.singletonList(VALUE_FIELD_NAME));
    }
}

