/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect.patch.template;

import com.datahub.util.RecordUtils;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.metadata.aspect.patch.template.TemplateUtil;
import datahub.shaded.jackson.core.JsonProcessingException;
import datahub.shaded.jackson.databind.JsonNode;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import java.io.StringReader;
import javax.annotation.Nonnull;

public interface Template<T extends RecordTemplate> {
    default public T getSubtype(RecordTemplate recordTemplate) throws ClassCastException {
        if (this.getTemplateType().isInstance(recordTemplate)) {
            return (T)((RecordTemplate)this.getTemplateType().cast(recordTemplate));
        }
        throw new ClassCastException("Unable to cast RecordTemplate to " + this.getTemplateType().getName());
    }

    public Class<T> getTemplateType();

    @Nonnull
    public T getDefault();

    default public T applyPatch(RecordTemplate recordTemplate, JsonPatch jsonPatch) throws JsonProcessingException {
        TemplateUtil.validatePatch(jsonPatch);
        JsonNode transformed = TemplateUtil.populateTopLevelKeys(this.preprocessTemplate(recordTemplate), jsonPatch);
        try {
            JsonObject patched = jsonPatch.apply(Json.createReader(new StringReader(TemplateUtil.OBJECT_MAPPER.writeValueAsString(transformed))).readObject());
            JsonNode postProcessed = this.rebaseFields(TemplateUtil.OBJECT_MAPPER.readTree(patched.toString()));
            return RecordUtils.toRecordTemplate(this.getTemplateType(), postProcessed.toString());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Error performing JSON PATCH on aspect %s. Patch: %s Target: %s", recordTemplate.schema().getName(), jsonPatch, transformed.toString()), e);
        }
    }

    default public JsonNode preprocessTemplate(RecordTemplate recordTemplate) throws JsonProcessingException {
        T subtype = this.getSubtype(recordTemplate);
        JsonNode baseNode = TemplateUtil.OBJECT_MAPPER.readTree(RecordUtils.toJsonString(subtype));
        return this.transformFields(baseNode);
    }

    @Nonnull
    public JsonNode transformFields(JsonNode var1);

    @Nonnull
    public JsonNode rebaseFields(JsonNode var1);
}

