/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.metadata.aspect;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.HasTyperefInfo;
import com.linkedin.data.template.TyperefInfo;
import com.linkedin.data.template.UnionTemplate;
import com.linkedin.dataplatform.DataPlatformInfo;
import com.linkedin.metadata.key.DataPlatformKey;
import java.util.List;
import java.util.function.Function;

public class DataPlatformAspect
extends UnionTemplate
implements HasTyperefInfo {
    private static final UnionDataSchema SCHEMA = (UnionDataSchema)DataTemplateUtil.parseSchema("union[{namespace com.linkedin.metadata.key/**Key for a Data Platform*/@Aspect.name=\"dataPlatformKey\"record DataPlatformKey{/**Data platform name i.e. hdfs, oracle, espresso*/platformName:string}}{namespace com.linkedin.dataplatform/**Information about a data platform*/@Aspect.name=\"dataPlatformInfo\"record DataPlatformInfo{/**Name of the data platform*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":false,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}@validate.strlen.max=15,name:string/**The name that will be used for displaying a platform type.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}displayName:optional string/**Platform type this data platform describes*/type:/**Platform types available at LinkedIn*/enum PlatformType{/**Value for a file system, e.g. hdfs*/FILE_SYSTEM/**Value for a key value store, e.g. espresso, voldemort*/KEY_VALUE_STORE/**Value for a message broker, e.g. kafka*/MESSAGE_BROKER/**Value for an object store, e.g. ambry*/OBJECT_STORE/**Value for an OLAP datastore, e.g. pinot*/OLAP_DATASTORE/**Value for other platforms, e.g salesforce, dovetail*/OTHERS/**Value for a query engine, e.g. presto*/QUERY_ENGINE/**Value for a relational database, e.g. oracle, mysql*/RELATIONAL_DB/**Value for a search engine, e.g seas*/SEARCH_ENGINE}/**The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle*/datasetNameDelimiter:string/**The URL for a logo associated with the platform*/logoUrl:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}}]", SchemaFormatType.PDL);
    private DataPlatformKey _dataPlatformKeyMember = null;
    private DataPlatformInfo _dataPlatformInfoMember = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final DataSchema MEMBER_DataPlatformKey = SCHEMA.getTypeByMemberKey("com.linkedin.metadata.key.DataPlatformKey");
    public static final String MEMBERKEY_DataPlatformKey = "com.linkedin.metadata.key.DataPlatformKey";
    private static final DataSchema MEMBER_DataPlatformInfo = SCHEMA.getTypeByMemberKey("com.linkedin.dataplatform.DataPlatformInfo");
    public static final String MEMBERKEY_DataPlatformInfo = "com.linkedin.dataplatform.DataPlatformInfo";
    private static final TyperefInfo TYPEREFINFO = new UnionTyperefInfo();

    public DataPlatformAspect() {
        super(new DataMap(2, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataPlatformAspect(Object data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static UnionDataSchema dataSchema() {
        return SCHEMA;
    }

    public static DataPlatformAspect create(DataPlatformKey value) {
        DataPlatformAspect newUnion = new DataPlatformAspect();
        newUnion.setDataPlatformKey(value);
        return newUnion;
    }

    public boolean isDataPlatformKey() {
        return this.memberIs(MEMBERKEY_DataPlatformKey);
    }

    public DataPlatformKey getDataPlatformKey() {
        this.checkNotNull();
        if (this._dataPlatformKeyMember != null) {
            return this._dataPlatformKeyMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataPlatformKey);
        this._dataPlatformKeyMember = __rawValue == null ? null : new DataPlatformKey(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataPlatformKeyMember;
    }

    public void setDataPlatformKey(DataPlatformKey value) {
        this.checkNotNull();
        this._map.clear();
        this._dataPlatformKeyMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataPlatformKey, value.data());
    }

    public static DataPlatformAspect create(DataPlatformInfo value) {
        DataPlatformAspect newUnion = new DataPlatformAspect();
        newUnion.setDataPlatformInfo(value);
        return newUnion;
    }

    public boolean isDataPlatformInfo() {
        return this.memberIs(MEMBERKEY_DataPlatformInfo);
    }

    public DataPlatformInfo getDataPlatformInfo() {
        this.checkNotNull();
        if (this._dataPlatformInfoMember != null) {
            return this._dataPlatformInfoMember;
        }
        Object __rawValue = this._map.get(MEMBERKEY_DataPlatformInfo);
        this._dataPlatformInfoMember = __rawValue == null ? null : new DataPlatformInfo(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._dataPlatformInfoMember;
    }

    public void setDataPlatformInfo(DataPlatformInfo value) {
        this.checkNotNull();
        this._map.clear();
        this._dataPlatformInfoMember = value;
        CheckedUtil.putWithoutChecking(this._map, MEMBERKEY_DataPlatformInfo, value.data());
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    @Override
    public DataPlatformAspect clone() throws CloneNotSupportedException {
        DataPlatformAspect __clone = (DataPlatformAspect)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataPlatformAspect copy() throws CloneNotSupportedException {
        DataPlatformAspect __copy = (DataPlatformAspect)super.copy();
        __copy._dataPlatformInfoMember = null;
        __copy._dataPlatformKeyMember = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    @Override
    public TyperefInfo typerefInfo() {
        return TYPEREFINFO;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataPlatformAspect __objectRef;

        private ChangeListener(DataPlatformAspect reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "com.linkedin.dataplatform.DataPlatformInfo": {
                    this.__objectRef._dataPlatformInfoMember = null;
                    break;
                }
                case "com.linkedin.metadata.key.DataPlatformKey": {
                    this.__objectRef._dataPlatformKeyMember = null;
                }
            }
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private DataPlatformKey.ProjectionMask _DataPlatformKeyMask;
        private DataPlatformInfo.ProjectionMask _DataPlatformInfoMask;

        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withDataPlatformKey(Function<DataPlatformKey.ProjectionMask, DataPlatformKey.ProjectionMask> nestedMask) {
            this._DataPlatformKeyMask = nestedMask.apply(this._DataPlatformKeyMask == null ? DataPlatformKey.createMask() : this._DataPlatformKeyMask);
            this.getDataMap().put(DataPlatformAspect.MEMBERKEY_DataPlatformKey, this._DataPlatformKeyMask.getDataMap());
            return this;
        }

        public ProjectionMask withDataPlatformInfo(Function<DataPlatformInfo.ProjectionMask, DataPlatformInfo.ProjectionMask> nestedMask) {
            this._DataPlatformInfoMask = nestedMask.apply(this._DataPlatformInfoMask == null ? DataPlatformInfo.createMask() : this._DataPlatformInfoMask);
            this.getDataMap().put(DataPlatformAspect.MEMBERKEY_DataPlatformInfo, this._DataPlatformInfoMask.getDataMap());
            return this;
        }
    }

    private static final class UnionTyperefInfo
    extends TyperefInfo {
        private static final TyperefDataSchema SCHEMA = (TyperefDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.metadata.aspect/**A union of all supported metadata aspects for a Data Platform*/typeref DataPlatformAspect=union[{namespace com.linkedin.metadata.key/**Key for a Data Platform*/@Aspect.name=\"dataPlatformKey\"record DataPlatformKey{/**Data platform name i.e. hdfs, oracle, espresso*/platformName:string}}{namespace com.linkedin.dataplatform/**Information about a data platform*/@Aspect.name=\"dataPlatformInfo\"record DataPlatformInfo{/**Name of the data platform*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":false,\"fieldNameAliases\":[\"_entityName\"],\"fieldType\":\"WORD_GRAM\"}@validate.strlen.max=15,name:string/**The name that will be used for displaying a platform type.*/@Searchable={\"boostScore\":10.0,\"enableAutocomplete\":true,\"fieldType\":\"WORD_GRAM\"}displayName:optional string/**Platform type this data platform describes*/type:/**Platform types available at LinkedIn*/enum PlatformType{/**Value for a file system, e.g. hdfs*/FILE_SYSTEM/**Value for a key value store, e.g. espresso, voldemort*/KEY_VALUE_STORE/**Value for a message broker, e.g. kafka*/MESSAGE_BROKER/**Value for an object store, e.g. ambry*/OBJECT_STORE/**Value for an OLAP datastore, e.g. pinot*/OLAP_DATASTORE/**Value for other platforms, e.g salesforce, dovetail*/OTHERS/**Value for a query engine, e.g. presto*/QUERY_ENGINE/**Value for a relational database, e.g. oracle, mysql*/RELATIONAL_DB/**Value for a search engine, e.g seas*/SEARCH_ENGINE}/**The delimiter in the dataset names on the data platform, e.g. '/' for HDFS and '.' for Oracle*/datasetNameDelimiter:string/**The URL for a logo associated with the platform*/logoUrl:optional{namespace com.linkedin.common@java={\"class\":\"com.linkedin.common.url.Url\",\"coercerClass\":\"com.linkedin.common.url.UrlCoercer\"}typeref Url=string}}}]", SchemaFormatType.PDL);

        public UnionTyperefInfo() {
            super(SCHEMA);
        }

        public static TyperefDataSchema dataSchema() {
            return SCHEMA;
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public DataPlatformKey.Fields DataPlatformKey() {
            return new DataPlatformKey.Fields(this.getPathComponents(), DataPlatformAspect.MEMBERKEY_DataPlatformKey);
        }

        public DataPlatformInfo.Fields DataPlatformInfo() {
            return new DataPlatformInfo.Fields(this.getPathComponents(), DataPlatformAspect.MEMBERKEY_DataPlatformInfo);
        }
    }
}

