/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.ingestion;

import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataHubIngestionSourceSchedule
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.ingestion/**The schedule associated with an ingestion source.*/record DataHubIngestionSourceSchedule{/**A cron-formatted execution interval, as a cron string, e.g. * * * * **/interval:string/**Timezone in which the cron interval applies, e.g. America/Los Angeles*/timezone:string}", SchemaFormatType.PDL);
    private String _intervalField = null;
    private String _timezoneField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Interval = SCHEMA.getField("interval");
    private static final RecordDataSchema.Field FIELD_Timezone = SCHEMA.getField("timezone");

    public DataHubIngestionSourceSchedule() {
        super(new DataMap(3, 0.75f), SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public DataHubIngestionSourceSchedule(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasInterval() {
        if (this._intervalField != null) {
            return true;
        }
        return this._map.containsKey("interval");
    }

    public void removeInterval() {
        this._map.remove("interval");
    }

    @Nullable
    public String getInterval(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getInterval();
            }
            case DEFAULT: 
            case NULL: {
                if (this._intervalField != null) {
                    return this._intervalField;
                }
                Object __rawValue = this._map.get("interval");
                this._intervalField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._intervalField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getInterval() {
        if (this._intervalField != null) {
            return this._intervalField;
        }
        Object __rawValue = this._map.get("interval");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("interval");
        }
        this._intervalField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._intervalField;
    }

    public DataHubIngestionSourceSchedule setInterval(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setInterval(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field interval of com.linkedin.ingestion.DataHubIngestionSourceSchedule");
                }
                CheckedUtil.putWithoutChecking(this._map, "interval", value);
                this._intervalField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeInterval();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "interval", value);
                this._intervalField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "interval", value);
                this._intervalField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceSchedule setInterval(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field interval of com.linkedin.ingestion.DataHubIngestionSourceSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "interval", value);
        this._intervalField = value;
        return this;
    }

    public boolean hasTimezone() {
        if (this._timezoneField != null) {
            return true;
        }
        return this._map.containsKey("timezone");
    }

    public void removeTimezone() {
        this._map.remove("timezone");
    }

    @Nullable
    public String getTimezone(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getTimezone();
            }
            case DEFAULT: 
            case NULL: {
                if (this._timezoneField != null) {
                    return this._timezoneField;
                }
                Object __rawValue = this._map.get("timezone");
                this._timezoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._timezoneField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getTimezone() {
        if (this._timezoneField != null) {
            return this._timezoneField;
        }
        Object __rawValue = this._map.get("timezone");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("timezone");
        }
        this._timezoneField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._timezoneField;
    }

    public DataHubIngestionSourceSchedule setTimezone(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setTimezone(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field timezone of com.linkedin.ingestion.DataHubIngestionSourceSchedule");
                }
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeTimezone();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "timezone", value);
                this._timezoneField = value;
            }
        }
        return this;
    }

    public DataHubIngestionSourceSchedule setTimezone(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field timezone of com.linkedin.ingestion.DataHubIngestionSourceSchedule to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "timezone", value);
        this._timezoneField = value;
        return this;
    }

    @Override
    public DataHubIngestionSourceSchedule clone() throws CloneNotSupportedException {
        DataHubIngestionSourceSchedule __clone = (DataHubIngestionSourceSchedule)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public DataHubIngestionSourceSchedule copy() throws CloneNotSupportedException {
        DataHubIngestionSourceSchedule __copy = (DataHubIngestionSourceSchedule)super.copy();
        __copy._timezoneField = null;
        __copy._intervalField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final DataHubIngestionSourceSchedule __objectRef;

        private ChangeListener(DataHubIngestionSourceSchedule reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "timezone": {
                    this.__objectRef._timezoneField = null;
                    break;
                }
                case "interval": {
                    this.__objectRef._intervalField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec interval() {
            return new PathSpec(this.getPathComponents(), "interval");
        }

        public PathSpec timezone() {
            return new PathSpec(this.getPathComponents(), "timezone");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withInterval() {
            this.getDataMap().put("interval", 1);
            return this;
        }

        public ProjectionMask withTimezone() {
            this.getDataMap().put("timezone", 1);
            return this;
        }
    }
}

