/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.form;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.RequiredFieldNotPresentException;
import com.linkedin.data.template.SetMode;
import com.linkedin.form.FormActorAssignment;
import com.linkedin.form.FormPromptArray;
import com.linkedin.form.FormType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FormInfo
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.form/**Information about a form to help with filling out metadata on entities.*/@Aspect.name=\"formInfo\"record FormInfo{/**Display name of the form*/@Searchable.fieldType=\"TEXT_PARTIAL\"name:string/**Description of the form*/description:optional string/**The type of this form*/@Searchable.fieldType=\"KEYWORD\"type:enum FormType{/**A form simply used for collecting metadata fields for an entity.*/COMPLETION/**This form is used for \"verifying\" that entities comply with a policy via presence of a specific set of metadata fields.*/VERIFICATION}=\"COMPLETION\"/**List of prompts to present to the user to encourage filling out metadata*/prompts:array[/**A prompt to present to the user to encourage filling out metadata*/record FormPrompt{/**The unique id for this prompt. This must be GLOBALLY unique.*/@Searchable={\"fieldName\":\"promptId\",\"fieldType\":\"KEYWORD\",\"queryByDefault\":false}id:string/**The title of this prompt*/title:string/**The description of this prompt*/description:optional string/**The type of prompt*/type:enum FormPromptType{/**This prompt is meant to apply a structured property to an entity*/STRUCTURED_PROPERTY/**This prompt is meant to apply a structured property to a schema fields entity*/FIELDS_STRUCTURED_PROPERTY}/**An optional set of information specific to structured properties prompts.\nThis should be filled out if the prompt is type STRUCTURED_PROPERTY or FIELDS_STRUCTURED_PROPERTY.*/structuredPropertyParams:optional record StructuredPropertyParams{/**The structured property that is required on this entity*/@Searchable={\"fieldName\":\"structuredPropertyPromptUrns\",\"fieldType\":\"URN\"}urn:{namespace com.linkedin.common@java.class=\"com.linkedin.common.urn.Urn\"typeref Urn=string}}/**Whether the prompt is required to be completed, in order for the form to be marked as complete.*/required:boolean=false}]=[]/**Who the form is assigned to, e.g. who should see the form when visiting the entity page or governance center*/actors:record FormActorAssignment{/**Whether the form should be assigned to the owners of assets that it is applied to.\nThis is the default.*/@Searchable={\"fieldName\":\"isOwnershipForm\",\"fieldType\":\"BOOLEAN\"}owners:boolean=true/**Optional: Specific set of groups that are targeted by this form assignment.*/@Searchable.`/*`={\"fieldName\":\"assignedGroups\",\"fieldType\":\"URN\"}groups:optional array[com.linkedin.common.Urn]/**Optional: Specific set of users that are targeted by this form assignment.*/@Searchable.`/*`={\"fieldName\":\"assignedUsers\",\"fieldType\":\"URN\"}users:optional array[com.linkedin.common.Urn]}={\"owners\":true}}", SchemaFormatType.PDL);
    private String _nameField = null;
    private String _descriptionField = null;
    private FormType _typeField = null;
    private FormPromptArray _promptsField = null;
    private FormActorAssignment _actorsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_Name = SCHEMA.getField("name");
    private static final RecordDataSchema.Field FIELD_Description = SCHEMA.getField("description");
    private static final RecordDataSchema.Field FIELD_Type = SCHEMA.getField("type");
    private static final FormType DEFAULT_Type;
    private static final RecordDataSchema.Field FIELD_Prompts;
    private static final FormPromptArray DEFAULT_Prompts;
    private static final RecordDataSchema.Field FIELD_Actors;
    private static final FormActorAssignment DEFAULT_Actors;

    public FormInfo() {
        super(new DataMap(7, 0.75f), SCHEMA, 3);
        this.addChangeListener(this.__changeListener);
    }

    public FormInfo(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasName() {
        if (this._nameField != null) {
            return true;
        }
        return this._map.containsKey("name");
    }

    public void removeName() {
        this._map.remove("name");
    }

    @Nullable
    public String getName(GetMode mode) {
        switch (mode) {
            case STRICT: {
                return this.getName();
            }
            case DEFAULT: 
            case NULL: {
                if (this._nameField != null) {
                    return this._nameField;
                }
                Object __rawValue = this._map.get("name");
                this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
                return this._nameField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public String getName() {
        if (this._nameField != null) {
            return this._nameField;
        }
        Object __rawValue = this._map.get("name");
        if (__rawValue == null) {
            throw new RequiredFieldNotPresentException("name");
        }
        this._nameField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._nameField;
    }

    public FormInfo setName(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setName(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field name of com.linkedin.form.FormInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeName();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "name", value);
                this._nameField = value;
            }
        }
        return this;
    }

    public FormInfo setName(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field name of com.linkedin.form.FormInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "name", value);
        this._nameField = value;
        return this;
    }

    public boolean hasDescription() {
        if (this._descriptionField != null) {
            return true;
        }
        return this._map.containsKey("description");
    }

    public void removeDescription() {
        this._map.remove("description");
    }

    @Nullable
    public String getDescription(GetMode mode) {
        return this.getDescription();
    }

    @Nullable
    public String getDescription() {
        if (this._descriptionField != null) {
            return this._descriptionField;
        }
        Object __rawValue = this._map.get("description");
        this._descriptionField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._descriptionField;
    }

    public FormInfo setDescription(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setDescription(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeDescription();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "description", value);
                this._descriptionField = value;
            }
        }
        return this;
    }

    public FormInfo setDescription(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field description of com.linkedin.form.FormInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "description", value);
        this._descriptionField = value;
        return this;
    }

    public boolean hasType() {
        if (this._typeField != null) {
            return true;
        }
        return this._map.containsKey("type");
    }

    public void removeType() {
        this._map.remove("type");
    }

    @Nullable
    public FormType getType(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getType();
            }
            case NULL: {
                if (this._typeField != null) {
                    return this._typeField;
                }
                Object __rawValue = this._map.get("type");
                this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FormType.class, FormType.$UNKNOWN);
                return this._typeField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormType getType() {
        if (this._typeField != null) {
            return this._typeField;
        }
        Object __rawValue = this._map.get("type");
        if (__rawValue == null) {
            return DEFAULT_Type;
        }
        this._typeField = DataTemplateUtil.coerceEnumOutput(__rawValue, FormType.class, FormType.$UNKNOWN);
        return this._typeField;
    }

    public FormInfo setType(@Nullable FormType value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setType(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field type of com.linkedin.form.FormInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeType();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "type", value.name());
                this._typeField = value;
            }
        }
        return this;
    }

    public FormInfo setType(@Nonnull FormType value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field type of com.linkedin.form.FormInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "type", value.name());
        this._typeField = value;
        return this;
    }

    public boolean hasPrompts() {
        if (this._promptsField != null) {
            return true;
        }
        return this._map.containsKey("prompts");
    }

    public void removePrompts() {
        this._map.remove("prompts");
    }

    @Nullable
    public FormPromptArray getPrompts(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getPrompts();
            }
            case NULL: {
                if (this._promptsField != null) {
                    return this._promptsField;
                }
                Object __rawValue = this._map.get("prompts");
                this._promptsField = __rawValue == null ? null : new FormPromptArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
                return this._promptsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormPromptArray getPrompts() {
        if (this._promptsField != null) {
            return this._promptsField;
        }
        Object __rawValue = this._map.get("prompts");
        if (__rawValue == null) {
            return DEFAULT_Prompts;
        }
        this._promptsField = __rawValue == null ? null : new FormPromptArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._promptsField;
    }

    public FormInfo setPrompts(@Nullable FormPromptArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setPrompts(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field prompts of com.linkedin.form.FormInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "prompts", value.data());
                this._promptsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removePrompts();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "prompts", value.data());
                this._promptsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "prompts", value.data());
                this._promptsField = value;
            }
        }
        return this;
    }

    public FormInfo setPrompts(@Nonnull FormPromptArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field prompts of com.linkedin.form.FormInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "prompts", value.data());
        this._promptsField = value;
        return this;
    }

    public boolean hasActors() {
        if (this._actorsField != null) {
            return true;
        }
        return this._map.containsKey("actors");
    }

    public void removeActors() {
        this._map.remove("actors");
    }

    @Nullable
    public FormActorAssignment getActors(GetMode mode) {
        switch (mode) {
            case STRICT: 
            case DEFAULT: {
                return this.getActors();
            }
            case NULL: {
                if (this._actorsField != null) {
                    return this._actorsField;
                }
                Object __rawValue = this._map.get("actors");
                this._actorsField = __rawValue == null ? null : new FormActorAssignment(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
                return this._actorsField;
            }
        }
        throw new IllegalStateException("Unknown mode " + (Object)((Object)mode));
    }

    @Nonnull
    public FormActorAssignment getActors() {
        if (this._actorsField != null) {
            return this._actorsField;
        }
        Object __rawValue = this._map.get("actors");
        if (__rawValue == null) {
            return DEFAULT_Actors;
        }
        this._actorsField = __rawValue == null ? null : new FormActorAssignment(DataTemplateUtil.castOrThrow(__rawValue, DataMap.class));
        return this._actorsField;
    }

    public FormInfo setActors(@Nullable FormActorAssignment value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setActors(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: {
                if (value == null) {
                    throw new IllegalArgumentException("Cannot remove mandatory field actors of com.linkedin.form.FormInfo");
                }
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
                break;
            }
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeActors();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
                this._actorsField = value;
            }
        }
        return this;
    }

    public FormInfo setActors(@Nonnull FormActorAssignment value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field actors of com.linkedin.form.FormInfo to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "actors", value.data());
        this._actorsField = value;
        return this;
    }

    @Override
    public FormInfo clone() throws CloneNotSupportedException {
        FormInfo __clone = (FormInfo)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public FormInfo copy() throws CloneNotSupportedException {
        FormInfo __copy = (FormInfo)super.copy();
        __copy._actorsField = null;
        __copy._nameField = null;
        __copy._descriptionField = null;
        __copy._typeField = null;
        __copy._promptsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    static {
        FIELD_Prompts = SCHEMA.getField("prompts");
        FIELD_Actors = SCHEMA.getField("actors");
        DEFAULT_Type = DataTemplateUtil.coerceEnumOutput(FIELD_Type.getDefault(), FormType.class, FormType.$UNKNOWN);
        DEFAULT_Prompts = FIELD_Prompts.getDefault() == null ? null : new FormPromptArray(DataTemplateUtil.castOrThrow(FIELD_Prompts.getDefault(), DataList.class));
        DEFAULT_Actors = FIELD_Actors.getDefault() == null ? null : new FormActorAssignment(DataTemplateUtil.castOrThrow(FIELD_Actors.getDefault(), DataMap.class));
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final FormInfo __objectRef;

        private ChangeListener(FormInfo reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "actors": {
                    this.__objectRef._actorsField = null;
                    break;
                }
                case "name": {
                    this.__objectRef._nameField = null;
                    break;
                }
                case "description": {
                    this.__objectRef._descriptionField = null;
                    break;
                }
                case "type": {
                    this.__objectRef._typeField = null;
                    break;
                }
                case "prompts": {
                    this.__objectRef._promptsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec name() {
            return new PathSpec(this.getPathComponents(), "name");
        }

        public PathSpec description() {
            return new PathSpec(this.getPathComponents(), "description");
        }

        public PathSpec type() {
            return new PathSpec(this.getPathComponents(), "type");
        }

        public FormPromptArray.Fields prompts() {
            return new FormPromptArray.Fields(this.getPathComponents(), "prompts");
        }

        public PathSpec prompts(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "prompts");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }

        public FormActorAssignment.Fields actors() {
            return new FormActorAssignment.Fields(this.getPathComponents(), "actors");
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        private FormPromptArray.ProjectionMask _promptsMask;
        private FormActorAssignment.ProjectionMask _actorsMask;

        ProjectionMask() {
            super(7);
        }

        public ProjectionMask withName() {
            this.getDataMap().put("name", 1);
            return this;
        }

        public ProjectionMask withDescription() {
            this.getDataMap().put("description", 1);
            return this;
        }

        public ProjectionMask withType() {
            this.getDataMap().put("type", 1);
            return this;
        }

        public ProjectionMask withPrompts(Function<FormPromptArray.ProjectionMask, FormPromptArray.ProjectionMask> nestedMask) {
            this._promptsMask = nestedMask.apply(this._promptsMask == null ? FormPromptArray.createMask() : this._promptsMask);
            this.getDataMap().put("prompts", this._promptsMask.getDataMap());
            return this;
        }

        public ProjectionMask withPrompts() {
            this._promptsMask = null;
            this.getDataMap().put("prompts", 1);
            return this;
        }

        public ProjectionMask withPrompts(Function<FormPromptArray.ProjectionMask, FormPromptArray.ProjectionMask> nestedMask, Integer start, Integer count) {
            this._promptsMask = nestedMask.apply(this._promptsMask == null ? FormPromptArray.createMask() : this._promptsMask);
            this.getDataMap().put("prompts", this._promptsMask.getDataMap());
            if (start != null) {
                this.getDataMap().getDataMap("prompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("prompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withPrompts(Integer start, Integer count) {
            this._promptsMask = null;
            this.getDataMap().put("prompts", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("prompts").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("prompts").put("$count", count);
            }
            return this;
        }

        public ProjectionMask withActors(Function<FormActorAssignment.ProjectionMask, FormActorAssignment.ProjectionMask> nestedMask) {
            this._actorsMask = nestedMask.apply(this._actorsMask == null ? FormActorAssignment.createMask() : this._actorsMask);
            this.getDataMap().put("actors", this._actorsMask.getDataMap());
            return this;
        }

        public ProjectionMask withActors() {
            this._actorsMask = null;
            this.getDataMap().put("actors", 1);
            return this;
        }
    }
}

