/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.event.notification.settings;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.collections.CheckedMap;
import com.linkedin.data.collections.CheckedUtil;
import com.linkedin.data.schema.MaskMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaFormatType;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SlackNotificationSettings
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema("namespace com.linkedin.event.notification.settings/**Slack Notification settings for an actor.*/record SlackNotificationSettings{/**Optional user handle*/userHandle:optional string/**Optional list of channels to send notifications to*/channels:optional array[string]}", SchemaFormatType.PDL);
    private String _userHandleField = null;
    private StringArray _channelsField = null;
    private ChangeListener __changeListener = new ChangeListener(this);
    private static final RecordDataSchema.Field FIELD_UserHandle = SCHEMA.getField("userHandle");
    private static final RecordDataSchema.Field FIELD_Channels = SCHEMA.getField("channels");

    public SlackNotificationSettings() {
        super(new DataMap(3, 0.75f), SCHEMA, 2);
        this.addChangeListener(this.__changeListener);
    }

    public SlackNotificationSettings(DataMap data) {
        super(data, SCHEMA);
        this.addChangeListener(this.__changeListener);
    }

    public static Fields fields() {
        return _fields;
    }

    public static ProjectionMask createMask() {
        return new ProjectionMask();
    }

    public static RecordDataSchema dataSchema() {
        return SCHEMA;
    }

    public boolean hasUserHandle() {
        if (this._userHandleField != null) {
            return true;
        }
        return this._map.containsKey("userHandle");
    }

    public void removeUserHandle() {
        this._map.remove("userHandle");
    }

    @Nullable
    public String getUserHandle(GetMode mode) {
        return this.getUserHandle();
    }

    @Nullable
    public String getUserHandle() {
        if (this._userHandleField != null) {
            return this._userHandleField;
        }
        Object __rawValue = this._map.get("userHandle");
        this._userHandleField = DataTemplateUtil.coerceStringOutput(__rawValue);
        return this._userHandleField;
    }

    public SlackNotificationSettings setUserHandle(@Nullable String value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setUserHandle(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeUserHandle();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "userHandle", value);
                this._userHandleField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "userHandle", value);
                this._userHandleField = value;
            }
        }
        return this;
    }

    public SlackNotificationSettings setUserHandle(@Nonnull String value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field userHandle of com.linkedin.event.notification.settings.SlackNotificationSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "userHandle", value);
        this._userHandleField = value;
        return this;
    }

    public boolean hasChannels() {
        if (this._channelsField != null) {
            return true;
        }
        return this._map.containsKey("channels");
    }

    public void removeChannels() {
        this._map.remove("channels");
    }

    @Nullable
    public StringArray getChannels(GetMode mode) {
        return this.getChannels();
    }

    @Nullable
    public StringArray getChannels() {
        if (this._channelsField != null) {
            return this._channelsField;
        }
        Object __rawValue = this._map.get("channels");
        this._channelsField = __rawValue == null ? null : new StringArray(DataTemplateUtil.castOrThrow(__rawValue, DataList.class));
        return this._channelsField;
    }

    public SlackNotificationSettings setChannels(@Nullable StringArray value, SetMode mode) {
        switch (mode) {
            case DISALLOW_NULL: {
                return this.setChannels(value);
            }
            case REMOVE_OPTIONAL_IF_NULL: 
            case REMOVE_IF_NULL: {
                if (value == null) {
                    this.removeChannels();
                    break;
                }
                CheckedUtil.putWithoutChecking(this._map, "channels", value.data());
                this._channelsField = value;
                break;
            }
            case IGNORE_NULL: {
                if (value == null) break;
                CheckedUtil.putWithoutChecking(this._map, "channels", value.data());
                this._channelsField = value;
            }
        }
        return this;
    }

    public SlackNotificationSettings setChannels(@Nonnull StringArray value) {
        if (value == null) {
            throw new NullPointerException("Cannot set field channels of com.linkedin.event.notification.settings.SlackNotificationSettings to null");
        }
        CheckedUtil.putWithoutChecking(this._map, "channels", value.data());
        this._channelsField = value;
        return this;
    }

    @Override
    public SlackNotificationSettings clone() throws CloneNotSupportedException {
        SlackNotificationSettings __clone = (SlackNotificationSettings)super.clone();
        __clone.__changeListener = new ChangeListener(__clone);
        __clone.addChangeListener(__clone.__changeListener);
        return __clone;
    }

    @Override
    public SlackNotificationSettings copy() throws CloneNotSupportedException {
        SlackNotificationSettings __copy = (SlackNotificationSettings)super.copy();
        __copy._userHandleField = null;
        __copy._channelsField = null;
        __copy.__changeListener = new ChangeListener(__copy);
        __copy.addChangeListener(__copy.__changeListener);
        return __copy;
    }

    private static class ChangeListener
    implements CheckedMap.ChangeListener<String, Object> {
        private final SlackNotificationSettings __objectRef;

        private ChangeListener(SlackNotificationSettings reference) {
            this.__objectRef = reference;
        }

        @Override
        public void onUnderlyingMapChanged(String key, Object value) {
            switch (key) {
                case "userHandle": {
                    this.__objectRef._userHandleField = null;
                    break;
                }
                case "channels": {
                    this.__objectRef._channelsField = null;
                }
            }
        }
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec userHandle() {
            return new PathSpec(this.getPathComponents(), "userHandle");
        }

        public PathSpec channels() {
            return new PathSpec(this.getPathComponents(), "channels");
        }

        public PathSpec channels(Integer start, Integer count) {
            PathSpec arrayPathSpec = new PathSpec(this.getPathComponents(), "channels");
            if (start != null) {
                arrayPathSpec.setAttribute("start", start);
            }
            if (count != null) {
                arrayPathSpec.setAttribute("count", count);
            }
            return arrayPathSpec;
        }
    }

    public static class ProjectionMask
    extends MaskMap {
        ProjectionMask() {
            super(3);
        }

        public ProjectionMask withUserHandle() {
            this.getDataMap().put("userHandle", 1);
            return this;
        }

        public ProjectionMask withChannels() {
            this.getDataMap().put("channels", 1);
            return this;
        }

        public ProjectionMask withChannels(Integer start, Integer count) {
            this.getDataMap().put("channels", new DataMap(3));
            if (start != null) {
                this.getDataMap().getDataMap("channels").put("$start", start);
            }
            if (count != null) {
                this.getDataMap().getDataMap("channels").put("$count", count);
            }
            return this;
        }
    }
}

