/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.validator;

import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.DataSchemaTraverse;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public class DataSchemaAnnotationValidator
implements Validator {
    public static final String VALIDATE = "validate";
    public static final String JAVA_PROPERTY = "java";
    public static final String VALIDATOR_PRIORITY = "validatorPriority";
    public static final int DEFAULT_VALIDATOR_PRIORITY = 0;
    private static final String MY_PACKAGE_NAME = DataSchemaAnnotationValidator.class.getPackage().getName();
    private static final Comparator<ValidatorInfo> PRIORITY_COMPARATOR = new Comparator<ValidatorInfo>(){

        @Override
        public int compare(ValidatorInfo v1, ValidatorInfo v2) {
            return v2._priority - v1._priority;
        }
    };
    private static final Map<String, Class<? extends Validator>> VALIDATOR_CLASS_CACHE = new ConcurrentHashMap<String, Class<? extends Validator>>();
    private static final Validator NULL_VALIDATOR = context -> {};
    private boolean _debugMode = false;
    private DataSchema _schema = DataSchemaConstants.NULL_DATA_SCHEMA;
    private Map<String, Class<? extends Validator>> _customValidatorClassMap = Collections.emptyMap();
    private Map<Object, List<Validator>> _schemaValidators = Collections.emptyMap();
    private MessageList<Message> _initMessages = new MessageList();
    private static final List<Validator> NO_VALIDATORS = Collections.emptyList();

    public DataSchemaAnnotationValidator() {
    }

    public DataSchemaAnnotationValidator(DataSchema schema) {
        this.init(schema);
    }

    public DataSchemaAnnotationValidator(DataSchema schema, Map<String, Class<? extends Validator>> classMap) {
        this.init(schema, classMap);
    }

    public boolean init(DataSchema schema) {
        return this.init(schema, Collections.emptyMap());
    }

    public boolean init(DataSchema schema, Map<String, Class<? extends Validator>> classMap) {
        this._initMessages.clear();
        this._schema = schema;
        this._customValidatorClassMap = classMap;
        this._schemaValidators = this.buildSchemaValidators(this._schema);
        return this.isInitOk();
    }

    public boolean isInitOk() {
        return !this._initMessages.isError();
    }

    public Collection<Message> getInitMessages() {
        return this._initMessages;
    }

    public void setDebugMode(boolean debugMode) {
        this._debugMode = debugMode;
    }

    public boolean isDebugMode() {
        return this._debugMode;
    }

    private IdentityHashMap<Object, List<Validator>> buildSchemaValidators(DataSchema schema) {
        final IdentityHashMap<Object, List<Validator>> map = new IdentityHashMap<Object, List<Validator>>();
        DataSchemaTraverse traverse = new DataSchemaTraverse();
        traverse.traverse(schema, new DataSchemaTraverse.Callback(){

            @Override
            public void callback(List<String> path, DataSchema schema) {
                block6: {
                    UnionDataSchema unionDataSchema;
                    Object validateObject;
                    List validatorList;
                    block7: {
                        validatorList = (List)map.get(schema);
                        if (validatorList != null) break block6;
                        validateObject = schema.getProperties().get(DataSchemaAnnotationValidator.VALIDATE);
                        validatorList = validateObject == null ? NO_VALIDATORS : DataSchemaAnnotationValidator.this.buildValidatorList(validateObject, path, schema);
                        map.put(schema, validatorList);
                        if (schema.getType() != DataSchema.Type.RECORD) break block7;
                        RecordDataSchema recordDataSchema = (RecordDataSchema)schema;
                        for (RecordDataSchema.Field field : recordDataSchema.getFields()) {
                            validateObject = field.getProperties().get(DataSchemaAnnotationValidator.VALIDATE);
                            if (validateObject == null) {
                                validatorList = NO_VALIDATORS;
                            } else {
                                path.add(field.getName());
                                validatorList = DataSchemaAnnotationValidator.this.buildValidatorList(validateObject, path, field);
                                path.remove(path.size() - 1);
                            }
                            map.put(field, validatorList);
                        }
                        break block6;
                    }
                    if (schema.getType() != DataSchema.Type.UNION || !(unionDataSchema = (UnionDataSchema)schema).areMembersAliased()) break block6;
                    for (UnionDataSchema.Member member : unionDataSchema.getMembers()) {
                        validateObject = member.getProperties().get(DataSchemaAnnotationValidator.VALIDATE);
                        if (validateObject == null) {
                            validatorList = NO_VALIDATORS;
                        } else {
                            path.add(member.getAlias());
                            validatorList = DataSchemaAnnotationValidator.this.buildValidatorList(validateObject, path, member);
                            path.remove(path.size() - 1);
                        }
                        map.put(member, validatorList);
                    }
                }
            }
        });
        return map;
    }

    private List<Validator> buildValidatorList(Object validateObject, List<String> path, Object source) {
        List<Validator> validatorList;
        if (validateObject.getClass() != DataMap.class) {
            this.addMessage(path, "\"validate\" property of %1$s is not a DataMap\n", source);
            validatorList = NO_VALIDATORS;
        } else {
            DataMap validateMap = (DataMap)validateObject;
            ArrayList<ValidatorInfo> validatorInfoList = new ArrayList<ValidatorInfo>(validateMap.size());
            for (Map.Entry entry : validateMap.entrySet()) {
                Object config = entry.getValue();
                String key = (String)entry.getKey();
                Class<? extends Validator> clazz = this.locateValidatorClass(key, path, source);
                if (clazz == null) {
                    this.addMessage(path, "\"validate\" property of %1$s, unable to find Validator for \"%2$s\"\n", source, key);
                    continue;
                }
                if (config.getClass() != DataMap.class) {
                    this.addMessage(path, "\"validate\" property of %1$s, value of \"%2$s\" is not a DataMap\n", source, key);
                    continue;
                }
                try {
                    Constructor<? extends Validator> ctor = clazz.getConstructor(DataMap.class);
                    DataMap configDataMap = (DataMap)config;
                    configDataMap.makeReadOnly();
                    Integer priority = configDataMap.getInteger(VALIDATOR_PRIORITY);
                    Validator validator = ctor.newInstance(configDataMap);
                    validatorInfoList.add(new ValidatorInfo(priority, validator));
                }
                catch (Exception e) {
                    this.addMessage(path, "\"validate\" property of %1$s, %2$s cannot be instantiated for \"%3$s\", %4$s\n", source, clazz.getName(), key, e);
                }
            }
            Collections.sort(validatorInfoList, PRIORITY_COMPARATOR);
            validatorList = new ArrayList<Validator>(validatorInfoList.size());
            for (ValidatorInfo validatorInfo : validatorInfoList) {
                validatorList.add(validatorInfo._validator);
            }
        }
        assert (validatorList != null);
        return validatorList;
    }

    protected Class<? extends Validator> locateValidatorClass(String key, List<String> path, Object source) {
        Class<Validator> clazz = this._customValidatorClassMap.get(key);
        if (clazz != null) {
            return clazz;
        }
        clazz = VALIDATOR_CLASS_CACHE.get(key);
        if (clazz != null) {
            return NULL_VALIDATOR.getClass().equals(clazz) ? null : clazz;
        }
        Iterator<String> it = this.validatorClassNamesForKey(key);
        while (it.hasNext()) {
            String className = it.next();
            try {
                Class<?> classFromName = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                if (Validator.class.isAssignableFrom(classFromName)) {
                    Class<?> validatorClass = classFromName;
                    clazz = validatorClass;
                    break;
                }
                this.addMessage(path, className.equals(key), "\"validate\" property of %1$s, %2$s is not a %3$s", source, classFromName.getName(), Validator.class.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz != null) {
            VALIDATOR_CLASS_CACHE.put(key, clazz);
        } else {
            VALIDATOR_CLASS_CACHE.put(key, NULL_VALIDATOR.getClass());
        }
        return clazz;
    }

    protected Iterator<String> validatorClassNamesForKey(final String key) {
        return new Iterator<String>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < 2;
            }

            @Override
            public String next() {
                String name;
                switch (this.index) {
                    case 0: {
                        name = key;
                        break;
                    }
                    case 1: {
                        StringBuilder sb = new StringBuilder();
                        sb.append(MY_PACKAGE_NAME);
                        sb.append('.');
                        if (key.length() > 0) {
                            sb.append(Character.toUpperCase(key.charAt(0)));
                            sb.append(key, 1, key.length());
                        }
                        sb.append("Validator");
                        name = sb.toString();
                        break;
                    }
                    default: {
                        throw new NoSuchElementException();
                    }
                }
                ++this.index;
                return name;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void addMessage(List<String> path, String format, Object ... args) {
        this._initMessages.add(new Message(path.toArray(), format, args));
    }

    private void addMessage(List<String> path, boolean error, String format, Object ... args) {
        this._initMessages.add(new Message(path.toArray(), error, format, args));
    }

    private void getAndInvokeValidatorList(ValidatorContext ctx, Object key) {
        List<Validator> validatorList = this._schemaValidators.get(key);
        if (validatorList == null) {
            ctx.addResult(new Message(ctx.dataElement().path(), "validation skipped, %1$s have not been initialized for use by %2$s", key, this.getClass().getSimpleName()));
        } else if (validatorList != NO_VALIDATORS) {
            for (Validator validator : validatorList) {
                if (this._debugMode) {
                    ctx.addResult(new Message(ctx.dataElement().path(), false, "validating with %1$s", validator));
                }
                validator.validate(ctx);
            }
        }
    }

    private final void validateSchema(ValidatorContext context, DataSchema schema) {
        if (schema.getType() == DataSchema.Type.TYPEREF) {
            DataSchema refSchema = ((TyperefDataSchema)schema).getRef();
            this.validateSchema(context, refSchema);
            this.getAndInvokeValidatorList(context, schema);
        } else {
            this.getAndInvokeValidatorList(context, schema);
        }
    }

    @Override
    public void validate(ValidatorContext context) {
        DataElement parentElement;
        DataElement element = context.dataElement();
        DataSchema schema = element.getSchema();
        if (schema != null) {
            this.validateSchema(context, schema);
        }
        if ((parentElement = element.getParent()) != null) {
            RecordDataSchema recordDataSchema;
            RecordDataSchema.Field field;
            Object name;
            DataSchema parentSchema = parentElement.getSchema();
            if (parentSchema != null && parentSchema.getType() == DataSchema.Type.RECORD && (name = element.getName()).getClass() == String.class && (field = (recordDataSchema = (RecordDataSchema)parentSchema).getField((String)name)) != null) {
                this.getAndInvokeValidatorList(context, field);
            }
            if (parentSchema != null && parentSchema.getType() == DataSchema.Type.UNION) {
                UnionDataSchema unionDataSchema = (UnionDataSchema)parentSchema;
                Object name2 = element.getName();
                if (unionDataSchema.areMembersAliased() && unionDataSchema.contains((String)name2)) {
                    UnionDataSchema.Member member = unionDataSchema.getMemberByMemberKey((String)name2);
                    this.getAndInvokeValidatorList(context, member);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("\n");
        if (!this._initMessages.isEmpty()) {
            sb.append("Initialization message:\n");
            this._initMessages.appendTo(sb);
        }
        sb.append("Validators:\n");
        for (Map.Entry<Object, List<Validator>> e : this._schemaValidators.entrySet()) {
            sb.append("  ");
            Object key = e.getKey();
            if (key instanceof RecordDataSchema.Field) {
                sb.append(((RecordDataSchema.Field)key).getName()).append(" (field)");
            } else if (key instanceof NamedDataSchema) {
                sb.append(((NamedDataSchema)key).getFullName()).append(" (named schema)");
            } else {
                sb.append(key.toString());
            }
            sb.append("\n");
            for (Validator v : e.getValue()) {
                sb.append("    ").append(v).append("\n");
            }
        }
        return sb.toString();
    }

    private static class ValidatorInfo {
        private final int _priority;
        private final Validator _validator;

        private ValidatorInfo(Integer priority, Validator validator) {
            this._priority = priority == null ? 0 : priority;
            this._validator = validator;
        }
    }
}

