/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema.resolver;

import com.linkedin.data.schema.DataSchemaParserFactory;
import com.linkedin.data.schema.resolver.AbstractMultiFormatDataSchemaResolver;
import com.linkedin.data.schema.resolver.FileDataSchemaResolver;
import com.linkedin.data.schema.resolver.SchemaDirectory;
import com.linkedin.data.schema.resolver.SchemaDirectoryName;
import java.util.Collections;
import java.util.List;

public class MultiFormatDataSchemaResolver
extends AbstractMultiFormatDataSchemaResolver {
    public static MultiFormatDataSchemaResolver withBuiltinFormats(String resolverPath) {
        return new MultiFormatDataSchemaResolver(resolverPath, BUILTIN_FORMAT_PARSER_FACTORIES);
    }

    public MultiFormatDataSchemaResolver(String resolverPath, List<DataSchemaParserFactory> parsersForFormats) {
        this(resolverPath, parsersForFormats, Collections.singletonList(SchemaDirectoryName.PEGASUS));
    }

    public MultiFormatDataSchemaResolver(String resolverPath, List<DataSchemaParserFactory> parsersForFormats, List<SchemaDirectory> schemaDirectories) {
        for (DataSchemaParserFactory parserForFormat : parsersForFormats) {
            FileDataSchemaResolver resolver = new FileDataSchemaResolver(parserForFormat, resolverPath, this);
            resolver.setExtension("." + parserForFormat.getLanguageExtension());
            resolver.setSchemaDirectories(schemaDirectories);
            this.addResolver(resolver);
        }
        this.setSchemaDirectories(schemaDirectories);
    }
}

