/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.DataSchemaConstants;

public final class Name
implements Comparable<Name> {
    private boolean _isEmpty = true;
    private boolean _hasError = false;
    private String _name = "";
    private String _namespace = "";
    private String _fullName = "";

    public Name() {
    }

    public Name(String fullName) {
        StringBuilder errorMessageBuilder = new StringBuilder();
        this.setName(fullName, errorMessageBuilder);
        if (errorMessageBuilder.length() > 0) {
            throw new IllegalArgumentException(errorMessageBuilder.toString());
        }
    }

    public Name(String fullName, StringBuilder errorMessageBuilder) {
        this.setName(fullName, errorMessageBuilder);
    }

    public Name(String name, String namespace, StringBuilder errorMessageBuilder) {
        this.setName(name, namespace, errorMessageBuilder);
    }

    public boolean setName(String fullName, StringBuilder errorMessageBuilder) {
        String name;
        String namespace;
        boolean ok = true;
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            namespace = "";
            name = fullName;
        } else {
            namespace = fullName.substring(0, index);
            name = index + 1 < fullName.length() ? fullName.substring(index + 1) : "";
        }
        this._name = name;
        this._namespace = namespace;
        this._fullName = fullName;
        this._isEmpty = false;
        if (!Name.isValidName(fullName)) {
            errorMessageBuilder.append("\"").append(fullName).append("\" is an invalid name.\n");
            ok = false;
        }
        this._hasError |= !ok;
        return ok;
    }

    public boolean setName(String name, String namespace, StringBuilder errorMessageBuilder) {
        boolean ok = true;
        this._isEmpty = false;
        this._name = name;
        this._namespace = namespace;
        String string = this._fullName = namespace.isEmpty() ? this._name : this._namespace + "." + this._name;
        if (!Name.isValidName(name)) {
            errorMessageBuilder.append("\"").append(name).append("\" is an invalid name.\n");
            ok = false;
        }
        if (!Name.isValidNamespace(namespace)) {
            errorMessageBuilder.append("\"").append(namespace).append("\" is an invalid namespace.\n");
            ok = false;
        }
        this._hasError |= !ok;
        return ok;
    }

    public boolean isEmpty() {
        return this._isEmpty;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getFullName() {
        return this._fullName;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == Name.class) {
            Name other = (Name)object;
            return this._fullName.equals(other._fullName);
        }
        return false;
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public static boolean isFullName(String name) {
        return name.indexOf(46) >= 0;
    }

    public static boolean isValidName(String name) {
        return DataSchemaConstants.NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isValidNamespace(String namespace) {
        return DataSchemaConstants.NAMESPACE_PATTERN.matcher(namespace).matches();
    }

    public static boolean isValidUnqualifiedName(String name) {
        return DataSchemaConstants.UNQUALIFIED_NAME_PATTERN.matcher(name).matches();
    }

    @Override
    public int compareTo(Name o) {
        return this.getFullName().compareTo(o.getFullName());
    }
}

