/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.schema.ComplexDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaConstants;
import com.linkedin.data.schema.StringDataSchema;

public final class MapDataSchema
extends ComplexDataSchema {
    private DataSchema _values = DataSchemaConstants.NULL_DATA_SCHEMA;
    private StringDataSchema _key = DataSchemaConstants.STRING_DATA_SCHEMA;
    private boolean _valuesDeclaredInline = false;

    public MapDataSchema(DataSchema values) {
        super(DataSchema.Type.MAP);
        this.setValues(values);
    }

    public void setValues(DataSchema values) {
        if (values == null) {
            this._values = DataSchemaConstants.NULL_DATA_SCHEMA;
            this.setHasError();
        } else {
            this._values = values;
        }
    }

    public DataSchema getValues() {
        return this._values;
    }

    public StringDataSchema getKey() {
        return this._key;
    }

    public void setKey(StringDataSchema key) {
        if (key == null) {
            this._key = DataSchemaConstants.STRING_DATA_SCHEMA;
            this.setHasError();
        } else {
            this._key = key;
        }
    }

    public void setValuesDeclaredInline(boolean valuesDeclaredInline) {
        this._valuesDeclaredInline = valuesDeclaredInline;
    }

    public boolean isValuesDeclaredInline() {
        return this._valuesDeclaredInline;
    }

    @Override
    public String getUnionMemberKey() {
        return "map";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == MapDataSchema.class) {
            MapDataSchema other = (MapDataSchema)object;
            return super.equals(other) && this._values.equals(other._values) && this._key.equals(other._key);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this._values.hashCode() ^ this._key.hashCode();
    }
}

