/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.schema;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.DataLocation;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.message.MessageUtil;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaLocation;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.PegasusSchemaParser;
import com.linkedin.data.schema.PrimitiveDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.SchemaParser;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.grammar.PdlSchemaParser;
import com.linkedin.data.schema.resolver.DefaultDataSchemaResolver;
import com.linkedin.data.schema.validation.CoercionMode;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractSchemaParser
implements PegasusSchemaParser {
    private final StringBuilder _calleeMessageBuilder = new StringBuilder();
    private final JacksonDataCodec _codec = new JacksonDataCodec();
    private DataSchemaLocation _location = DataSchemaLocation.NO_LOCATION;
    private static final String NAMESPACE_KEY = "namespace";
    private static final String SUBSTITUTE_FOR_REQUIRED_STRING = new String();
    private String _currentNamespace = "";
    private String _currentPackage = "";
    private final Map<Object, DataLocation> _dataLocationMap = new IdentityHashMap<Object, DataLocation>();
    private final List<DataSchema> _topLevelDataSchemas = new ArrayList<DataSchema>();
    private final DataSchemaResolver _resolver;
    private ValidationOptions _validationOptions = AbstractSchemaParser.getDefaultSchemaParserValidationOptions();

    protected AbstractSchemaParser(DataSchemaResolver resolver) {
        this._resolver = resolver == null ? new DefaultDataSchemaResolver() : resolver;
    }

    @Override
    public DataSchemaResolver getResolver() {
        return this._resolver;
    }

    @Override
    public List<DataSchema> topLevelDataSchemas() {
        return Collections.unmodifiableList(this._topLevelDataSchemas);
    }

    public Map<Object, DataLocation> dataLocationMap() {
        return this._dataLocationMap;
    }

    public void setValidationOptions(ValidationOptions validationOptions) {
        this._validationOptions = validationOptions;
    }

    public ValidationOptions getValidationOptions() {
        return this._validationOptions;
    }

    protected boolean bindNameToSchema(Name name, List<Name> aliasNames, NamedDataSchema schema) {
        boolean ok = true;
        ok &= this.bindNameToSchema(name, schema);
        if (aliasNames != null) {
            for (Name aliasName : aliasNames) {
                if (Objects.equals(aliasName.getFullName(), name.getFullName())) continue;
                ok &= this.bindNameToSchema(aliasName, schema);
            }
        }
        return ok;
    }

    public boolean bindNameToSchema(Name name, NamedDataSchema schema) {
        boolean ok = true;
        String fullName = name.getFullName();
        if (name.isEmpty()) {
            ok = false;
        }
        if (ok && DataSchemaUtil.typeStringToPrimitiveDataSchema(fullName) != null) {
            this.startErrorMessage(name).append("\"").append(fullName).append("\" is a pre-defined type and cannot be redefined.\n");
            ok = false;
        }
        if (ok) {
            DataSchemaLocation found = this.getResolver().existingSchemaLocation(name.getFullName());
            if (found != null) {
                if (found == DataSchemaLocation.NO_LOCATION) {
                    this.startErrorMessage(name).append("\"").append(name.getFullName()).append("\" already defined as " + this.getResolver().existingDataSchema(name.getFullName()) + ".\n");
                } else {
                    this.startErrorMessage(name).append("\"").append(name.getFullName()).append("\" already defined at " + found + ".\n");
                }
                ok = false;
            } else {
                this.getResolver().bindNameToSchema(name, schema, this.getLocation());
            }
        }
        return ok;
    }

    @Override
    public DataSchema lookupName(String fullName) {
        DataSchema schema = DataSchemaUtil.typeStringToPrimitiveDataSchema(fullName);
        if (schema == null && (schema = this.getResolver().findDataSchema(fullName, this.errorMessageBuilder())) != null) {
            this.checkForCycleWithInclude(((NamedDataSchema)schema).getFullName());
        }
        return schema;
    }

    protected void checkForCycleWithInclude(String fullName) {
        LinkedHashMap<String, Boolean> pendingSchemas = this.getResolver().getPendingSchemas();
        if (!pendingSchemas.containsKey(fullName)) {
            return;
        }
        boolean cycleFound = false;
        ArrayList<String> schemasInCycle = new ArrayList<String>(pendingSchemas.size());
        for (Map.Entry<String, Boolean> pendingSchema : pendingSchemas.entrySet()) {
            if (!cycleFound && !pendingSchema.getKey().equals(fullName)) continue;
            cycleFound = true;
            schemasInCycle.add(pendingSchema.getKey());
        }
        if (schemasInCycle.stream().anyMatch(pendingSchemas::get)) {
            this.startErrorMessage(fullName).append("\"").append(fullName).append("\"").append(" cannot be parsed as it is part of circular reference involving includes.").append(" Record(s) with include in the cycle: ").append(schemasInCycle);
        }
    }

    protected DataSchema stringToDataSchema(String name) {
        DataSchema schema = null;
        String fullName = this.computeFullName(name);
        DataSchema found = this.lookupName(fullName);
        if (found == null && !name.equals(fullName)) {
            found = this.lookupName(name);
        }
        if (found == null) {
            StringBuilder sb = this.startErrorMessage(name).append("\"").append(name).append("\"");
            if (!name.equals(fullName)) {
                sb.append(" or \"").append(fullName).append("\"");
            }
            sb.append(" cannot be resolved.\n");
        } else {
            schema = found;
        }
        return schema;
    }

    public String computeFullName(String name) {
        PrimitiveDataSchema schema = DataSchemaUtil.typeStringToPrimitiveDataSchema(name);
        String fullname = schema != null ? name : (Name.isFullName(name) || this.getCurrentNamespace().isEmpty() ? name : this.getCurrentNamespace() + "." + name);
        return fullname;
    }

    public void setCurrentNamespace(String namespace) {
        this._currentNamespace = namespace;
    }

    public String getCurrentNamespace() {
        return this._currentNamespace;
    }

    public void setCurrentPackage(String packageName) {
        this._currentPackage = packageName;
    }

    public String getCurrentPackage() {
        return this._currentPackage;
    }

    @Override
    public abstract StringBuilder errorMessageBuilder();

    @Override
    public boolean hasError() {
        return this.errorMessageBuilder().length() != 0;
    }

    @Override
    public String errorMessage() {
        return this.errorMessageBuilder().toString();
    }

    protected List<Object> jsonInputStreamToObjects(InputStream inputStream) {
        List<Object> objects;
        try {
            objects = this._codec.parse(inputStream, this.errorMessageBuilder(), this.dataLocationMap());
        }
        catch (IOException e) {
            this.errorMessageBuilder().append(e).append("\n");
            e.printStackTrace();
            return Collections.emptyList();
        }
        return objects;
    }

    protected List<Object> jsonReaderToObjects(Reader reader) {
        List<Object> objects;
        try {
            objects = this._codec.parse(reader, this.errorMessageBuilder(), this.dataLocationMap());
        }
        catch (IOException e) {
            this.errorMessageBuilder().append(e).append("\n");
            e.printStackTrace();
            return Collections.emptyList();
        }
        return objects;
    }

    protected Name getNameFromDataMap(DataMap map, String nameKey, String currentNamespace) {
        String nameString = this.getString(map, nameKey, true);
        String namespaceString = this.getString(map, NAMESPACE_KEY, false);
        Name name = this.getName(nameString, namespaceString, currentNamespace);
        this.addToDataLocationMap(name, this.lookupDataLocation(nameString));
        return name;
    }

    protected String getPackageFromDataMap(DataMap map, String packageKey, String currentPackage, String currentNamespace, Name name) {
        String packageName = this.getString(map, packageKey, false);
        if (packageName == null) {
            packageName = currentPackage;
            if (name.getNamespace().startsWith(currentNamespace + ".") && packageName != null && !packageName.isEmpty()) {
                packageName = packageName + name.getNamespace().substring(currentNamespace.length());
            }
        }
        return packageName;
    }

    protected Name getName(String name, String namespace, String currentNamespace) {
        Name n = new Name();
        if (name != null && name != SUBSTITUTE_FOR_REQUIRED_STRING) {
            if (Name.isFullName(name)) {
                n.setName(name, this.startCalleeMessageBuilder());
                this.appendCalleeMessage(name);
            } else {
                if (namespace == null) {
                    namespace = currentNamespace;
                }
                n.setName(name, namespace, this.startCalleeMessageBuilder());
                this.appendCalleeMessage(name);
            }
        }
        return n;
    }

    protected String getString(DataMap map, String key, boolean required) {
        String value = null;
        Object obj = map.get(key);
        if (obj != null) {
            if (obj instanceof String) {
                value = (String)obj;
            } else {
                this.startErrorMessage(obj).append(key).append(" with value ").append(obj).append(" is not a string.\n");
            }
        } else if (required) {
            this.startErrorMessage(map).append(key).append(" (with string value) is required but it is not present.\n");
        }
        if (required && value == null) {
            value = SUBSTITUTE_FOR_REQUIRED_STRING;
        }
        return value;
    }

    protected Integer getInteger(DataMap map, String key, boolean required) {
        Integer value = null;
        Object obj = map.get(key);
        if (obj != null) {
            if (obj instanceof Integer) {
                value = (Integer)obj;
            } else if (obj instanceof Long) {
                value = ((Long)obj).intValue();
            } else {
                this.startErrorMessage(obj).append(key).append(" with value ").append(obj).append(" is not an integer.\n");
            }
        } else if (required) {
            this.startErrorMessage(map).append(key).append(" (with integer value) is required but it is not present.\n");
        }
        if (required && value == null) {
            value = 0;
        }
        return value;
    }

    protected Boolean getBoolean(DataMap map, String key, boolean required) {
        Boolean value = null;
        Object obj = map.get(key);
        if (obj != null) {
            if (obj instanceof Boolean) {
                value = (Boolean)obj;
            } else {
                this.startErrorMessage(obj).append(key).append(" with value ").append(obj).append(" is not a boolean.\n");
            }
        } else if (required) {
            this.startErrorMessage(map).append(key).append(" (with boolean value) is required but it is not present.\n");
        }
        if (required && value == null) {
            value = false;
        }
        return value;
    }

    protected DataMap getDataMap(DataMap map, String key, boolean required) {
        DataMap result = null;
        Object obj = map.get(key);
        if (obj != null) {
            if (obj instanceof DataMap) {
                result = (DataMap)obj;
            } else {
                this.startErrorMessage(obj).append(key).append(" is not a map.\n");
            }
        } else if (required) {
            this.startErrorMessage(map).append(key).append(" (with map value) is required but it is not present.\n");
        }
        if (required && result == null) {
            result = new DataMap();
        }
        return result;
    }

    protected DataList getDataList(DataMap map, String key, boolean required) {
        DataList list = null;
        Object obj = map.get(key);
        if (obj != null) {
            if (obj instanceof DataList) {
                list = (DataList)obj;
            } else {
                this.startErrorMessage(obj).append(key).append(" is not an array.\n");
            }
        } else if (required) {
            this.startErrorMessage(map).append(key).append(" (with array value) is required but it is not present.\n");
        }
        if (required && list == null) {
            list = new DataList();
        }
        return list;
    }

    protected List<String> getStringList(DataMap map, String key, boolean required) {
        DataList dataList = this.getDataList(map, key, required);
        ArrayList<String> list = null;
        if (dataList != null) {
            list = new ArrayList<String>();
            for (Object o : dataList) {
                if (o instanceof String) {
                    list.add((String)o);
                    continue;
                }
                this.startErrorMessage(o).append(o).append(" is not a string.\n");
            }
        }
        return list;
    }

    protected Map<String, Object> extractProperties(DataMap map, Set<String> reserved) {
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            if (reserved.contains(key)) continue;
            Object value = e.getValue();
            Object replaced = props.put(key, value);
            assert (replaced == null);
        }
        return props;
    }

    protected void validateDefaults(RecordDataSchema recordSchema) {
        for (RecordDataSchema.Field field : recordSchema.getFields()) {
            Object value = field.getDefault();
            if (value != null) {
                DataSchema valueSchema = field.getType();
                ValidationResult result = ValidateDataAgainstSchema.validate(value, valueSchema, this._validationOptions);
                if (!result.isValid()) {
                    this.startErrorMessage(value).append("Default value ").append(value).append(" of field \"").append(field.getName()).append("\" declared in record \"").append(recordSchema.getFullName()).append("\" failed validation.\n");
                    MessageUtil.appendMessages(this.errorMessageBuilder(), result.getMessages());
                }
                Object fixed = result.getFixed();
                field.setDefault(fixed);
            }
            if (!(field.getDefault() instanceof DataComplex)) continue;
            ((DataComplex)field.getDefault()).setReadOnly();
        }
    }

    @Override
    public void setLocation(DataSchemaLocation location) {
        this._location = location;
    }

    @Override
    public DataSchemaLocation getLocation() {
        return this._location;
    }

    protected void addToDataLocationMap(Object object, DataLocation dataLocation) {
        if (object != null && dataLocation != null) {
            this.dataLocationMap().put(object, dataLocation);
        }
    }

    protected DataLocation lookupDataLocation(Object object) {
        return this.dataLocationMap().get(object);
    }

    protected StringBuilder startErrorMessage(Object object) {
        DataLocation dataLocation;
        if (object != null && (dataLocation = this.lookupDataLocation(object)) != null) {
            this.errorMessageBuilder().append(dataLocation).append(": ");
        }
        return this.errorMessageBuilder();
    }

    protected StringBuilder startCalleeMessageBuilder() {
        assert (this._calleeMessageBuilder.length() == 0);
        return this._calleeMessageBuilder;
    }

    protected void appendCalleeMessage(Object object) {
        int len = this._calleeMessageBuilder.length();
        if (len != 0) {
            this.startErrorMessage(object).append((CharSequence)this._calleeMessageBuilder);
            this._calleeMessageBuilder.delete(0, len);
        }
    }

    protected void checkTyperefCycle(TyperefDataSchema sourceSchema, DataSchema refSchema) {
        if (refSchema == null) {
            return;
        }
        if (refSchema.getType() == DataSchema.Type.TYPEREF) {
            if (sourceSchema.getFullName().equals(((TyperefDataSchema)refSchema).getFullName())) {
                this.startErrorMessage(sourceSchema.getFullName()).append("\"").append(sourceSchema.getFullName()).append("\"").append(" cannot be parsed as the typeref has a circular reference to itself.");
            } else {
                this.checkTyperefCycle(sourceSchema, ((TyperefDataSchema)refSchema).getRef());
            }
        } else if (refSchema.getType() == DataSchema.Type.UNION) {
            for (UnionDataSchema.Member member : ((UnionDataSchema)refSchema).getMembers()) {
                this.checkTyperefCycle(sourceSchema, member.getType());
            }
        } else if (refSchema.getType() == DataSchema.Type.ARRAY) {
            this.checkTyperefCycle(sourceSchema, ((ArrayDataSchema)refSchema).getItems());
        } else if (refSchema.getType() == DataSchema.Type.MAP) {
            this.checkTyperefCycle(sourceSchema, ((MapDataSchema)refSchema).getValues());
        }
    }

    protected void addTopLevelSchema(DataSchema schema) {
        this._topLevelDataSchemas.add(schema);
    }

    public static final ValidationOptions getDefaultSchemaParserValidationOptions() {
        return new ValidationOptions(RequiredMode.CAN_BE_ABSENT_IF_HAS_DEFAULT, CoercionMode.NORMAL);
    }

    public static PegasusSchemaParser parserForFile(File schemaSourceFile, DataSchemaResolver resolver) {
        return AbstractSchemaParser.parserForFileExtension(FileUtil.getExtension(schemaSourceFile), resolver);
    }

    public static PegasusSchemaParser parserForFileExtension(String extension, DataSchemaResolver resolver) {
        if (extension.equals("pdsc")) {
            return new SchemaParser(resolver);
        }
        if (extension.equals("pdl")) {
            return new PdlSchemaParser(resolver);
        }
        throw new IllegalArgumentException("Unrecognized file extension: " + extension);
    }
}

