/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.data.element;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.SimpleDataElement;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DataElementUtil {
    public static DataElement element(Object value, DataSchema schema, String path) throws IllegalArgumentException {
        return DataElementUtil.element((DataElement)new SimpleDataElement(value, schema), path);
    }

    public static DataElement element(Object value, DataSchema schema, String path, char separator) throws IllegalArgumentException {
        return DataElementUtil.element(new SimpleDataElement(value, schema), path, separator);
    }

    public static DataElement element(Object value, DataSchema schema, Object[] path) throws IllegalArgumentException {
        return DataElementUtil.element((DataElement)new SimpleDataElement(value, schema), path);
    }

    public static DataElement element(Object value, DataSchema schema, Iterable<Object> path) throws IllegalArgumentException {
        return DataElementUtil.element((DataElement)new SimpleDataElement(value, schema), path);
    }

    public static DataElement element(DataElement element, String path) throws IllegalArgumentException {
        return DataElementUtil.element(element, DataElementUtil.pathToList(path, DataElement.SEPARATOR.charValue()));
    }

    public static DataElement element(DataElement element, String path, char separator) throws IllegalArgumentException {
        return DataElementUtil.element(element, DataElementUtil.pathToList(path, separator));
    }

    public static DataElement element(DataElement element, Object[] path) throws IllegalArgumentException {
        return DataElementUtil.element(element, Arrays.asList(path));
    }

    public static DataElement element(DataElement element, Iterable<Object> path) throws IllegalArgumentException {
        DataElement currentElement = element;
        for (Object component : path) {
            Object name;
            if (currentElement.getValue().getClass() == DataMap.class && component.getClass() != String.class) {
                name = component.toString();
            } else if (currentElement.getValue().getClass() == DataList.class && component.getClass() != Integer.class) {
                try {
                    name = Integer.parseInt(component.toString());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            } else {
                name = component;
            }
            Object childValue = currentElement.getChild(name);
            if (childValue == null) {
                return null;
            }
            DataSchema childSchema = null;
            DataSchema schema = currentElement.getSchema();
            if (schema != null) {
                schema = schema.getDereferencedDataSchema();
                switch (schema.getType()) {
                    case ARRAY: {
                        childSchema = ((ArrayDataSchema)schema).getItems();
                        break;
                    }
                    case MAP: {
                        childSchema = ((MapDataSchema)schema).getValues();
                        break;
                    }
                    case UNION: {
                        childSchema = ((UnionDataSchema)schema).getTypeByMemberKey((String)name);
                        break;
                    }
                    case RECORD: {
                        RecordDataSchema.Field field = ((RecordDataSchema)schema).getField((String)name);
                        if (field == null) break;
                        childSchema = field.getType();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(currentElement.pathAsString() + " has schema of type " + (Object)((Object)schema.getType()) + " which cannot have child, but has child with name \"" + name + "\"");
                    }
                }
            }
            currentElement = new SimpleDataElement(childValue, name, childSchema, currentElement);
        }
        return currentElement;
    }

    static List<Object> pathToList(String path, char separator) throws IllegalArgumentException {
        if (path.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>(path.length() / 4);
        int len = path.length();
        int index = 0;
        if (path.charAt(index) != separator) {
            throw new IllegalArgumentException("\"" + separator + "\" expected at index " + index + " of \"" + path + "\"");
        }
        while (index < len) {
            int end;
            int start = index;
            for (end = start + 1; end < len && path.charAt(end) != separator; ++end) {
            }
            if (end - start == 1) {
                throw new IllegalArgumentException("Path component starting at index " + index + " of \"" + path + "\" is empty");
            }
            String component = path.substring(start + 1, end);
            list.add(component);
            index = end;
        }
        return list;
    }
}

